/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.translate;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.TransferMode;
import javafx.stage.Modality;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.bind.FxComponentBinding;
import org.tentackle.fx.rdc.RdcFxRdcBundle;
import org.tentackle.fx.rdc.RdcUtilities;
import org.tentackle.misc.IdentifiableKey;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoRuntimeException;
import org.tentackle.pdo.PdoUtilities;
import org.tentackle.pdo.PersistentDomainObject;

public class PdoComponentAddon<T extends PersistentDomainObject<T>> {
    public static final String PDO_STYLE = "tt-pdo-style";
    private final FxComponent component;
    private final Supplier<T> pdoSupplier;
    private final Consumer<T> pdoConsumer;
    private boolean inSearchOrEdit;
    private T pdo;

    public PdoComponentAddon(FxComponent component, Supplier<T> pdoSupplier, Consumer<T> pdoConsumer) {
        this.component = component;
        this.pdoSupplier = pdoSupplier;
        this.pdoConsumer = pdoConsumer;
        Control control = (Control)component;
        control.addEventFilter(KeyEvent.ANY, event -> {
            if (!(event.isAltDown() || event.isControlDown() || event.isMetaDown() || event.isShiftDown() || event.isShortcutDown() || !control.getStyleClass().contains((Object)PDO_STYLE))) {
                if (event.getCode() == KeyCode.F2) {
                    event.consume();
                    if (event.getEventType() == KeyEvent.KEY_PRESSED) {
                        Platform.runLater(this::edit);
                    }
                } else if (event.getCode() == KeyCode.F3) {
                    event.consume();
                    if (event.getEventType() == KeyEvent.KEY_PRESSED) {
                        Platform.runLater(this::search);
                    }
                }
            }
        });
        control.setOnDragDetected(event -> {
            PersistentDomainObject pdo = (PersistentDomainObject)pdoSupplier.get();
            if (pdo != null && RdcUtilities.getInstance().createDragboard((Node)component, pdo) != null) {
                event.consume();
            }
        });
        control.setOnDragOver(e -> {
            IdentifiableKey key;
            String idString;
            Class type;
            if (e.getGestureSource() != component && (type = component.getType()) != null && (idString = e.getDragboard().getString()) != null && !idString.isEmpty() && type.isAssignableFrom((key = PdoUtilities.getInstance().idStringToIdentifiableKey(idString)).getIdentifiableClass())) {
                e.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
                e.consume();
            }
        });
        control.setOnDragDropped(e -> {
            PersistentDomainObject<?> pdoToDrop;
            DomainContext context;
            FxComponentBinding binding;
            Class type = component.getType();
            boolean dropped = false;
            if (type != null && (binding = component.getBinding()) != null && (context = (DomainContext)binding.getBinder().getBindingProperty(DomainContext.class)) != null && (pdoToDrop = RdcUtilities.getInstance().getPdoFromDragboard(e.getDragboard(), context)) != null && type.isAssignableFrom(pdoToDrop.getEffectiveClass())) {
                pdoConsumer.accept(pdoToDrop);
                e.setDropCompleted(true);
                dropped = true;
            }
            if (!dropped) {
                e.consume();
            }
        });
        if (!control.getStyleClass().contains((Object)PDO_STYLE)) {
            SeparatorMenuItem separatorItem;
            ContextMenu menu;
            control.getStyleClass().add((Object)PDO_STYLE);
            if (control.getContextMenu() == null) {
                menu = new ContextMenu();
                control.setContextMenu(menu);
                separatorItem = null;
            } else {
                separatorItem = new SeparatorMenuItem();
                menu = control.getContextMenu();
                menu.getItems().add((Object)separatorItem);
            }
            MenuItem editItem = new MenuItem(RdcFxRdcBundle.getString("EDIT"));
            editItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.F2, new KeyCombination.Modifier[0]));
            editItem.setOnAction(event -> this.edit());
            MenuItem searchItem = new MenuItem(RdcFxRdcBundle.getString("SEARCH"));
            searchItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.F3, new KeyCombination.Modifier[0]));
            searchItem.setOnAction(event -> this.search());
            menu.getItems().addAll((Object[])new MenuItem[]{editItem, searchItem});
            menu.setOnShowing(arg_0 -> PdoComponentAddon.lambda$new$6(control, editItem, pdoSupplier, menu, searchItem, (MenuItem)separatorItem, arg_0));
        }
    }

    public T getPdo() {
        return this.pdo;
    }

    public void setPdo(T pdo) {
        this.pdo = pdo;
    }

    public boolean isInSearchOrEdit() {
        return this.inSearchOrEdit;
    }

    public void edit() {
        if (!this.inSearchOrEdit) {
            this.pdo = (PersistentDomainObject)this.pdoSupplier.get();
            if (this.pdo != null) {
                this.inSearchOrEdit = true;
                try {
                    ObservableList pdoList = FXCollections.observableArrayList();
                    pdoList.add(this.pdo);
                    RdcUtilities.getInstance().displayCrudStage(this.pdo, pdoList, !this.pdo.isImmutable(), Modality.APPLICATION_MODAL, (Window)Fx.getStage((Node)((Node)this.component)), p -> {
                        this.pdo = p;
                        this.inSearchOrEdit = false;
                    }, null);
                }
                catch (RuntimeException rx) {
                    this.inSearchOrEdit = false;
                    throw rx;
                }
            }
        }
    }

    public void search() {
        if (!this.inSearchOrEdit) {
            Object proxy;
            try {
                proxy = this.createPdo();
            }
            catch (PdoRuntimeException px) {
                if (this.pdo == null) {
                    return;
                }
                proxy = this.pdo.on();
            }
            this.inSearchOrEdit = true;
            try {
                this.searchPdo(proxy, found -> {
                    this.inSearchOrEdit = false;
                    if (found != null && this.component.isChangeable()) {
                        this.pdo = found;
                        this.component.setViewValue(this.pdo);
                        this.component.updateModel();
                    }
                });
            }
            catch (RuntimeException rx) {
                this.inSearchOrEdit = false;
                throw rx;
            }
        }
    }

    public T createPdo() {
        Class pdoClass = this.component.getType();
        DomainContext context = this.getDomainContext();
        if (context == null) {
            throw new FxRuntimeException("missing binding property for DomainContext");
        }
        return (T)Pdo.create((Class)pdoClass, (DomainContext)context);
    }

    public DomainContext getDomainContext() {
        DomainContext context = null;
        context = this.component.getParentContainer() != null ? (DomainContext)this.component.getBinding().getBinder().getBindingProperty(DomainContext.class) : (this.component.getTableCell() != null ? (DomainContext)this.component.getTableCell().getColumnConfiguration().getTableConfiguration().getBinder().getBindingProperty(DomainContext.class) : (DomainContext)((Node)this.component).getProperties().get(DomainContext.class));
        return context;
    }

    public void searchPdo(T proxy, Consumer<T> selectedItem) {
        RdcUtilities.getInstance().displaySearchStage(proxy, Modality.APPLICATION_MODAL, (Window)Fx.getStage((Node)((Node)this.component)), true, list -> selectedItem.accept(list.isEmpty() ? null : (PersistentDomainObject)list.get(0)));
    }

    public List<T> selectAll(T proxy) {
        return proxy.selectAllCached();
    }

    private static /* synthetic */ void lambda$new$6(Control control, MenuItem editItem, Supplier pdoSupplier, ContextMenu menu, MenuItem searchItem, MenuItem separatorItem, WindowEvent event) {
        if (control.getStyleClass().contains((Object)PDO_STYLE)) {
            editItem.setDisable(pdoSupplier.get() == null);
        } else {
            menu.getItems().remove((Object)searchItem);
            menu.getItems().remove((Object)editItem);
            if (separatorItem != null) {
                menu.getItems().remove((Object)separatorItem);
            }
        }
    }
}

