/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import javafx.scene.Node;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.image.ImageView;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import org.tentackle.common.BundleFactory;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.component.FxTableView;
import org.tentackle.fx.rdc.DefaultPdoEditor;
import org.tentackle.fx.rdc.GuiProvider;
import org.tentackle.fx.rdc.GuiProviderService;
import org.tentackle.fx.rdc.PdoEditor;
import org.tentackle.fx.rdc.PdoFinder;
import org.tentackle.fx.rdc.PdoTreeItem;
import org.tentackle.fx.rdc.Rdc;
import org.tentackle.fx.rdc.RdcUtilities;
import org.tentackle.fx.rdc.search.DefaultPdoFinder;
import org.tentackle.fx.rdc.table.TableUtilities;
import org.tentackle.fx.table.TableConfiguration;
import org.tentackle.misc.IdentifiableKey;
import org.tentackle.misc.ShortLongText;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.PersistentDomainObject;

public class DefaultGuiProvider<T extends PersistentDomainObject<T>>
implements GuiProvider<T> {
    private T pdo;
    private Boolean bundleProvided;
    private ResourceBundle bundle;

    public DefaultGuiProvider(T pdo) {
        this.setPdo(pdo);
        GuiProviderService annotation = this.getClass().getAnnotation(GuiProviderService.class);
        if (annotation != null) {
            this.bundleProvided = !annotation.noBundle();
        }
    }

    @Override
    public boolean isBundleProvided() {
        if (this.bundleProvided == null) {
            try {
                this.getBundle();
                this.bundleProvided = true;
            }
            catch (MissingResourceException mx) {
                this.bundleProvided = false;
            }
        }
        return this.bundleProvided;
    }

    @Override
    public ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = BundleFactory.getBundle((String)this.getClass().getName());
        }
        return this.bundle;
    }

    public T getPdo() {
        return this.pdo;
    }

    public void setPdo(T pdo) {
        this.pdo = (PersistentDomainObject)Objects.requireNonNull(pdo, "pdo");
    }

    public DomainContext getDomainContext() {
        return this.pdo.getDomainContext();
    }

    @Override
    public ImageView createIcon() {
        return Fx.createImageView((String)"unknown");
    }

    @Override
    public boolean editorExists() {
        return false;
    }

    @Override
    public boolean isEditAllowed() {
        return this.editorExists() && this.pdo.isEditAllowed();
    }

    @Override
    public boolean isViewAllowed() {
        return this.editorExists() && this.pdo.isViewAllowed();
    }

    @Override
    public PdoEditor<T> createEditor() {
        if (this.editorExists()) {
            return new DefaultPdoEditor(this.getPdo().getEffectiveClass(), this.isBundleProvided() ? this.getBundle() : null);
        }
        throw new FxRuntimeException("no controller for " + this.pdo.getEffectiveClass().getName());
    }

    @Override
    public boolean finderExists() {
        return false;
    }

    @Override
    public PdoFinder<T> createFinder() {
        if (this.finderExists()) {
            return (PdoFinder)Fx.load(DefaultPdoFinder.class);
        }
        throw new FxRuntimeException("no finder for " + this.pdo.getEffectiveClass().getName());
    }

    @Override
    public Dragboard createDragboard(Node node) {
        return RdcUtilities.getInstance().createDragboard(node, (PersistentDomainObject<?>)this.pdo);
    }

    @Override
    public boolean isDragAccepted(DragEvent event) {
        return false;
    }

    protected IdentifiableKey<PersistentDomainObject<?>> getPdoKeyFromDragboard(Dragboard dragboard) {
        return RdcUtilities.getInstance().getPdoKeyFromDragboard(dragboard);
    }

    @Override
    public void dropDragboard(Dragboard dragbord) {
        PersistentDomainObject<?> pdoToDrop = RdcUtilities.getInstance().getPdoFromDragboard(dragbord, this.pdo.getDomainContext());
        if (pdoToDrop != null) {
            this.dropPdo(pdoToDrop);
        }
    }

    public void dropPdo(PersistentDomainObject<?> pdoToDrop) {
        throw new FxRuntimeException("dropPdo is not implemented for " + this.pdo.getEffectiveClass().getName());
    }

    public TableConfiguration<T> createTableConfiguration() {
        return TableUtilities.getInstance().createTableConfiguration(this.getPdo().getEffectiveClass(), this.isBundleProvided() ? this.getBundle() : null);
    }

    @Override
    public FxTableView<T> createTableView() {
        TableConfiguration<T> config = this.createTableConfiguration();
        if (config.getBindingType() == TableConfiguration.BINDING.YES) {
            config.getBinder().bind();
        } else if (config.getBindingType() == TableConfiguration.BINDING.INHERITED) {
            config.getBinder().bindAllInherited();
        }
        if (config.getBindingType() != TableConfiguration.BINDING.NO) {
            config.getBinder().assertAllBound();
        }
        FxTableView tableView = (FxTableView)Fx.createNode(TableView.class);
        config.configure(tableView);
        return tableView;
    }

    public String toString() {
        return this.getClass().getName() + " for " + this.getPdo().toGenericString();
    }

    @Override
    public boolean providesTreeChildObjects() {
        return false;
    }

    @Override
    public <P extends PersistentDomainObject<P>> Collection<? extends PersistentDomainObject<?>> getTreeChildObjects(P parent) {
        return new ArrayList();
    }

    @Override
    public int getTreeExpandMaxDepth() {
        return 0;
    }

    @Override
    public boolean providesTreeParentObjects() {
        return false;
    }

    @Override
    public <P extends PersistentDomainObject<P>> Collection<? extends PersistentDomainObject<?>> getTreeParentObjects(P parent) {
        return new ArrayList();
    }

    @Override
    public T getTreeRoot() {
        return this.getPdo();
    }

    @Override
    public <P extends PersistentDomainObject<P>> String getTreeText(P parent) {
        return this.getPdo().toString();
    }

    @Override
    public <P extends PersistentDomainObject<P>> String getToolTipText(P parent) {
        if (this.getPdo() instanceof ShortLongText) {
            return ((ShortLongText)this.getPdo()).getLongText();
        }
        return this.getTreeText(parent);
    }

    @Override
    public boolean stopTreeExpansion() {
        return false;
    }

    @Override
    public TreeItem<T> createTreeItem() {
        return new PdoTreeItem<T>(this.pdo);
    }

    @Override
    public TreeCell<T> createTreeCell() {
        return Rdc.createTreeCell();
    }
}

