/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.prefs.BackingStoreException;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.tentackle.common.Service;
import org.tentackle.fx.rdc.FileUtilitiesHolder;
import org.tentackle.log.Logger;
import org.tentackle.prefs.PersistedPreferences;
import org.tentackle.prefs.PersistedPreferencesFactory;

@Service(value=FileUtilities.class)
public class FileUtilities {
    private static final Logger LOGGER = Logger.get(FileUtilities.class);

    public static FileUtilities getInstance() {
        return FileUtilitiesHolder.INSTANCE;
    }

    public File selectFile(String prefName, String prefKey, String fileExtension, String fileType, Stage owner) {
        PersistedPreferences prefs = PersistedPreferences.userRoot().node(prefName);
        String lastName = prefs.get(prefKey, null);
        FileChooser fc = new FileChooser();
        if (lastName != null) {
            fc.setInitialFileName(lastName);
        }
        fc.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(fileType, new String[]{fileExtension})});
        File selectedFile = fc.showSaveDialog((Window)owner);
        if (selectedFile != null) {
            if (!selectedFile.getName().toLowerCase().endsWith(fileExtension)) {
                selectedFile = new File(selectedFile.getPath() + fileExtension);
            }
            if (!PersistedPreferencesFactory.getInstance().isReadOnly()) {
                prefs.put(prefKey, selectedFile.getAbsolutePath());
                try {
                    prefs.flush();
                }
                catch (BackingStoreException bx) {
                    LOGGER.fine("saving filename to preferences failed", (Throwable)bx);
                }
            }
        }
        return selectedFile;
    }

    public void editFile(File file) {
        new Thread(() -> {
            try {
                LOGGER.info("launching EDIT action for {0}", new Object[]{file});
                Desktop.getDesktop().edit(file);
            }
            catch (IOException | UnsupportedOperationException ex) {
                LOGGER.info("{0} -> trying OPEN action for {1}", new Object[]{ex.getMessage(), file});
                try {
                    Desktop.getDesktop().open(file);
                    LOGGER.info("success!");
                }
                catch (IOException ex2) {
                    LOGGER.severe("cannot open file", (Throwable)ex2);
                }
            }
        }).start();
    }
}

