/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.app;

import java.awt.Rectangle;
import java.awt.SplashScreen;
import java.util.Properties;
import javafx.application.Platform;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import org.tentackle.app.AbstractApplication;
import org.tentackle.common.StringHelper;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.rdc.app.DesktopApplication;
import org.tentackle.fx.rdc.app.FxApplication;
import org.tentackle.fx.rdc.login.Login;
import org.tentackle.log.Logger;
import org.tentackle.reflect.ReflectionHelper;
import org.tentackle.session.SessionInfo;

public class LoginApplication
extends FxApplication {
    private static final Logger LOGGER = Logger.get(LoginApplication.class);
    private Login controller;

    public static boolean isAutoLogin(SessionInfo sessionInfo) {
        return sessionInfo.getProperties().containsKey("autologin");
    }

    @Override
    public void startApplication(Stage stage) {
        try {
            this.controller = this.loadLoginController();
            SessionInfo sessionInfo = this.createSessionInfo();
            this.controller.setSessionInfo(sessionInfo);
            Scene scene = new Scene(this.controller.getView());
            stage.setScene(scene);
            stage.initStyle(StageStyle.TRANSPARENT);
            SplashScreen splashScreen = SplashScreen.getSplashScreen();
            if (splashScreen != null) {
                Rectangle bounds = splashScreen.getBounds();
                int splashX = bounds.x + bounds.width / 2;
                int splashY = bounds.y + bounds.height / 2;
                stage.widthProperty().addListener((observable, oldValue, newValue) -> stage.setX((double)splashX - newValue.doubleValue() / 2.0));
                stage.heightProperty().addListener((observable, oldValue, newValue) -> stage.setY((double)splashY - newValue.doubleValue() / 2.0));
            }
            stage.setOnShown(event -> {
                if (splashScreen != null) {
                    Platform.runLater(splashScreen::close);
                }
                if (LoginApplication.isAutoLogin(sessionInfo)) {
                    this.controller.autoLogin();
                }
            });
            stage.show();
            stage.setResizable(false);
            this.controller.requestInitialFocus();
        }
        catch (RuntimeException rx) {
            throw new FxRuntimeException("cannot create session info", (Throwable)rx);
        }
    }

    @Override
    public void showApplicationStatus(String msg, double progress) {
        if (this.controller.getView().isVisible()) {
            this.controller.setMessage(msg);
            this.controller.setProgress(progress);
        } else {
            LOGGER.info(msg);
        }
    }

    public SessionInfo createSessionInfo() {
        String propsPassword;
        DesktopApplication application = (DesktopApplication)AbstractApplication.getRunningApplication();
        String username = application.getCommandLine().getOptionValue("user");
        char[] password = StringHelper.toCharArray((String)application.getCommandLine().getOptionValue("password"));
        String sessionPropsName = application.getCommandLine().getOptionValue("backend");
        SessionInfo sessionInfo = application.createSessionInfo(username, password, sessionPropsName);
        Properties props = sessionInfo.getProperties();
        if (username == null) {
            sessionInfo.setUserName(props.getProperty("user", sessionInfo.getUserName()));
        }
        if (password == null && (propsPassword = props.getProperty("password")) != null) {
            sessionInfo.setPassword(propsPassword.toCharArray());
        }
        if (sessionInfo.getApplicationName() == null) {
            sessionInfo.setApplicationName(ReflectionHelper.getClassBaseName(((Object)((Object)application)).getClass()));
        }
        AbstractApplication.getRunningApplication().applyProperties(sessionInfo.getProperties());
        return sessionInfo;
    }

    protected Login loadLoginController() {
        return (Login)Fx.load(Login.class);
    }
}

