/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.admin;

import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;
import org.tentackle.fx.AbstractFxController;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.FxFactory;
import org.tentackle.fx.component.FxButton;
import org.tentackle.fx.component.FxTableView;
import org.tentackle.fx.container.FxHBox;
import org.tentackle.fx.rdc.Rdc;
import org.tentackle.fx.rdc.security.SecurityDialogFactory;
import org.tentackle.fx.rdc.table.TablePopup;
import org.tentackle.fx.table.TableConfiguration;
import org.tentackle.pdo.AdminExtension;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoRemoteSession;

@FxControllerService(binding=FxControllerService.BINDING.NO)
public class SessionsView
extends AbstractFxController {
    private List<AdminExtension.SessionData> sessions;
    @FXML
    private FxTableView<AdminExtension.SessionData> sessionsNode;
    @FXML
    private FxHBox buttonBox;
    @FXML
    private FxButton securityButton;
    @FXML
    private FxButton refreshButton;
    @FXML
    private FxButton killButton;
    @FXML
    private ResourceBundle resources;
    private AdminExtension adminExt;
    private TablePopup<AdminExtension.SessionData> popup;

    @FXML
    private void initialize() {
        this.securityButton.setGraphic((Node)Fx.createImageView((String)"security"));
        this.securityButton.setOnAction(e -> this.showSecurityDialog());
        this.refreshButton.setGraphic((Node)Fx.createImageView((String)"reload"));
        this.refreshButton.setOnAction(e -> this.refresh());
        this.killButton.setGraphic((Node)Fx.createImageView((String)"cancel"));
        this.killButton.setOnAction(e -> this.killSessions());
        this.killButton.disableProperty().bind((ObservableValue)this.sessionsNode.getSelectionModel().selectedItemProperty().isNull());
        this.sessionsNode.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    public void configure() {
        this.popup = Rdc.createTablePopup(this.sessionsNode, "Sessions", this.resources.getString("Sessions"));
        DomainContext context = Pdo.createDomainContext();
        if (context.getSession().isRemote()) {
            PdoRemoteSession remoteSession = (PdoRemoteSession)context.getSession().getRemoteSession();
            this.adminExt = (AdminExtension)remoteSession.getExtension(context, AdminExtension.class);
            this.popup.loadPreferences();
            this.securityButton.setDisable(!SecurityDialogFactory.getInstance().isDialogAllowed(context));
            this.killButton.setVisible(this.isKillSessionAllowed());
            this.refresh();
        }
        TableConfiguration<AdminExtension.SessionData> config = this.createTableConfiguration();
        config.getBinder().bind();
        config.configure(this.sessionsNode);
    }

    public FxHBox getButtonBox() {
        return this.buttonBox;
    }

    protected boolean isKillSessionAllowed() {
        return true;
    }

    protected void showSecurityDialog() {
        SecurityDialogFactory.getInstance().showDialog(AdminExtension.class);
    }

    protected TableConfiguration<AdminExtension.SessionData> createTableConfiguration() {
        TableConfiguration config = FxFactory.getInstance().createTableConfiguration(AdminExtension.SessionData.class, null);
        config.addColumn("userId", this.resources.getString("user-ID"));
        config.addColumn("userName", this.resources.getString("user"));
        config.addColumn("applicationName", this.resources.getString("application"));
        config.addColumn("applicationId", this.resources.getString("appl.-ID"));
        config.addColumn("clientVersion", this.resources.getString("version"));
        config.addColumn("locale", this.resources.getString("locale"));
        config.addColumn("timeZone", this.resources.getString("timezone"));
        config.addColumn("vmInfo", this.resources.getString("VM"));
        config.addColumn("osInfo", this.resources.getString("OS"));
        config.addColumn("hostInfo", this.resources.getString("hostname"));
        config.addColumn("clientHost", this.resources.getString("client"));
        config.addColumn("since", this.resources.getString("since"));
        config.addColumn("sessionNumber", this.resources.getString("session-no."));
        config.addColumn("sessionGroup", this.resources.getString("group-no."));
        config.addColumn("options", this.resources.getString("options"));
        return config;
    }

    private void refresh() {
        this.sessions = this.adminExt.getSessions();
        this.sessionsNode.getItems().setAll(this.sessions);
        this.sessionsNode.getSelectionModel().clearSelection();
    }

    private void killSessions() {
        LinkedHashSet<AdminExtension.SessionData> toKill = new LinkedHashSet<AdminExtension.SessionData>();
        for (AdminExtension.SessionData session : this.sessionsNode.getSelectionModel().getSelectedItems()) {
            toKill.add(session);
            if (session.getSessionGroup() == 0L) continue;
            int row = 0;
            for (AdminExtension.SessionData otherSession : this.sessions) {
                if (otherSession.getSessionGroup() == session.getSessionGroup()) {
                    toKill.add(otherSession);
                    this.sessionsNode.getSelectionModel().select(row, null);
                }
                ++row;
            }
        }
        if (!toKill.isEmpty()) {
            String msg = toKill.size() > 1 ? MessageFormat.format(this.resources.getString("really kill {0} sessions?"), toKill.size()) : MessageFormat.format(this.resources.getString("really kill session {0}?"), ((AdminExtension.SessionData)toKill.iterator().next()).getSessionNumber());
            Fx.yes((String)msg, (boolean)false, () -> {
                for (AdminExtension.SessionData session : toKill) {
                    this.adminExt.kill(session.getUserId(), session.getSessionGroup(), session.getApplicationName(), session.getApplicationId());
                }
                this.refresh();
            });
        }
    }
}

