/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.contextmenu;

import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TreeItem;
import javafx.stage.Modality;
import javafx.stage.Window;
import org.tentackle.fx.Fx;
import org.tentackle.fx.rdc.PdoTreeCell;
import org.tentackle.fx.rdc.PdoTreeContextMenuItem;
import org.tentackle.fx.rdc.PdoTreeContextMenuItemService;
import org.tentackle.fx.rdc.Rdc;
import org.tentackle.fx.rdc.RdcFxRdcBundle;
import org.tentackle.pdo.PersistentDomainObject;

@PdoTreeContextMenuItemService(value=PersistentDomainObject.class, ordinal=150)
public class EditItem<T extends PersistentDomainObject<T>>
extends MenuItem
implements PdoTreeContextMenuItem<T> {
    public EditItem(PdoTreeCell<T> cell) {
        super(RdcFxRdcBundle.getString("EDIT"), (Node)Fx.createImageView((String)"edit"));
        PersistentDomainObject pdo = (PersistentDomainObject)cell.getItem();
        if (cell.getPdoTreeItem().getGuiProvider().isEditAllowed()) {
            PersistentDomainObject pDo = pdo.reload();
            this.setOnAction(e -> Rdc.displayCrudStage(pDo, true, Modality.APPLICATION_MODAL, (Window)Fx.getStage((Node)cell), updatedPdo -> {
                TreeItem root;
                if (updatedPdo != null && (root = cell.getTreeItem().getParent()) != null) {
                    ObservableList items = root.getChildren();
                    int i = 0;
                    for (TreeItem item : items) {
                        if (updatedPdo.equals(item.getValue())) {
                            boolean expanded = item.isExpanded();
                            TreeItem<PersistentDomainObject> reloadedItem = Rdc.createGuiProvider(updatedPdo).createTreeItem();
                            items.set(i, reloadedItem);
                            cell.getTreeView().refresh();
                            reloadedItem.setExpanded(expanded);
                            break;
                        }
                        ++i;
                    }
                }
            }));
        } else {
            this.setDisable(true);
        }
    }
}

