/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc;

import java.io.File;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.tentackle.app.AbstractApplication;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.fx.rdc.FileUtilitiesHolder;
import org.tentackle.log.Logger;

@Service(value=FileUtilities.class)
public class FileUtilities {
    private static final Logger LOGGER = Logger.get(FileUtilities.class);

    public static FileUtilities getInstance() {
        return FileUtilitiesHolder.INSTANCE;
    }

    public File selectFile(String prefName, String prefKey, String fileExtension, String fileType, Stage owner) {
        Preferences prefs = Preferences.userRoot();
        String applicationName = AbstractApplication.getRunningApplication().getName();
        if (!StringHelper.isAllWhitespace((String)applicationName)) {
            prefs = prefs.node(applicationName);
        }
        prefs = prefs.node(prefName);
        String lastName = prefs.get(prefKey, null);
        FileChooser fc = new FileChooser();
        if (lastName != null) {
            fc.setInitialFileName(lastName);
        }
        fc.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(fileType, new String[]{fileExtension})});
        File selectedFile = fc.showSaveDialog((Window)owner);
        if (selectedFile != null) {
            if (!selectedFile.getName().toLowerCase().endsWith(fileExtension)) {
                selectedFile = new File(selectedFile.getPath() + fileExtension);
            }
            String filePath = selectedFile.getAbsolutePath();
            prefs.put(prefKey, filePath);
            try {
                prefs.flush();
            }
            catch (BackingStoreException bx) {
                LOGGER.warning("cannot save user preferences {0}", new Object[]{prefs.absolutePath()});
                LOGGER.fine(filePath, (Throwable)bx);
            }
        }
        return selectedFile;
    }
}

