/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.app;

import javafx.application.Application;
import javafx.stage.Stage;
import org.tentackle.app.AbstractApplication;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.rdc.app.DesktopApplication;
import org.tentackle.log.Logger;

public abstract class FxApplication
extends Application {
    private static final Logger LOGGER = Logger.get(FxApplication.class);
    private static final String FATAL = "runtime or configuration error";

    public void start(Stage stage) throws Exception {
        try {
            DesktopApplication application = (DesktopApplication)AbstractApplication.getRunningApplication();
            application.setFxApplication(this);
            application.registerUncaughtExceptionHandler();
            this.startApplication(stage);
        }
        catch (RuntimeException ex) {
            LOGGER.severe("starting tentackle fx application failed", (Throwable)ex);
            throw ex;
        }
        catch (Throwable t) {
            LOGGER.severe(FATAL, t);
            throw new FxRuntimeException(FATAL, t);
        }
    }

    public void stop() throws Exception {
        DesktopApplication application = (DesktopApplication)AbstractApplication.getRunningApplication();
        application.stop();
    }

    public abstract void startApplication(Stage var1);

    public abstract void showApplicationStatus(String var1, double var2);
}

