/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.table;

import java.io.File;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxUtilities;
import org.tentackle.fx.component.FxTableView;
import org.tentackle.fx.component.FxTreeTableView;
import org.tentackle.fx.rdc.RdcFxRdcBundle;
import org.tentackle.fx.rdc.table.TableUtilities;
import org.tentackle.log.Logger;
import org.tentackle.prefs.PersistedPreferencesFactory;

public class TablePopup<S> {
    private static final Logger LOGGER = Logger.get(TablePopup.class);
    private final FxTableView<S> table;
    private final FxTreeTableView<S> treeTable;
    private String preferencesSuffix;
    private String title;
    private boolean columnMenuEnabled = true;

    public TablePopup(FxTableView<S> table, String preferencesSuffix, String title) {
        this(Objects.requireNonNull(table), null, preferencesSuffix, title);
        ContextMenu menu = this.createContextMenu();
        table.setContextMenu(menu);
        for (TableColumn column : table.getColumns()) {
            column.setContextMenu(menu);
        }
    }

    public TablePopup(FxTreeTableView<S> treeTable, String preferencesSuffix, String title) {
        this(null, Objects.requireNonNull(treeTable), preferencesSuffix, title);
        ContextMenu menu = this.createContextMenu();
        treeTable.setContextMenu(menu);
        for (TreeTableColumn column : treeTable.getColumns()) {
            column.setContextMenu(menu);
        }
    }

    private TablePopup(FxTableView<S> table, FxTreeTableView<S> treeTable, String preferencesSuffix, String title) {
        this.table = table;
        this.treeTable = treeTable;
        this.preferencesSuffix = preferencesSuffix;
        this.title = title;
    }

    public FxTableView<S> getTable() {
        return this.table;
    }

    public FxTreeTableView<S> getTreeTable() {
        return this.treeTable;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPreferencesSuffix() {
        return this.preferencesSuffix;
    }

    public void setPreferencesSuffix(String preferencesSuffix) {
        this.preferencesSuffix = Objects.requireNonNull(preferencesSuffix);
    }

    public boolean isColumnMenuEnabled() {
        return this.columnMenuEnabled;
    }

    public void setColumnMenuEnabled(boolean columnMenuEnabled) {
        this.columnMenuEnabled = columnMenuEnabled;
    }

    public void expandTreeTable(TreeItem<S> selectedItem) {
        if (this.treeTable != null) {
            if (selectedItem != null) {
                FxUtilities.getInstance().expandAll(selectedItem);
            } else {
                this.treeTable.expandAll();
            }
        }
    }

    public void collapseTreeTable(TreeItem<S> selectedItem) {
        if (this.treeTable != null) {
            if (selectedItem != null) {
                FxUtilities.getInstance().collapseAll(selectedItem);
            } else {
                this.treeTable.collapseAll();
            }
        }
    }

    public ContextMenu createContextMenu() {
        MenuItem restoreItem;
        MenuItem saveItem;
        MenuItem collapseItem;
        MenuItem expandItem;
        ContextMenu menu = new ContextMenu();
        if (this.treeTable != null) {
            expandItem = new MenuItem();
            menu.getItems().add((Object)expandItem);
            collapseItem = new MenuItem();
            menu.getItems().add((Object)collapseItem);
            menu.getItems().add((Object)new SeparatorMenuItem());
        } else {
            expandItem = null;
            collapseItem = null;
        }
        ObservableList tableColumns = this.table == null ? null : this.table.getColumns();
        ObservableList treeTableColumns = this.treeTable == null ? null : this.treeTable.getColumns();
        Menu columnMenu = new Menu();
        columnMenu.setText(RdcFxRdcBundle.getString("COLUMNS..."));
        menu.getItems().add((Object)columnMenu);
        MenuItem autoWidthItem = new MenuItem();
        autoWidthItem.setText(RdcFxRdcBundle.getString("AUTO ADJUST"));
        autoWidthItem.setOnAction(e -> this.autoWidth());
        menu.getItems().add((Object)autoWidthItem);
        MenuItem printItem = new MenuItem();
        printItem.setText(RdcFxRdcBundle.getString("PRINT"));
        printItem.setOnAction(e -> this.print());
        menu.getItems().add((Object)printItem);
        MenuItem excelItem = new MenuItem();
        excelItem.setText(RdcFxRdcBundle.getString("EXPORT TO SPREADSHEET"));
        excelItem.setOnAction(e -> this.toSpreadsheet(false));
        menu.getItems().add((Object)excelItem);
        MenuItem selectedExcelItem = new MenuItem();
        selectedExcelItem.setText(RdcFxRdcBundle.getString("EXPORT TO SPREADSHEET (SELECTED)"));
        selectedExcelItem.setOnAction(e -> this.toSpreadsheet(true));
        menu.getItems().add((Object)selectedExcelItem);
        MenuItem xmlItem = new MenuItem();
        xmlItem.setText(RdcFxRdcBundle.getString("EXPORT TO XML"));
        xmlItem.setOnAction(e -> this.toXml(false));
        menu.getItems().add((Object)xmlItem);
        MenuItem selectedXmlItem = new MenuItem();
        selectedXmlItem.setText(RdcFxRdcBundle.getString("EXPORT TO XML (SELECTED)"));
        selectedXmlItem.setOnAction(e -> this.toXml(true));
        menu.getItems().add((Object)selectedXmlItem);
        if (PersistedPreferencesFactory.getInstance().isSystemOnly()) {
            if (!PersistedPreferencesFactory.getInstance().isReadOnly()) {
                saveItem = new MenuItem();
                saveItem.setText(RdcFxRdcBundle.getString("SAVE SYSTEM PREFERENCES"));
                saveItem.setOnAction(e -> this.savePreferences(true));
                menu.getItems().add((Object)saveItem);
            }
            restoreItem = new MenuItem();
            restoreItem.setText(RdcFxRdcBundle.getString("LOAD SYSTEM PREFERENCES"));
            restoreItem.setOnAction(e -> this.loadPreferences(true));
            menu.getItems().add((Object)restoreItem);
        } else {
            if (!PersistedPreferencesFactory.getInstance().isReadOnly()) {
                saveItem = new MenuItem();
                saveItem.setText(RdcFxRdcBundle.getString("SAVE USER PREFERENCES"));
                saveItem.setOnAction(e -> this.savePreferences(false));
                menu.getItems().add((Object)saveItem);
            }
            restoreItem = new MenuItem();
            restoreItem.setText(RdcFxRdcBundle.getString("LOAD USER PREFERENCES"));
            restoreItem.setOnAction(e -> this.loadPreferences(false));
            menu.getItems().add((Object)restoreItem);
            MenuItem restoreSysItem = new MenuItem();
            restoreSysItem.setText(RdcFxRdcBundle.getString("LOAD SYSTEM PREFERENCES"));
            restoreSysItem.setOnAction(e -> this.loadPreferences(true));
            menu.getItems().add((Object)restoreSysItem);
        }
        menu.getItems().add((Object)new SeparatorMenuItem());
        Label countLabel = new Label();
        CustomMenuItem labelItem = new CustomMenuItem((Node)countLabel, false);
        labelItem.setDisable(true);
        menu.getItems().add((Object)labelItem);
        menu.setOnShowing(event -> {
            List items = this.table == null ? this.treeTable.getItems() : this.table.getItems();
            int selectedIndex = this.table == null ? this.treeTable.getSelectionModel().getSelectedIndex() : this.table.getSelectionModel().getSelectedIndex();
            countLabel.setText(MessageFormat.format(RdcFxRdcBundle.getString("ROW {0} OF {1}"), selectedIndex + 1, items == null ? 0 : items.size()));
            if (this.treeTable != null) {
                TreeItem selectedItem = (TreeItem)this.treeTable.getSelectionModel().getSelectedItem();
                expandItem.setOnAction(e -> this.expandTreeTable(selectedItem));
                expandItem.setText(selectedItem != null && selectedItem.isExpanded() ? RdcFxRdcBundle.getString("EXPAND_AGAIN") : RdcFxRdcBundle.getString("EXPAND"));
                expandItem.setDisable(selectedItem != null && selectedItem.isLeaf());
                collapseItem.setOnAction(e -> this.collapseTreeTable(selectedItem));
                collapseItem.setText(RdcFxRdcBundle.getString("COLLAPSE"));
                collapseItem.setDisable(selectedItem != null && !selectedItem.isExpanded());
            }
            if (this.isColumnMenuEnabled()) {
                columnMenu.getItems().clear();
                boolean allVisible = true;
                boolean allInvisible = true;
                if (tableColumns != null) {
                    for (TableColumn column : tableColumns) {
                        CheckMenuItem item = new CheckMenuItem(column.getText());
                        item.setSelected(column.isVisible());
                        if (column.isVisible()) {
                            allInvisible = false;
                        } else {
                            allVisible = false;
                        }
                        item.setOnAction(e -> column.setVisible(item.isSelected()));
                        columnMenu.getItems().add((Object)item);
                    }
                    if (!allVisible) {
                        MenuItem showAllItem = new MenuItem(RdcFxRdcBundle.getString("SHOW ALL"));
                        showAllItem.setOnAction(e -> {
                            for (TableColumn column : tableColumns) {
                                column.setVisible(true);
                            }
                        });
                        columnMenu.getItems().add((Object)showAllItem);
                    }
                    if (!allInvisible) {
                        MenuItem hideAllItem = new MenuItem(RdcFxRdcBundle.getString("HIDE ALL"));
                        hideAllItem.setOnAction(e -> {
                            for (TableColumn column : tableColumns) {
                                column.setVisible(false);
                            }
                        });
                        columnMenu.getItems().add((Object)hideAllItem);
                    }
                } else if (treeTableColumns != null) {
                    for (TreeTableColumn column : treeTableColumns) {
                        CheckMenuItem item = new CheckMenuItem(column.getText());
                        item.setSelected(column.isVisible());
                        if (column.isVisible()) {
                            allInvisible = false;
                        } else {
                            allVisible = false;
                        }
                        item.setOnAction(e -> column.setVisible(item.isSelected()));
                        columnMenu.getItems().add((Object)item);
                    }
                    if (!allVisible) {
                        MenuItem showAllItem = new MenuItem(RdcFxRdcBundle.getString("SHOW ALL"));
                        showAllItem.setOnAction(e -> {
                            for (TreeTableColumn column : treeTableColumns) {
                                column.setVisible(true);
                            }
                        });
                        columnMenu.getItems().add((Object)showAllItem);
                    }
                    if (!allInvisible) {
                        Iterator hideAllItem = new MenuItem(RdcFxRdcBundle.getString("HIDE ALL"));
                        hideAllItem.setOnAction(e -> {
                            for (TreeTableColumn column : treeTableColumns) {
                                column.setVisible(false);
                            }
                        });
                        columnMenu.getItems().add((Object)hideAllItem);
                    }
                }
                columnMenu.setVisible(true);
            } else {
                columnMenu.setVisible(false);
            }
        });
        return menu;
    }

    public void autoWidth() {
        if (this.table != null) {
            FxUtilities.getInstance().resizeColumnsToFitContent(this.table);
        } else {
            FxUtilities.getInstance().resizeColumnsToFitContent(this.treeTable);
        }
    }

    public void print() {
        if (this.table != null) {
            TableUtilities.getInstance().print(this.table, this.getTitle());
        } else {
            TableUtilities.getInstance().print(this.treeTable, this.getTitle());
        }
    }

    public void toSpreadsheet(boolean onlySelected) {
        try {
            if (this.table != null) {
                File file = TableUtilities.getInstance().selectSpreadsheetFile(this.table.getConfiguration().getName(), Fx.getStage(this.table));
                if (file != null) {
                    TableUtilities.getInstance().toSpreadsheet(this.table, file, onlySelected);
                    FxUtilities.getInstance().edit(file);
                }
            } else {
                File file = TableUtilities.getInstance().selectSpreadsheetFile(this.treeTable.getConfiguration().getName(), Fx.getStage(this.treeTable));
                if (file != null) {
                    TableUtilities.getInstance().toSpreadsheet(this.treeTable, file, onlySelected);
                    FxUtilities.getInstance().edit(file);
                }
            }
        }
        catch (RuntimeException ex) {
            LOGGER.severe("creating spreadsheet failed", (Throwable)ex);
            Fx.error((String)RdcFxRdcBundle.getString("COULD NOT CREATE SPREADSHEET FILE"), (Throwable)ex);
        }
    }

    public void toXml(boolean onlySelected) {
        try {
            if (this.table != null) {
                File file = TableUtilities.getInstance().selectXmlFile(this.table.getConfiguration().getName(), Fx.getStage(this.table));
                if (file != null) {
                    TableUtilities.getInstance().toXml(this.table, file, onlySelected);
                    FxUtilities.getInstance().edit(file);
                }
            } else {
                File file = TableUtilities.getInstance().selectXmlFile(this.treeTable.getConfiguration().getName(), Fx.getStage(this.treeTable));
                if (file != null) {
                    TableUtilities.getInstance().toXml(this.treeTable, file, onlySelected);
                    FxUtilities.getInstance().edit(file);
                }
            }
        }
        catch (RuntimeException ex) {
            LOGGER.severe("creating XML file failed", (Throwable)ex);
            Fx.error((String)RdcFxRdcBundle.getString("COULD NOT CREATE XML FILE"), (Throwable)ex);
        }
    }

    public void savePreferences(boolean system) {
        try {
            if (this.table != null) {
                this.table.savePreferences(this.getPreferencesSuffix(), system);
            } else {
                this.treeTable.savePreferences(this.getPreferencesSuffix(), system);
            }
        }
        catch (RuntimeException ex) {
            LOGGER.severe("saving table preferences failed", (Throwable)ex);
            Fx.error((String)RdcFxRdcBundle.getString("SAVING PREFERENCES FAILED"), (Throwable)ex);
        }
    }

    public void savePreferences() {
        this.savePreferences(PersistedPreferencesFactory.getInstance().isSystemOnly());
    }

    public void loadPreferences(boolean system) {
        try {
            if (this.table != null) {
                this.table.loadPreferences(this.getPreferencesSuffix(), system);
            } else {
                this.treeTable.loadPreferences(this.getPreferencesSuffix(), system);
            }
        }
        catch (RuntimeException ex) {
            LOGGER.severe("loading table preferences failed", (Throwable)ex);
            Fx.error((String)RdcFxRdcBundle.getString("LOADING PREFERENCES FAILED"), (Throwable)ex);
        }
    }

    public void loadPreferences() {
        this.loadPreferences(PersistedPreferencesFactory.getInstance().isSystemOnly());
    }
}

