/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import org.tentackle.common.Service;
import org.tentackle.common.ServiceFactory;
import org.tentackle.fx.Fx;
import org.tentackle.fx.rdc.PdoContextMenuFactory;
import org.tentackle.fx.rdc.PdoTableCell;
import org.tentackle.fx.rdc.PdoTableContextMenuItem;
import org.tentackle.fx.rdc.PdoTableContextMenuItemService;
import org.tentackle.fx.rdc.PdoTreeCell;
import org.tentackle.fx.rdc.PdoTreeContextMenuItem;
import org.tentackle.fx.rdc.PdoTreeContextMenuItemService;
import org.tentackle.fx.rdc.PdoTreeTableCell;
import org.tentackle.fx.rdc.PdoTreeTableContextMenuItem;
import org.tentackle.fx.rdc.PdoTreeTableContextMenuItemService;
import org.tentackle.fx.rdc.RdcRuntimeException;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.reflect.ClassToServicesMapper;

@Service(value=PdoContextMenuFactory.class)
public class DefaultPdoContextMenuFactory
implements PdoContextMenuFactory {
    private final ClassToServicesMapper<PdoTreeContextMenuItem<?>> treeItemClassMapper = new ClassToServicesMapper("FX tree cell context menu", ServiceFactory.getServiceFinder().createNameMapToAll(PdoTreeContextMenuItem.class.getName()), null);
    private final ClassToServicesMapper<PdoTableContextMenuItem<?>> tableItemClassMapper = new ClassToServicesMapper("FX table cell context menu", ServiceFactory.getServiceFinder().createNameMapToAll(PdoTableContextMenuItem.class.getName()), null);
    private final ClassToServicesMapper<PdoTreeTableContextMenuItem<?>> treeTableItemClassMapper = new ClassToServicesMapper("FX treetable cell context menu", ServiceFactory.getServiceFinder().createNameMapToAll(PdoTreeTableContextMenuItem.class.getName()), null);

    @Override
    public <T extends PersistentDomainObject<T>> ContextMenu create(PdoTreeCell<T> cell) {
        ContextMenu contextMenu = null;
        PersistentDomainObject pdo = (PersistentDomainObject)cell.getItem();
        if (pdo != null) {
            ArrayList<Class> classes = new ArrayList<Class>();
            classes.add(pdo.getEffectiveClass());
            classes.addAll(pdo.getEffectiveSuperClasses());
            TreeSet<ItemConfig> items = new TreeSet<ItemConfig>();
            try {
                for (Class cls : classes) {
                    Set itemClasses = this.treeItemClassMapper.mapClass(cls.getName(), true);
                    for (Class clazz : itemClasses) {
                        PdoTreeContextMenuItemService anno = clazz.getAnnotation(PdoTreeContextMenuItemService.class);
                        if (anno == null) continue;
                        MenuItem item = (MenuItem)clazz.getConstructor(PdoTreeCell.class).newInstance(new Object[]{cell});
                        items.add(new ItemConfig(anno.ordinal(), anno.group(), item));
                    }
                }
                contextMenu = this.createMenu(items);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException cx) {
                throw new RdcRuntimeException("cannot create tree context menu item", cx);
            }
        }
        return contextMenu;
    }

    @Override
    public <S, T extends PersistentDomainObject<T>> ContextMenu create(PdoTableCell<S, T> cell) {
        ContextMenu contextMenu = null;
        PersistentDomainObject pdo = (PersistentDomainObject)cell.getItem();
        if (pdo != null) {
            ArrayList<Class> classes = new ArrayList<Class>();
            classes.add(pdo.getEffectiveClass());
            classes.addAll(pdo.getEffectiveSuperClasses());
            TreeSet<ItemConfig> items = new TreeSet<ItemConfig>();
            try {
                for (Class cls : classes) {
                    Set itemClasses = this.tableItemClassMapper.mapClass(cls.getName(), true);
                    for (Class clazz : itemClasses) {
                        PdoTableContextMenuItemService anno = clazz.getAnnotation(PdoTableContextMenuItemService.class);
                        if (anno == null) continue;
                        MenuItem item = (MenuItem)clazz.getConstructor(PdoTableCell.class).newInstance(new Object[]{cell});
                        items.add(new ItemConfig(anno.ordinal(), anno.group(), item));
                    }
                }
                contextMenu = this.createMenu(items);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException cx) {
                throw new RdcRuntimeException("cannot create table cell context menu item", cx);
            }
        }
        return contextMenu;
    }

    @Override
    public <S, T extends PersistentDomainObject<T>> ContextMenu create(PdoTreeTableCell<S, T> cell) {
        ContextMenu contextMenu = null;
        PersistentDomainObject pdo = (PersistentDomainObject)cell.getItem();
        if (pdo != null) {
            ArrayList<Class> classes = new ArrayList<Class>();
            classes.add(pdo.getEffectiveClass());
            classes.addAll(pdo.getEffectiveSuperClasses());
            TreeSet<ItemConfig> items = new TreeSet<ItemConfig>();
            try {
                for (Class cls : classes) {
                    Set itemClasses = this.treeTableItemClassMapper.mapClass(cls.getName(), true);
                    for (Class clazz : itemClasses) {
                        PdoTreeTableContextMenuItemService anno = clazz.getAnnotation(PdoTreeTableContextMenuItemService.class);
                        if (anno == null) continue;
                        MenuItem item = (MenuItem)clazz.getConstructor(PdoTreeTableCell.class).newInstance(new Object[]{cell});
                        items.add(new ItemConfig(anno.ordinal(), anno.group(), item));
                    }
                }
                contextMenu = this.createMenu(items);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException cx) {
                throw new RdcRuntimeException("cannot create tree table cell context menu item", cx);
            }
        }
        return contextMenu;
    }

    private ContextMenu createMenu(Set<ItemConfig> items) {
        if (!items.isEmpty()) {
            ContextMenu menu = (ContextMenu)Fx.create(ContextMenu.class);
            String group = "";
            for (ItemConfig item : items) {
                if (!item.menuItem.isVisible()) continue;
                if (!Objects.equals(group, item.group)) {
                    menu.getItems().add((Object)((MenuItem)Fx.create(SeparatorMenuItem.class)));
                    group = item.group;
                }
                menu.getItems().add((Object)item.menuItem);
            }
            return menu;
        }
        return null;
    }

    private static class ItemConfig
    implements Comparable<ItemConfig> {
        private final int ordinal;
        private final String group;
        private final MenuItem menuItem;

        public ItemConfig(int ordinal, String group, MenuItem menuItem) {
            this.ordinal = ordinal;
            this.group = group;
            this.menuItem = menuItem;
        }

        @Override
        public int compareTo(ItemConfig o) {
            return this.ordinal - o.ordinal;
        }

        public int hashCode() {
            int hash = 3;
            hash = 29 * hash + this.ordinal;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ItemConfig other = (ItemConfig)obj;
            return this.ordinal == other.ordinal;
        }
    }
}

