/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc;

import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.application.Platform;
import org.tentackle.fx.Fx;
import org.tentackle.fx.rdc.RdcUtilities;
import org.tentackle.session.ModificationTracker;
import org.tentackle.session.Session;
import org.tentackle.session.SessionCloseHandler;
import org.tentackle.session.SessionPool;
import org.tentackle.session.SessionPoolFactory;
import org.tentackle.session.SessionPooledExecutor;

public class RdcUtilitiesWithBackgroundPool
extends RdcUtilities {
    private final SessionPooledExecutor executor = this.createExecutor();

    public SessionPooledExecutor getExecutor() {
        return this.executor;
    }

    @Override
    public <V> void runInBackground(Supplier<V> runner, Consumer<V> updateUI, Consumer<RuntimeException> failedUI) {
        this.executor.submit(runner, updateUI == null ? null : value -> Platform.runLater(() -> updateUI.accept(value)), failedUI == null ? null : exception -> Platform.runLater(() -> failedUI.accept((RuntimeException)exception)));
    }

    public <V> void runInBackground(Collection<Supplier<V>> runners, long timeoutMillis, Consumer<Map<Supplier<V>, V>> finishedUI, Consumer<Map<Supplier<V>, RuntimeException>> failedUI) {
        this.executor.submit(runners, timeoutMillis, finishedUI == null ? null : successHandlers -> Platform.runLater(() -> finishedUI.accept((Map)successHandlers)), failedUI == null ? null : failHandlers -> Platform.runLater(() -> failedUI.accept((Map)failHandlers)));
    }

    public <V> void runInBackground(Collection<Supplier<V>> runners, long timeoutMillis, Consumer<Map<Supplier<V>, V>> finishedUI) {
        this.runInBackground(runners, timeoutMillis, finishedUI, failedMap -> {
            StringBuilder buf = new StringBuilder();
            for (RuntimeException rx : failedMap.values()) {
                String msg = rx.getLocalizedMessage();
                if (msg == null || buf.toString().contains(msg)) continue;
                if (buf.length() > 0) {
                    buf.append('\n');
                }
                buf.append(rx.getLocalizedMessage());
            }
            String msg = buf.toString();
            Platform.runLater(() -> Fx.warning((String)msg));
        });
    }

    protected SessionPooledExecutor createExecutor() {
        Session session = ModificationTracker.getInstance().getSession();
        final SessionPooledExecutor executor = new SessionPooledExecutor(this.createSessionPool(session));
        session.registerCloseHandler(new SessionCloseHandler(){

            public void beforeClose(Session session) {
            }

            public void afterClose(Session session) {
                executor.shutdown();
            }
        });
        return executor;
    }

    protected SessionPool createSessionPool(Session session) {
        return SessionPoolFactory.getInstance().create("BG", session, 0, 1, 0, 3, 5L, 0L);
    }
}

