/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.app;

import java.awt.Rectangle;
import java.awt.SplashScreen;
import java.util.Properties;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import org.tentackle.app.Application;
import org.tentackle.common.Cryptor;
import org.tentackle.common.StringHelper;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.rdc.app.DesktopApplication;
import org.tentackle.fx.rdc.app.FxApplication;
import org.tentackle.fx.rdc.login.Login;
import org.tentackle.log.Logger;
import org.tentackle.session.SessionInfo;

public class LoginApplication
extends FxApplication {
    private static final Logger LOGGER = Logger.get(LoginApplication.class);
    private Login controller;

    @Override
    public void startApplication(Stage stage) {
        try {
            this.controller = this.loadLoginController();
            SessionInfo sessionInfo = this.createSessionInfo();
            this.controller.setSessionInfo(sessionInfo);
            Scene scene = Fx.createScene((Parent)this.controller.getView());
            stage.setScene(scene);
            stage.initStyle(StageStyle.TRANSPARENT);
            SplashScreen splashScreen = SplashScreen.getSplashScreen();
            if (splashScreen != null) {
                Rectangle bounds = splashScreen.getBounds();
                int splashX = bounds.x + bounds.width / 2;
                int splashY = bounds.y + bounds.height / 2;
                stage.widthProperty().addListener((observable, oldValue, newValue) -> stage.setX((double)splashX - newValue.doubleValue() / 2.0));
                stage.heightProperty().addListener((observable, oldValue, newValue) -> stage.setY((double)splashY - newValue.doubleValue() / 2.0));
            }
            stage.setOnShown(event -> {
                if (splashScreen != null) {
                    Platform.runLater(splashScreen::close);
                }
                if (((DesktopApplication)Application.getInstance()).isAutoLogin()) {
                    this.controller.autoLogin();
                } else if (sessionInfo.getUserName() != null && sessionInfo.getPassword() != null) {
                    this.controller.login();
                }
            });
            stage.show();
            stage.setResizable(false);
            this.controller.requestInitialFocus();
        }
        catch (RuntimeException rx) {
            throw new FxRuntimeException("cannot create session info", (Throwable)rx);
        }
    }

    @Override
    public void showApplicationStatus(String msg, double progress) {
        if (this.controller.getView().isVisible()) {
            this.controller.setMessage(msg);
            this.controller.setProgress(progress);
        } else {
            LOGGER.info(msg);
        }
    }

    public SessionInfo createSessionInfo() {
        String propsPassword;
        DesktopApplication application = (DesktopApplication)Application.getInstance();
        String username = application.getCommandLine().getOptionValue("user");
        char[] password = StringHelper.toCharArray((String)application.getCommandLine().getOptionValue("password"));
        String sessionPropsName = application.getCommandLine().getOptionValue("backend");
        SessionInfo sessionInfo = application.createSessionInfo(username, password, sessionPropsName);
        sessionInfo.setSessionName("FX");
        Properties props = sessionInfo.getProperties();
        if (username == null) {
            sessionInfo.setUserName(props.getProperty("user", sessionInfo.getUserName()));
        }
        if (password == null && (propsPassword = props.getProperty("password")) != null) {
            sessionInfo.setPassword(propsPassword.toCharArray());
        }
        sessionInfo.applyProperties();
        if (sessionInfo.getUserName() == null) {
            this.updateSessionInfoFromEnvironment(sessionInfo);
        }
        if (sessionInfo.getUserName() == null) {
            sessionInfo.setUserName(System.getProperty("user.name"));
        }
        application.applyProperties(sessionInfo.getProperties());
        return sessionInfo;
    }

    protected void updateSessionInfoFromEnvironment(SessionInfo sessionInfo) {
        Cryptor cryptor = Cryptor.getInstance();
        if (cryptor != null) {
            String envPrefix = StringHelper.toAsciiLetterOrDigit((String)Application.getInstance().getName());
            try {
                String encUser = System.getenv((envPrefix + "_user").toUpperCase());
                if (encUser != null) {
                    sessionInfo.setUserName(Cryptor.getInstance().decrypt64(encUser));
                    String encPass = System.getenv((envPrefix + "_password").toUpperCase());
                    if (encPass != null) {
                        sessionInfo.setPassword(Cryptor.getInstance().decrypt64ToChars(encPass));
                    }
                }
            }
            catch (RuntimeException rx) {
                LOGGER.warning("decryption of username/password from environment failed", (Throwable)rx);
            }
        }
    }

    protected Login loadLoginController() {
        return (Login)Fx.load(Login.class);
    }
}

