/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.component.delegate;

import java.util.function.Supplier;
import javafx.collections.ObservableList;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.bind.FxComponentBinding;
import org.tentackle.fx.rdc.translate.PdoComponentAddon;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PersistentDomainObject;

public class RdcBoxDelegateImpl {
    private final FxComponent component;
    private final Supplier<ObservableList> itemSupplier;
    private final Supplier<PdoComponentAddon> pdoAddonSupplier;
    private long lastModificationCount;
    private long lastPdoId;
    private long lastPdoSerial;
    private PersistentDomainObject proxy;

    public RdcBoxDelegateImpl(FxComponent component, Supplier<ObservableList> itemSupplier, Supplier<PdoComponentAddon> pdoAddonSupplier) {
        this.component = component;
        this.itemSupplier = itemSupplier;
        this.pdoAddonSupplier = pdoAddonSupplier;
    }

    public void prepareSetType(Class<?> type) {
        this.lastModificationCount = PersistentDomainObject.class.isAssignableFrom(type) ? -1L : 0L;
        this.lastPdoSerial = 0L;
        this.lastPdoId = 0L;
        this.proxy = null;
    }

    public DomainContext getDomainContext() {
        DomainContext context = null;
        FxComponentBinding binding = this.component.getBinding();
        if (binding != null) {
            context = (DomainContext)binding.getBinder().getBindingProperty(DomainContext.class);
        }
        return context;
    }

    public void prepareSetViewValue() {
        if (this.lastModificationCount != 0L) {
            boolean loadItems = false;
            if (this.proxy == null) {
                DomainContext context = this.getDomainContext();
                if (context != null) {
                    this.proxy = Pdo.create((Class)this.component.getType(), (DomainContext)context);
                    loadItems = true;
                }
            } else {
                long modificationCount = this.proxy.getModificationCount();
                if (modificationCount != this.lastModificationCount) {
                    this.lastModificationCount = modificationCount;
                    loadItems = true;
                } else {
                    Object pdo = this.pdoAddonSupplier.get().getPdo();
                    if (pdo != null) {
                        if (pdo.getId() == this.lastPdoId && pdo.getSerial() != this.lastPdoSerial) {
                            int ndx = 0;
                            ObservableList items = this.itemSupplier.get();
                            for (Object item : items) {
                                if (pdo.equals(item)) {
                                    items.set(ndx, pdo);
                                    break;
                                }
                                ++ndx;
                            }
                        }
                        this.lastPdoId = pdo.getId();
                        this.lastPdoSerial = pdo.getSerial();
                    } else {
                        this.lastPdoId = 0L;
                        this.lastPdoSerial = 0L;
                    }
                }
            }
            if (loadItems) {
                if (this.lastModificationCount == -1L) {
                    this.lastModificationCount = this.proxy.getModificationCount();
                }
                ObservableList items = this.itemSupplier.get();
                items.setAll(this.pdoAddonSupplier.get().getAllPdos(this.proxy));
            }
        }
    }
}

