/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.table;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.print.PageLayout;
import javafx.print.PrinterJob;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.skin.TableViewSkin;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.transform.Scale;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.tentackle.common.Timestamp;
import org.tentackle.fx.AbstractFxController;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.FxUtilities;
import org.tentackle.fx.component.FxLabel;
import org.tentackle.fx.component.FxTableView;
import org.tentackle.fx.component.FxTreeTableView;
import org.tentackle.fx.container.FxHBox;
import org.tentackle.fx.rdc.Rdc;
import org.tentackle.fx.rdc.RdcFxRdcBundle;
import org.tentackle.fx.table.FxTableCell;
import org.tentackle.fx.table.FxTableColumn;
import org.tentackle.fx.table.FxTreeTableColumn;
import org.tentackle.fx.table.TableColumnConfiguration;
import org.tentackle.fx.table.TotalsTableView;
import org.tentackle.log.Logger;
import org.tentackle.misc.FormatHelper;
import org.tentackle.misc.TimeKeeper;
import org.tentackle.session.AbstractSessionTask;

@FxControllerService(binding=FxControllerService.BINDING.NO)
public class TablePrinter
extends AbstractFxController {
    private static final Logger LOGGER = Logger.get(TablePrinter.class);
    private static final String STYLE_TITLE = "title";
    private static final String STYLE_BOTTOMLINE = "bottomline";
    private static final String STYLE_TOTALS = "totals";
    @FXML
    private ResourceBundle resources;
    @FXML
    private FxLabel titleLabel;
    @FXML
    private FxTableView<?> tableView;
    @FXML
    private FxHBox bottomLine;
    @FXML
    private FxLabel dateLabel;
    @FXML
    private FxLabel pageLabel;
    private int pageCount;
    private TimeKeeper jobTimeKeeper;
    private int rowCount;
    private int totalsRowCount;
    private volatile boolean terminationRequested;
    private final AtomicInteger rowOffset = new AtomicInteger();

    public static void print(FxTableView<?> table, String title, PrinterJob job) {
        TablePrinter.print(table, null, title, job);
    }

    public static void print(FxTreeTableView<?> treeTable, String title, PrinterJob job) {
        TablePrinter.print(null, treeTable, title, job);
    }

    private static void print(FxTableView<?> table, FxTreeTableView treeTable, String title, PrinterJob job) {
        Stage stage = Fx.createStage((Modality)Modality.APPLICATION_MODAL);
        TablePrinter printer = (TablePrinter)Fx.load(TablePrinter.class);
        Scene scene = Fx.createScene((Parent)printer.getView());
        stage.setScene(scene);
        stage.setTitle(RdcFxRdcBundle.getString("Printing..."));
        String jobTitle = title == null ? (table != null ? table.getConfiguration().getName() : treeTable.getConfiguration().getName()) : title;
        if (jobTitle != null) {
            job.getJobSettings().setJobName(jobTitle);
        }
        if (table != null) {
            stage.setOnShown(e -> Platform.runLater(() -> printer.print(table, null, jobTitle, job, job.getJobSettings().getPageLayout(), stage)));
        } else {
            stage.setOnShown(e -> Platform.runLater(() -> printer.print(null, treeTable, jobTitle, job, job.getJobSettings().getPageLayout(), stage)));
        }
        stage.setOnCloseRequest(e -> Fx.question((String)RdcFxRdcBundle.getString("cancel print job?"), (boolean)false, answer -> {
            if (answer.booleanValue()) {
                printer.terminationRequested = true;
            } else {
                e.consume();
            }
        }));
        stage.show();
    }

    @FXML
    private void initialize() {
        this.titleLabel.getStyleClass().add((Object)STYLE_TITLE);
        this.bottomLine.getStyleClass().add((Object)STYLE_BOTTOMLINE);
        this.pageLabel.getStyleClass().add((Object)STYLE_BOTTOMLINE);
        this.dateLabel.getStyleClass().add((Object)STYLE_BOTTOMLINE);
        this.jobTimeKeeper = new TimeKeeper();
    }

    private void print(FxTableView<?> table, FxTreeTableView<?> treeTable, String title, PrinterJob job, PageLayout pageLayout, Stage stage) {
        ArrayList items;
        LOGGER.fine("table print job {0}", new Object[]{job});
        this.dateLabel.setText(FormatHelper.formatShortTimestampFast((Date)new Timestamp()));
        double tableWidth = 0.0;
        this.tableView.getColumns().clear();
        if (table != null) {
            this.tableView.setConfiguration(table.getConfiguration());
            for (TableColumn column : table.getColumns()) {
                if (!column.isVisible()) continue;
                columnConfig = column instanceof FxTableColumn ? ((FxTableColumn)column).getConfiguration() : null;
                FxTableColumn printColumn = new FxTableColumn(columnConfig, column.getText());
                printColumn.setCellValueFactory(column.getCellValueFactory());
                printColumn.setCellFactory(new PrintCellFactory(column.getCellFactory()));
                printColumn.setMinWidth(column.getWidth());
                printColumn.setMaxWidth(column.getWidth());
                this.tableView.getColumns().add((Object)printColumn);
                tableWidth += column.getWidth();
            }
        } else {
            this.tableView.setConfiguration(treeTable.getConfiguration());
            for (TreeTableColumn column : treeTable.getColumns()) {
                if (!column.isVisible()) continue;
                columnConfig = column instanceof FxTreeTableColumn ? ((FxTreeTableColumn)column).getConfiguration() : null;
                FxTableColumn printColumn = new FxTableColumn(columnConfig, column.getText());
                printColumn.setCellValueFactory(columnConfig.getTableColumn().getCellValueFactory());
                printColumn.setCellFactory(columnConfig.getTableColumn().getCellFactory());
                printColumn.setMinWidth(column.getWidth());
                printColumn.setMaxWidth(column.getWidth());
                this.tableView.getColumns().add((Object)printColumn);
                tableWidth += column.getWidth();
            }
        }
        double printableWidth = pageLayout.getPrintableWidth();
        double printableHeight = pageLayout.getPrintableHeight();
        double scaleXY = 1.0;
        if (printableWidth < tableWidth) {
            scaleXY = printableWidth / tableWidth;
            tableWidth = printableWidth / scaleXY;
        }
        this.tableView.setMinWidth(tableWidth - 1.0);
        this.tableView.setMaxWidth(tableWidth - 1.0);
        this.titleLabel.setText(title);
        this.updatePageLabel(1);
        this.getView().layout();
        double tableHeight = printableHeight / scaleXY - this.titleLabel.getHeight() - this.bottomLine.getHeight();
        this.tableView.setMinHeight(tableHeight);
        this.tableView.setMaxHeight(tableHeight);
        this.getView().getTransforms().add((Object)new Scale(scaleXY, scaleXY));
        if (table != null) {
            TotalsTableView totalsTable = TotalsTableView.getTotalsTableView(table);
            if (totalsTable != null) {
                items = new ArrayList(table.getItems());
                items.addAll(totalsTable.getItems());
                this.totalsRowCount = totalsTable.getItems().size();
            } else {
                items = table.getItems();
                this.totalsRowCount = 0;
            }
        } else {
            items = treeTable.getItems();
            this.totalsRowCount = 0;
        }
        this.rowCount = items.size();
        Rdc.bg(new PrinterTask(items, job, pageLayout, stage), null, null);
    }

    private void updatePageLabel(int pageNo) {
        this.pageLabel.setText(MessageFormat.format(this.resources.getString("page {0} of {1}"), pageNo, this.pageCount));
    }

    private class PrintCellFactory<S, T>
    implements Callback<TableColumn<S, T>, TableCell<S, T>> {
        private final Callback<TableColumn<S, T>, TableCell<S, T>> orgTableCellFactory;

        public PrintCellFactory(Callback<TableColumn<S, T>, TableCell<S, T>> orgTableCellFactory) {
            this.orgTableCellFactory = orgTableCellFactory;
        }

        public TableCell<S, T> call(TableColumn<S, T> column) {
            Object cell = (TableCell)this.orgTableCellFactory.call(column);
            FxTableColumn fxColumn = (FxTableColumn)column;
            final TableColumnConfiguration columnConfig = fxColumn.getConfiguration();
            if (TablePrinter.this.totalsRowCount > 0 && columnConfig != null) {
                cell = new FxTableCell<S, T>(columnConfig){

                    /*
                     * Enabled aggressive block sorting
                     */
                    protected void updateItem(T item, boolean empty) {
                        block4: {
                            block3: {
                                int index = TablePrinter.this.rowOffset.get() + this.getIndex();
                                if (index < TablePrinter.this.rowCount - TablePrinter.this.totalsRowCount) break block3;
                                if (columnConfig.isSummable() && index < TablePrinter.this.rowCount) {
                                    if (!this.getStyleClass().contains((Object)TablePrinter.STYLE_TOTALS)) {
                                        this.getStyleClass().add((Object)TablePrinter.STYLE_TOTALS);
                                    }
                                    break block4;
                                } else {
                                    this.getStyleClass().remove((Object)TablePrinter.STYLE_TOTALS);
                                    this.setText(null);
                                    this.setGraphic(null);
                                    return;
                                }
                            }
                            this.getStyleClass().remove((Object)TablePrinter.STYLE_TOTALS);
                        }
                        super.updateItem(item, empty);
                    }
                };
            }
            return cell;
        }
    }

    private class PrinterTask
    extends AbstractSessionTask
    implements Supplier<Void> {
        private final List items;
        private final PrinterJob job;
        private final PageLayout pageLayout;
        private final Stage stage;
        private volatile int printableRows;

        private PrinterTask(List items, PrinterJob job, PageLayout pageLayout, Stage stage) {
            this.items = items;
            this.job = job;
            this.pageLayout = pageLayout;
            this.stage = stage;
        }

        private void setPrintableRows(int printableRows) {
            this.printableRows = printableRows;
        }

        public void run() {
            record PageInfo(int rowStart, int rowCount) {
                @Override
                public String toString() {
                    return "print " + this.rowCount + " rows starting at row " + this.rowStart;
                }
            }
            ArrayList<PageInfo> pages = new ArrayList<PageInfo>();
            int size = this.items.size();
            TablePrinter.this.rowOffset.set(0);
            while (TablePrinter.this.rowOffset.get() < size && !TablePrinter.this.terminationRequested) {
                FxUtilities.getInstance().runAndWait(() -> {
                    TablePrinter.this.tableView.setItems(FXCollections.observableList(this.items.subList(TablePrinter.this.rowOffset.get(), size)));
                    TablePrinter.this.getView().layout();
                });
                FxUtilities.getInstance().runAndWait(() -> this.setPrintableRows(this.getVisibleRowCount()));
                if (this.printableRows <= 0) {
                    Platform.runLater(() -> {
                        this.job.cancelJob();
                        Fx.error((String)TablePrinter.this.resources.getString("no printable area"));
                        this.stage.close();
                    });
                    return;
                }
                PageInfo page = new PageInfo(TablePrinter.this.rowOffset.get(), this.printableRows);
                pages.add(page);
                Platform.runLater(() -> this.stage.setTitle(MessageFormat.format(TablePrinter.this.resources.getString("preparing page {0}"), pages.size())));
                TablePrinter.this.rowOffset.addAndGet(this.printableRows);
                LOGGER.fine("page {0}: {1}", new Object[]{pages.size(), page});
                this.getSession().setAlive(true);
            }
            if (TablePrinter.this.terminationRequested) {
                LOGGER.info("job \"{0}\" canceled by user", new Object[]{TablePrinter.this.titleLabel.getText()});
            } else {
                TablePrinter.this.pageCount = pages.size();
                FxUtilities.getInstance().runAndWait(() -> {
                    if (TablePrinter.this.pageCount == 0) {
                        Fx.info((String)TablePrinter.this.resources.getString("no pages to print"));
                        this.job.cancelJob();
                    } else {
                        int pageNo = 1;
                        for (PageInfo page : pages) {
                            TablePrinter.this.rowOffset.set(page.rowStart);
                            TablePrinter.this.tableView.setItems(FXCollections.observableList(this.items.subList(page.rowStart, page.rowStart + page.rowCount)));
                            TablePrinter.this.tableView.getSelectionModel().clearSelection();
                            this.stage.setTitle(MessageFormat.format(TablePrinter.this.resources.getString("printing page {0}/{1}"), pageNo, pages.size()));
                            TablePrinter.this.updatePageLabel(pageNo++);
                            this.job.printPage(this.pageLayout, (Node)TablePrinter.this.getView());
                            if (TablePrinter.this.terminationRequested) break;
                            this.getSession().setAlive(true);
                        }
                        if (TablePrinter.this.terminationRequested) {
                            this.job.cancelJob();
                            LOGGER.info("printing job \"{0}\" canceled by user", new Object[]{TablePrinter.this.titleLabel.getText()});
                        } else {
                            this.job.endJob();
                            TablePrinter.this.jobTimeKeeper.end();
                            LOGGER.info("job \"{0}\", {1} pages printed, {2} s", new Object[]{TablePrinter.this.titleLabel.getText(), pages.size(), TablePrinter.this.jobTimeKeeper.secondsToString()});
                        }
                    }
                    this.stage.close();
                });
            }
        }

        private int getVisibleRowCount() {
            VirtualFlow flow = (VirtualFlow)((TableViewSkin)TablePrinter.this.tableView.getSkin()).getChildren().get(1);
            int start = 0;
            IndexedCell cell = flow.getFirstVisibleCell();
            if (cell != null) {
                start = cell.getIndex();
            }
            cell = flow.getLastVisibleCell();
            int count = -1;
            if (cell != null) {
                int end = cell.getIndex();
                count = end - start;
                if (end >= flow.getCellCount() - 1) {
                    TablePrinter.this.tableView.scrollTo(end);
                    cell = flow.getFirstVisibleCell();
                    if (cell != null && cell.getIndex() == start) {
                        ++count;
                    } else {
                        TablePrinter.this.tableView.scrollTo(start);
                    }
                }
            }
            return count;
        }

        @Override
        public Void get() {
            this.run();
            return null;
        }
    }
}

