/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.translate;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.TransferMode;
import javafx.stage.Modality;
import javafx.stage.Window;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.bind.FxComponentBinding;
import org.tentackle.fx.rdc.RdcFxRdcBundle;
import org.tentackle.fx.rdc.RdcUtilities;
import org.tentackle.log.Logger;
import org.tentackle.misc.IdentifiableKey;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoCache;
import org.tentackle.pdo.PdoRuntimeException;
import org.tentackle.pdo.PdoUtilities;
import org.tentackle.pdo.PersistentDomainObject;

public class PdoComponentAddon<T extends PersistentDomainObject<T>> {
    private static final Logger LOGGER = Logger.get(PdoComponentAddon.class);
    public static final String PDO_STYLE = "tt-pdo-style";
    private final FxComponent component;
    private final Supplier<T> pdoSupplier;
    private final Consumer<T> pdoConsumer;
    private boolean inSearchOrEdit;
    private T pdo;

    public PdoComponentAddon(FxComponent component, Supplier<T> pdoSupplier, Consumer<T> pdoConsumer) {
        this.component = component;
        this.pdoSupplier = pdoSupplier;
        this.pdoConsumer = pdoConsumer;
        Control control = (Control)component;
        control.addEventFilter(KeyEvent.ANY, event -> {
            if (!(event.isAltDown() || event.isControlDown() || event.isMetaDown() || event.isShiftDown() || event.isShortcutDown() || !control.getStyleClass().contains((Object)PDO_STYLE))) {
                if (event.getCode() == KeyCode.F2) {
                    event.consume();
                    if (event.getEventType() == KeyEvent.KEY_PRESSED) {
                        Platform.runLater(this::edit);
                    }
                } else if (event.getCode() == KeyCode.F3) {
                    event.consume();
                    if (event.getEventType() == KeyEvent.KEY_PRESSED) {
                        Platform.runLater(this::search);
                    }
                }
            }
        });
        control.setOnDragDetected(event -> {
            PersistentDomainObject pdo = (PersistentDomainObject)this.pdoSupplier.get();
            if (pdo != null && RdcUtilities.getInstance().createDragboard((Node)control, pdo) != null) {
                event.consume();
            }
        });
        control.setOnDragOver(e -> {
            IdentifiableKey key;
            String idString;
            Class type;
            if (e.getGestureSource() != component && (type = component.getType()) != null && (idString = e.getDragboard().getString()) != null && !idString.isEmpty() && type.isAssignableFrom((key = PdoUtilities.getInstance().idStringToIdentifiableKey(idString)).getIdentifiableClass())) {
                e.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
                e.consume();
            }
        });
        control.setOnDragDropped(e -> {
            PersistentDomainObject<?> pdoToDrop;
            DomainContext context;
            FxComponentBinding binding;
            Class type = component.getType();
            boolean dropped = false;
            if (type != null && (binding = component.getBinding()) != null && (context = (DomainContext)binding.getBinder().getBindingProperty(DomainContext.class)) != null && (pdoToDrop = RdcUtilities.getInstance().getPdoFromDragboard(e.getDragboard(), context)) != null && type.isAssignableFrom(pdoToDrop.getEffectiveClass())) {
                this.pdoConsumer.accept(pdoToDrop);
                e.setDropCompleted(true);
                dropped = true;
            }
            if (!dropped) {
                e.consume();
            }
        });
        if (!control.getStyleClass().contains((Object)PDO_STYLE)) {
            MenuItem separatorItem;
            ContextMenu menu;
            control.getStyleClass().add((Object)PDO_STYLE);
            if (control.getContextMenu() == null) {
                menu = (ContextMenu)Fx.create(ContextMenu.class);
                control.setContextMenu(menu);
                separatorItem = null;
            } else {
                separatorItem = (MenuItem)Fx.create(SeparatorMenuItem.class);
                menu = control.getContextMenu();
                menu.getItems().add((Object)separatorItem);
            }
            MenuItem editItem = (MenuItem)Fx.create(MenuItem.class);
            editItem.setText(RdcFxRdcBundle.getString("EDIT"));
            editItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.F2, new KeyCombination.Modifier[0]));
            editItem.setOnAction(event -> this.edit());
            MenuItem searchItem = (MenuItem)Fx.create(MenuItem.class);
            searchItem.setText(RdcFxRdcBundle.getString("SEARCH"));
            searchItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.F3, new KeyCombination.Modifier[0]));
            searchItem.setOnAction(event -> this.search());
            menu.getItems().addAll((Object[])new MenuItem[]{editItem, searchItem});
            menu.setOnShowing(event -> {
                if (control.getStyleClass().contains((Object)PDO_STYLE)) {
                    editItem.setDisable(this.pdoSupplier.get() == null);
                } else {
                    menu.getItems().remove((Object)searchItem);
                    menu.getItems().remove((Object)editItem);
                    if (separatorItem != null) {
                        menu.getItems().remove((Object)separatorItem);
                    }
                }
            });
        }
    }

    public FxComponent getComponent() {
        return this.component;
    }

    public Supplier<T> getPdoSupplier() {
        return this.pdoSupplier;
    }

    public Consumer<T> getPdoConsumer() {
        return this.pdoConsumer;
    }

    public T getPdo() {
        return this.pdo;
    }

    public void setPdo(T pdo) {
        this.pdo = pdo;
    }

    public Collection<T> getAllPdos(T proxy) {
        PdoCache cache = proxy.getCache();
        if (cache != null && cache.isPreloading()) {
            return proxy.selectAllCached();
        }
        List pdos = proxy.selectAll();
        LOGGER.warning("{0} {1} retrieved by selectAll() -> consider caching with preloading!", new Object[]{pdos.size(), proxy.getEffectiveClass().getName()});
        return pdos;
    }

    public boolean isInSearchOrEdit() {
        return this.inSearchOrEdit;
    }

    public void edit() {
        if (!this.inSearchOrEdit) {
            this.pdo = (PersistentDomainObject)this.pdoSupplier.get();
            if (this.pdo != null) {
                this.pdo = this.pdo.reload();
                if (this.pdo != null) {
                    this.inSearchOrEdit = true;
                    try {
                        ObservableList pdoList = FXCollections.observableArrayList();
                        pdoList.add(this.pdo);
                        RdcUtilities.getInstance().displayCrudStage(this.pdo, pdoList, !this.pdo.isImmutable(), Modality.APPLICATION_MODAL, (Window)Fx.getStage((Node)((Node)this.component)), p -> {
                            this.pdo = p;
                            this.inSearchOrEdit = false;
                            this.component.setViewValue(this.pdo);
                            this.component.updateModel();
                        }, null);
                    }
                    catch (RuntimeException rx) {
                        this.inSearchOrEdit = false;
                        throw rx;
                    }
                }
            }
        }
    }

    public void search() {
        if (!this.inSearchOrEdit) {
            Object proxy;
            try {
                proxy = this.createPdo();
            }
            catch (PdoRuntimeException px) {
                if (this.pdo == null) {
                    return;
                }
                proxy = this.pdo.on();
            }
            this.inSearchOrEdit = true;
            try {
                this.searchPdo(proxy, found -> {
                    this.inSearchOrEdit = false;
                    if (found != null && this.component.isChangeable()) {
                        this.pdo = found;
                        this.component.setViewValue(this.pdo);
                        this.component.updateModel();
                    }
                });
            }
            catch (RuntimeException rx) {
                this.inSearchOrEdit = false;
                throw rx;
            }
        }
    }

    public T createPdo() {
        Class pdoClass = this.component.getType();
        DomainContext context = this.getDomainContext();
        if (context == null) {
            throw new FxRuntimeException("missing binding property for DomainContext");
        }
        return (T)Pdo.create((Class)pdoClass, (DomainContext)context);
    }

    public DomainContext getDomainContext() {
        DomainContext context = this.component.getParentContainer() != null ? (DomainContext)this.component.getBinding().getBinder().getBindingProperty(DomainContext.class) : (this.component.getTableCell() != null ? (DomainContext)this.component.getTableCell().getColumnConfiguration().getTableConfiguration().getBinder().getBindingProperty(DomainContext.class) : (this.component.getTreeTableCell() != null ? (DomainContext)this.component.getTreeTableCell().getColumnConfiguration().getTableConfiguration().getBinder().getBindingProperty(DomainContext.class) : (DomainContext)((Node)this.component).getProperties().get(DomainContext.class)));
        return context;
    }

    public void searchPdo(T proxy, Consumer<T> selectedItem) {
        RdcUtilities.getInstance().displaySearchStage(proxy, Modality.APPLICATION_MODAL, (Window)Fx.getStage((Node)((Node)this.component)), true, list -> selectedItem.accept(list.isEmpty() ? null : (PersistentDomainObject)list.get(0)));
    }
}

