/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.stage.Modality;
import javafx.stage.Window;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxUtilities;
import org.tentackle.fx.component.FxTableView;
import org.tentackle.fx.component.FxTreeTableView;
import org.tentackle.fx.rdc.GuiProvider;
import org.tentackle.fx.rdc.GuiProviderFactory;
import org.tentackle.fx.rdc.PdoTableCell;
import org.tentackle.fx.rdc.PdoTreeTableCell;
import org.tentackle.fx.rdc.RdcFactory;
import org.tentackle.fx.rdc.RdcUtilities;
import org.tentackle.fx.rdc.crud.PdoCrud;
import org.tentackle.fx.rdc.search.PdoSearch;
import org.tentackle.fx.rdc.table.TablePopup;
import org.tentackle.fx.table.TableColumnConfiguration;
import org.tentackle.pdo.PersistentDomainObject;

public class Rdc {
    public static <T extends PersistentDomainObject<T>> PdoCrud<T> createPdoCrud(T pdo, boolean editable, boolean modal) {
        return RdcFactory.getInstance().createPdoCrud(pdo, editable, modal);
    }

    public static <T extends PersistentDomainObject<T>> PdoSearch<T> createPdoSearch(T pdo) {
        return RdcFactory.getInstance().createPdoSearch(pdo);
    }

    public static <T extends PersistentDomainObject<T>> GuiProvider<T> createGuiProvider(T pdo) {
        return GuiProviderFactory.getInstance().createGuiProvider(pdo);
    }

    public static <S> TablePopup<S> createTablePopup(FxTableView<S> table, String preferencesSuffix, String title) {
        return RdcFactory.getInstance().createTablePopup(table, preferencesSuffix, title);
    }

    public static <S> TablePopup<S> createTablePopup(FxTreeTableView<S> treeTable, String preferencesSuffix, String title) {
        return RdcFactory.getInstance().createTablePopup(treeTable, preferencesSuffix, title);
    }

    public static <T extends PersistentDomainObject<T>> TreeItem<T> createTreeItem(T pdo) {
        return RdcFactory.getInstance().createTreeItem(pdo);
    }

    public static <T extends PersistentDomainObject<T>> TreeCell<T> createTreeCell(TreeView<T> treeView) {
        return RdcFactory.getInstance().createTreeCell(treeView);
    }

    public static <S, T extends PersistentDomainObject<T>> PdoTableCell<S, T> createTableCell(TableColumnConfiguration<S, T> columnConfig) {
        return RdcFactory.getInstance().createTableCell(columnConfig);
    }

    public static <S, T extends PersistentDomainObject<T>> PdoTreeTableCell<S, T> createTreeTableCell(TableColumnConfiguration<S, T> columnConfig) {
        return RdcFactory.getInstance().createTreeTableCell(columnConfig);
    }

    public static <T extends PersistentDomainObject<T>> void displayCrudStage(T pdo, boolean editable, Window owner) {
        Rdc.displayCrudStage(pdo, null, editable, Modality.NONE, owner, null, null);
    }

    public static <T extends PersistentDomainObject<T>> void displayCrudStage(T pdo, boolean editable, Modality modality, Window owner, Consumer<T> updatedPdo) {
        Rdc.displayCrudStage(pdo, null, editable, modality, owner, updatedPdo, null);
    }

    public static <T extends PersistentDomainObject<T>> void displayCrudStage(T pdo, ObservableList<T> pdoList, boolean editable, Modality modality, Window owner, Consumer<T> updatedPdo, Consumer<PdoCrud<T>> configurator) {
        RdcUtilities.getInstance().displayCrudStage(pdo, pdoList, editable, modality, owner, updatedPdo, configurator);
    }

    public static <T extends PersistentDomainObject<T>> PdoCrud<T> getCrud(T pdo, ObservableList<T> pdoList, boolean editable, Modality modality, Window owner) {
        return RdcUtilities.getInstance().getCrud(pdo, pdoList, editable, modality, owner);
    }

    public static <T extends PersistentDomainObject<T>> void displaySearchStage(T pdo, Window owner, boolean createPdoAllowed) {
        Rdc.displaySearchStage(pdo, Modality.NONE, owner, createPdoAllowed, null, null);
    }

    public static <T extends PersistentDomainObject<T>> void displaySearchStage(T pdo, Modality modality, Window owner, boolean createPdoAllowed, Consumer<ObservableList<T>> selectedItems) {
        Rdc.displaySearchStage(pdo, modality, owner, createPdoAllowed, selectedItems, null);
    }

    public static <T extends PersistentDomainObject<T>> void displaySearchStage(T pdo, Modality modality, Window owner, boolean createPdoAllowed, Consumer<ObservableList<T>> selectedItems, Consumer<PdoSearch<T>> configurator) {
        RdcUtilities.getInstance().displaySearchStage(pdo, modality, owner, createPdoAllowed, selectedItems, configurator);
    }

    public static <T extends PersistentDomainObject<T>> PdoSearch<T> getSearch(T pdo, Modality modality, Window owner) {
        return RdcUtilities.getInstance().getSearch(pdo, modality, owner);
    }

    public static <T extends PersistentDomainObject<T>> void showTree(T pdo) {
        RdcUtilities.getInstance().showTree(pdo);
    }

    public static void showSaveDiscardCancelDialog(Consumer<Boolean> doIt) {
        RdcUtilities.getInstance().showSaveDiscardCancelDialog(doIt);
    }

    public static void closeStageHierarchy(Node node) {
        FxUtilities.getInstance().closeStageHierarchy(node, RdcUtilities.getInstance().getMainStage());
    }

    public static <V> void bg(Supplier<V> runner, Consumer<V> updateUI, Consumer<RuntimeException> failedUI) {
        RdcUtilities.getInstance().runInBackground(runner, updateUI, failedUI);
    }

    public static <V> void bg(Supplier<V> runner, Consumer<V> updateUI) {
        Rdc.bg(runner, updateUI, rx -> Fx.error((String)rx.getLocalizedMessage(), (Throwable)rx));
    }

    public static void bg(Runnable runner) {
        Rdc.bg(() -> {
            runner.run();
            return null;
        }, null);
    }

    private Rdc() {
    }
}

