/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc;

import java.util.ArrayList;
import java.util.Objects;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.DragEvent;
import javafx.scene.input.MouseEvent;
import org.tentackle.common.StringHelper;
import org.tentackle.fx.rdc.GuiProvider;
import org.tentackle.fx.rdc.PdoContextMenuFactory;
import org.tentackle.fx.rdc.PdoTreeItem;
import org.tentackle.fx.rdc.Rdc;
import org.tentackle.fx.rdc.RdcUtilities;
import org.tentackle.pdo.PersistentDomainObject;

public class PdoTreeCell<T extends PersistentDomainObject<T>>
extends TreeCell<T> {
    private GuiProvider<T> provider;
    private ContextMenu contextMenu;

    public PdoTreeCell() {
        this.addEventHandler(MouseEvent.ANY, this::showContextMenu);
        this.setOnDragDetected(this::handleDragDetected);
        this.setOnDragOver(this::handleDragOver);
        this.setOnDragDropped(this::handleDragDropped);
    }

    public void updateItem(T pdo, boolean empty) {
        super.updateItem(pdo, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
            this.provider = null;
        } else {
            GuiProvider<T> guiProvider = this.provider = pdo == null ? null : Rdc.createGuiProvider(pdo);
            if (this.provider == null) {
                this.setText(null);
                this.setTooltip(null);
                this.setGraphic(null);
            } else {
                PdoTreeItem parentItem = this.getPdoTreeItem().getParentPdoItem();
                String treeText = this.provider.getTreeText(parentItem == null ? null : (PersistentDomainObject)parentItem.getPdo());
                this.setText(treeText);
                String tooltipText = this.provider.getToolTipText(parentItem == null ? null : (PersistentDomainObject)parentItem.getPdo());
                if (StringHelper.isAllWhitespace((String)tooltipText) || Objects.equals(treeText, tooltipText)) {
                    tooltipText = null;
                }
                this.setTooltip(tooltipText == null ? null : new Tooltip(tooltipText));
                this.setGraphic(this.provider.createGraphic());
            }
        }
    }

    public PdoTreeItem<T> getPdoTreeItem() {
        return (PdoTreeItem)this.getTreeItem();
    }

    protected GuiProvider<T> getGuiProvider() {
        return this.provider;
    }

    protected void handleDragDetected(MouseEvent event) {
        PersistentDomainObject[] selectedPdos = null;
        TreeView treeView = this.getTreeView();
        if (treeView != null) {
            ArrayList pdoList = new ArrayList();
            for (TreeItem selectedItem : treeView.getSelectionModel().getSelectedItems()) {
                PdoTreeItem pdoTreeItem;
                Object pdo;
                if (!(selectedItem instanceof PdoTreeItem) || (pdo = (pdoTreeItem = (PdoTreeItem)selectedItem).getPdo()) == null) continue;
                pdoList.add(pdo);
            }
            if (!pdoList.isEmpty()) {
                selectedPdos = pdoList.toArray(new PersistentDomainObject[0]);
            }
        }
        if (selectedPdos != null && RdcUtilities.getInstance().createDragboard((Node)this, selectedPdos) != null || this.provider != null && this.provider.createDragboard((Node)this) != null) {
            event.consume();
        }
    }

    protected void handleDragOver(DragEvent event) {
        if (event.getGestureSource() != this && this.provider != null && this.provider.isDragAccepted(event)) {
            event.consume();
        }
    }

    protected void handleDragDropped(DragEvent event) {
        if (this.provider != null) {
            this.provider.dropDragboard(event.getDragboard());
            event.setDropCompleted(true);
            PersistentDomainObject reloadedPdo = this.provider.getPdo().reload();
            TreeItem root = this.getTreeItem().getParent();
            if (root != null) {
                ObservableList items = root.getChildren();
                int i = 0;
                for (TreeItem item : items) {
                    if (reloadedPdo.equals(item.getValue())) {
                        TreeItem<PersistentDomainObject> reloadedItem = Rdc.createGuiProvider(reloadedPdo).createTreeItem();
                        items.set(i, reloadedItem);
                        this.getTreeView().refresh();
                        reloadedItem.setExpanded(true);
                        break;
                    }
                    ++i;
                }
            }
        } else {
            event.consume();
        }
    }

    private void showContextMenu(MouseEvent event) {
        if (event.isPopupTrigger()) {
            if (this.contextMenu != null) {
                this.contextMenu.hide();
            }
            if (this.getTreeView().getContextMenu() == null) {
                this.contextMenu = PdoContextMenuFactory.getInstance().create(this);
                if (this.contextMenu != null) {
                    event.consume();
                    this.contextMenu.setOnHidden(e -> {
                        this.contextMenu = null;
                    });
                    this.contextMenu.show((Node)this, event.getScreenX(), event.getScreenY());
                }
            }
        }
    }
}

