/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Popup;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.tentackle.app.Application;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxFactory;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.FxUtilities;
import org.tentackle.fx.NotificationBuilder;
import org.tentackle.fx.rdc.GuiProvider;
import org.tentackle.fx.rdc.GuiProviderFactory;
import org.tentackle.fx.rdc.RdcFactory;
import org.tentackle.fx.rdc.RdcFxRdcBundle;
import org.tentackle.fx.rdc.RdcUtilitiesHolder;
import org.tentackle.fx.rdc.app.DesktopApplication;
import org.tentackle.fx.rdc.crud.PdoCrud;
import org.tentackle.fx.rdc.search.PdoSearch;
import org.tentackle.log.Logger;
import org.tentackle.misc.Holder;
import org.tentackle.misc.IdentifiableKey;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoUtilities;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.session.AbstractSessionTask;
import org.tentackle.session.ModificationTracker;
import org.tentackle.session.SessionDependable;
import org.tentackle.task.Task;

@Service(value=RdcUtilities.class)
public class RdcUtilities {
    private static final Logger LOGGER = Logger.get(RdcUtilities.class);
    private final Map<Class<?>, Set<PdoCrud<?>>> crudCache;
    private final Map<Class<?>, Set<PdoSearch<?>>> searchCache;

    public static RdcUtilities getInstance() {
        return RdcUtilitiesHolder.INSTANCE;
    }

    public RdcUtilities() {
        if (Application.getInstance().isServer()) {
            this.crudCache = null;
            this.searchCache = null;
        } else {
            this.crudCache = new HashMap();
            this.searchCache = new HashMap();
        }
    }

    public <T extends PersistentDomainObject<T>> void displayCrudStage(T pdo, ObservableList<T> pdoList, boolean editable, Modality modality, Window owner, Consumer<T> updatedPdo, Consumer<PdoCrud<T>> configurator) {
        PdoCrud crud = this.getCrud(pdo, pdoList, editable, modality, owner);
        if (crud != null) {
            Stage stage = crud.getStage();
            if (stage == null && Fx.getStage((Node)crud.getView()) == null) {
                stage = Fx.createStage((Modality)modality);
                if (owner != null) {
                    stage.initOwner(owner);
                }
                Scene scene = Fx.createScene((Parent)crud.getView());
                stage.setScene(scene);
                crud.updateTitle();
                Stage s = stage;
                stage.addEventFilter(WindowEvent.WINDOW_SHOWN, e -> Platform.runLater(() -> {
                    Point2D location = FxUtilities.getInstance().determinePreferredStageLocation(s);
                    s.setX(location.getX());
                    s.setY(location.getY());
                    crud.getEditor().requestInitialFocus();
                }));
                stage.addEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, e -> {
                    e.consume();
                    crud.cancel();
                });
                stage.addEventFilter(WindowEvent.WINDOW_HIDING, e -> {
                    Object oldPdo = crud.getPdo();
                    if (oldPdo != null && oldPdo.getEditedBy() != 0L && oldPdo.isTokenLockableByMe()) {
                        crud.releaseTokenLock(oldPdo);
                    }
                });
                stage.addEventFilter(WindowEvent.WINDOW_HIDDEN, e -> {
                    crud.setPdoList(null);
                    crud.removeAllPdoEventListeners();
                });
            }
            if (configurator != null) {
                configurator.accept(crud);
            }
            if (stage == null) {
                throw new FxRuntimeException("misconfigured crud stage");
            }
            if (modality != Modality.NONE && updatedPdo != null) {
                stage.setOnHidden(event -> updatedPdo.accept(crud.getPdo()));
            } else {
                stage.setOnHidden(null);
            }
            stage.show();
        }
    }

    public synchronized <T extends PersistentDomainObject<T>> PdoCrud<T> getCrud(T pdo, ObservableList<T> pdoList, boolean editable, Modality modality, Window owner) {
        Set cruds;
        if (this.crudCache != null) {
            Class pdoClass = pdo.getEffectiveClass();
            cruds = this.crudCache.computeIfAbsent(pdoClass, k -> new HashSet());
            Iterator iter = cruds.iterator();
            while (iter.hasNext()) {
                PdoCrud crud = (PdoCrud)iter.next();
                Stage stage = Fx.getStage((Node)crud.getView());
                if (stage == null || !stage.isShowing() && stage.getModality() == modality && stage.getOwner() == owner) {
                    crud.setEditable(editable);
                    crud.setModal(modality != Modality.NONE);
                    crud.setPdo(pdo);
                    crud.setPdoList(pdoList);
                    return crud;
                }
                if (Objects.equals(pdo, crud.getPdo()) && stage.isShowing() && (crud.isEditing() || !editable)) {
                    stage.toFront();
                    return null;
                }
                if (stage.isShowing() || stage.getModality() != modality || stage.getOwner() == owner || stage.getOwner() == null || stage.getOwner().isShowing()) continue;
                iter.remove();
            }
        } else {
            cruds = null;
        }
        PdoCrud<T> crud = RdcFactory.getInstance().createPdoCrud(pdo, editable, modality != Modality.NONE);
        crud.setPdoList(pdoList);
        if (cruds != null) {
            cruds.add(crud);
        }
        return crud;
    }

    public synchronized <T extends PersistentDomainObject<T>> Stage getCrud(T pdo, boolean editable) {
        Class pdoClass;
        Set<PdoCrud<?>> cruds;
        if (this.crudCache != null && (cruds = this.crudCache.get(pdoClass = pdo.getEffectiveClass())) != null) {
            for (PdoCrud<?> crud : cruds) {
                Stage stage = Fx.getStage((Node)crud.getView());
                if (stage == null || !Objects.equals(pdo, crud.getPdo()) || !stage.isShowing() || !crud.isEditing() && editable) continue;
                stage.toFront();
                return stage;
            }
        }
        return null;
    }

    public <T extends PersistentDomainObject<T>> void displaySearchStage(T pdo, Modality modality, Window owner, boolean createPdoAllowed, Consumer<ObservableList<T>> selectedItems) {
        this.displaySearchStage(pdo, modality, owner, createPdoAllowed, selectedItems, null);
    }

    public <T extends PersistentDomainObject<T>> void displaySearchStage(T pdo, Modality modality, Window owner, boolean createPdoAllowed, Consumer<ObservableList<T>> selectedItems, Consumer<PdoSearch<T>> configurator) {
        PdoSearch search = this.getSearch(pdo, modality, owner);
        search.setCreatePdoAllowed(createPdoAllowed);
        Stage stage = search.getStage();
        if (stage == null && Fx.getStage((Node)search.getView()) == null) {
            stage = Fx.createStage((Modality)modality);
            if (owner != null) {
                stage.initOwner(owner);
            }
            Scene scene = Fx.createScene((Parent)search.getView());
            stage.setScene(scene);
            search.updateTitle();
            search.setSingleSelectMode(Fx.isModal((Stage)stage));
            Stage s = stage;
            stage.addEventFilter(WindowEvent.WINDOW_SHOWN, e -> Platform.runLater(() -> {
                Point2D location = FxUtilities.getInstance().determinePreferredStageLocation(s);
                s.setX(location.getX());
                s.setY(location.getY());
                search.getFinder().requestInitialFocus();
            }));
            stage.addEventFilter(WindowEvent.WINDOW_HIDDEN, e -> Platform.runLater(() -> search.setItems(null)));
        }
        if (configurator != null) {
            configurator.accept(search);
        }
        if (stage == null) {
            throw new FxRuntimeException("misconfigured search stage");
        }
        if (modality != Modality.NONE && selectedItems != null) {
            stage.setOnHidden(event -> selectedItems.accept(search.getSelectedItems()));
        } else {
            stage.setOnHidden(null);
        }
        stage.show();
    }

    public synchronized <T extends PersistentDomainObject<T>> PdoSearch<T> getSearch(T pdo, Modality modality, Window owner) {
        Set searches;
        if (this.searchCache != null) {
            Class pdoClass = pdo.getEffectiveClass();
            searches = this.searchCache.computeIfAbsent(pdoClass, k -> new HashSet());
            Iterator iter = searches.iterator();
            while (iter.hasNext()) {
                PdoSearch search = (PdoSearch)iter.next();
                Stage stage = Fx.getStage((Node)search.getView());
                if (stage == null || !stage.isShowing() && stage.getModality() == modality && stage.getOwner() == owner) {
                    search.setItems(null);
                    search.setPdo(pdo);
                    if (search.getFinder().isTreeShowingInitially()) {
                        search.showTree();
                    } else {
                        search.showTable();
                    }
                    return search;
                }
                if (stage.isShowing() || stage.getModality() != modality || stage.getOwner() == owner || stage.getOwner() == null || stage.getOwner().isShowing()) continue;
                iter.remove();
            }
        } else {
            searches = null;
        }
        PdoSearch<T> search = RdcFactory.getInstance().createPdoSearch(pdo);
        if (searches != null) {
            searches.add(search);
        }
        return search;
    }

    public void showSaveDiscardCancelDialog(Object owner, Consumer<Boolean> doIt) {
        Holder result = new Holder();
        Popup popup = new Popup();
        Parent notification = FxFactory.getInstance().createNotificationBuilder().type(NotificationBuilder.Type.QUESTION).text(RdcFxRdcBundle.getString("DATA_HAS_BEEN_MODIFIED!_DISCARD,_SAVE_OR_CANCEL?")).button(RdcFxRdcBundle.getString("SAVE"), null, false, () -> result.accept((Object)Boolean.TRUE)).button(RdcFxRdcBundle.getString("DISCARD"), null, false, () -> result.accept((Object)Boolean.FALSE)).button(RdcFxRdcBundle.getString("CANCEL"), null, true, null).hide(() -> ((Popup)popup).hide()).build();
        FxUtilities.getInstance().showNotification(owner, popup, notification, () -> doIt.accept((Boolean)result.get()));
    }

    public <T extends PersistentDomainObject<T>> void showTree(T pdo) {
        Stage stage = Fx.createStage((Modality)Modality.APPLICATION_MODAL);
        TreeView tree = (TreeView)Fx.create(TreeView.class);
        GuiProvider<T> guiProvider = GuiProviderFactory.getInstance().createGuiProvider(pdo);
        tree.setCellFactory(guiProvider.getTreeCellFactory());
        TreeItem<T> item = guiProvider.createTreeItem();
        item.setExpanded(true);
        tree.setRoot(item);
        Scene scene = Fx.createScene((Parent)tree);
        stage.setScene(scene);
        stage.setTitle(MessageFormat.format(RdcFxRdcBundle.getString("{0} {1} (modal)"), pdo.getSingular(), pdo.toString()));
        stage.show();
    }

    public <V> void runInBackground(final Node node, final Supplier<V> runner, final Consumer<V> updateUI, final Consumer<RuntimeException> failedUI) {
        AbstractSessionTask task;
        if (runner instanceof AbstractSessionTask && updateUI == null && failedUI == null && node == null) {
            task = (AbstractSessionTask)runner;
        } else {
            Cursor oldCursor;
            if (node != null) {
                oldCursor = node.getCursor();
                node.setCursor(FxUtilities.getInstance().getWaitCursor(node));
            } else {
                oldCursor = null;
            }
            task = new AbstractSessionTask(){

                public void run() {
                    try {
                        if (runner instanceof SessionDependable) {
                            ((SessionDependable)runner).setSession(this.getSession());
                        }
                        Object value = runner.get();
                        Platform.runLater(this::restoreCursor);
                        if (updateUI != null) {
                            Platform.runLater(() -> updateUI.accept(value));
                        }
                    }
                    catch (RuntimeException rx) {
                        Platform.runLater(this::restoreCursor);
                        if (failedUI != null) {
                            Platform.runLater(() -> failedUI.accept(rx));
                        }
                        LOGGER.severe("background task failed", (Throwable)rx);
                    }
                }

                private void restoreCursor() {
                    if (node != null) {
                        node.setCursor(oldCursor == null ? null : FxUtilities.getInstance().getDefaultCursor(node));
                    }
                }
            };
        }
        ModificationTracker.getInstance().addTask((Task)task);
    }

    public Dragboard createDragboard(Node node, PersistentDomainObject<?> ... pdos) {
        if (pdos != null) {
            StringBuilder buf = new StringBuilder();
            for (PersistentDomainObject<?> pdo : pdos) {
                if (pdo.getClassId() == 0 || pdo.isNew()) continue;
                if (!buf.isEmpty()) {
                    buf.append(',');
                }
                buf.append(pdo.toIdString());
            }
            if (!buf.isEmpty()) {
                Dragboard dragboard = node.startDragAndDrop(new TransferMode[]{TransferMode.COPY});
                ClipboardContent content = new ClipboardContent();
                content.putString(buf.toString());
                dragboard.setContent((Map)content);
                return dragboard;
            }
        }
        return null;
    }

    public List<IdentifiableKey<PersistentDomainObject<?>>> getPdoKeysFromDragboard(Dragboard dragboard) {
        ArrayList keys = new ArrayList();
        String idString = dragboard.getString();
        if (idString != null) {
            StringTokenizer stok = new StringTokenizer(idString, ",");
            while (stok.hasMoreTokens()) {
                keys.add(PdoUtilities.getInstance().idStringToIdentifiableKey(stok.nextToken()));
            }
        }
        return keys;
    }

    public IdentifiableKey<PersistentDomainObject<?>> getPdoKeyFromDragboard(Dragboard dragboard) {
        List<IdentifiableKey<PersistentDomainObject<?>>> pdoKeysFromDragboard = this.getPdoKeysFromDragboard(dragboard);
        return pdoKeysFromDragboard.isEmpty() ? null : pdoKeysFromDragboard.get(0);
    }

    public List<PersistentDomainObject<?>> getPdosFromDragboard(Dragboard dragboard, DomainContext context) {
        ArrayList pdos = new ArrayList();
        for (IdentifiableKey<PersistentDomainObject<?>> pdoKey : this.getPdoKeysFromDragboard(dragboard)) {
            PersistentDomainObject pdo = Pdo.create((Class)pdoKey.getIdentifiableClass(), (DomainContext)context).select(pdoKey.getIdentifiableId());
            if (pdo == null) continue;
            pdos.add(pdo);
        }
        return pdos;
    }

    public PersistentDomainObject<?> getPdoFromDragboard(Dragboard dragboard, DomainContext context) {
        List<PersistentDomainObject<?>> pdos = this.getPdosFromDragboard(dragboard, context);
        return pdos.isEmpty() ? null : pdos.get(0);
    }

    public File selectFile(String prefName, String prefKey, String fileExtension, String fileType, Stage owner) {
        Preferences prefs = Preferences.userRoot();
        String applicationName = Application.getInstance().getName();
        if (!StringHelper.isAllWhitespace((String)applicationName)) {
            prefs = prefs.node(applicationName);
        }
        prefs = prefs.node(prefName);
        String lastName = prefs.get(prefKey, null);
        FileChooser fc = new FileChooser();
        if (lastName != null) {
            fc.setInitialFileName(lastName);
        }
        fc.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(fileType, new String[]{fileExtension})});
        File selectedFile = fc.showSaveDialog((Window)owner);
        if (selectedFile != null) {
            if (!selectedFile.getName().toLowerCase(Locale.ROOT).endsWith(fileExtension)) {
                selectedFile = new File(selectedFile.getPath() + fileExtension);
            }
            String filePath = selectedFile.getAbsolutePath();
            prefs.put(prefKey, filePath);
            try {
                prefs.flush();
            }
            catch (BackingStoreException bx) {
                LOGGER.warning("cannot save user preferences {0}", new Object[]{prefs.absolutePath()});
                LOGGER.fine(filePath, (Throwable)bx);
            }
        }
        return selectedFile;
    }

    public Stage getMainStage() {
        return ((DesktopApplication)Application.getInstance()).getMainStage();
    }
}

