/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.search;

import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import org.tentackle.common.StringHelper;
import org.tentackle.fx.CaseConversion;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.component.FxTextField;
import org.tentackle.fx.rdc.PdoFinder;
import org.tentackle.pdo.PdoCache;
import org.tentackle.pdo.PersistentDomainObject;

@FxControllerService(binding=FxControllerService.BINDING.NO)
public class DefaultPdoFinder<T extends PersistentDomainObject<T>>
extends PdoFinder<T> {
    private T pdo;
    @FXML
    private FxTextField patternField;

    @Override
    public List<T> runSearch() {
        if (this.pdo != null) {
            String pattern;
            if (this.pdo.isNormTextProvided() && !StringHelper.isAllWhitespace((String)(pattern = this.patternField.getText()))) {
                return this.pdo.selectByNormText(pattern);
            }
            PdoCache cache = this.pdo.getCache();
            if (cache != null && cache.isPreloading()) {
                return this.pdo.selectAllCached();
            }
            return this.pdo.selectAll();
        }
        return List.of();
    }

    @FXML
    private void initialize() {
        this.patternField.setCaseConversion(CaseConversion.UPPER_CASE);
    }

    public T getPdo() {
        return this.pdo;
    }

    @Override
    public void setPdo(T pdo) {
        this.pdo = pdo;
        this.patternField.clear();
    }

    @Override
    public boolean isSearchRunningImmediately() {
        return super.isSearchRunningImmediately() || this.pdo != null && !this.pdo.isNormTextProvided();
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.pdo != null && this.pdo.isNormTextProvided() && !this.isSearchRunningImmediately();
    }

    @Override
    public void requestInitialFocus() {
        if (this.pdo != null && this.pdo.isNormTextProvided()) {
            this.patternField.requestFocus();
        }
    }

    @Override
    public ObjectProperty<EventHandler<ActionEvent>> getSearchActionProperty() {
        return this.patternField.onActionProperty();
    }
}

