/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.security;

import javafx.geometry.Pos;
import javafx.scene.Node;
import org.tentackle.fx.Fx;
import org.tentackle.fx.rdc.DefaultGuiProvider;
import org.tentackle.fx.rdc.GuiProviderService;
import org.tentackle.fx.rdc.security.SecurityEditor;
import org.tentackle.fx.table.FxTableCell;
import org.tentackle.fx.table.TableCellType;
import org.tentackle.fx.table.TableColumnConfiguration;
import org.tentackle.fx.table.TableConfiguration;
import org.tentackle.fx.table.type.BooleanTableCellType;
import org.tentackle.security.pdo.Security;

@GuiProviderService(value=Security.class)
public class SecurityGuiProvider
extends DefaultGuiProvider<Security> {
    public SecurityGuiProvider(Security pdo) {
        super(pdo);
    }

    @Override
    public Node createGraphic() {
        return Fx.createGraphic((String)"security");
    }

    public SecurityEditor createEditor() {
        return (SecurityEditor)Fx.load(SecurityEditor.class);
    }

    @Override
    public boolean isEditorAvailable() {
        return true;
    }

    @Override
    public TableConfiguration<Security> createTableConfiguration() {
        TableConfiguration config = this.createEmptyTableConfiguration();
        config.addColumn("granteeToString", this.getBundle().getString("grantee"));
        config.addColumn("contextToString", this.getBundle().getString("context"));
        config.addColumn("permissions", this.getBundle().getString("permissions"));
        TableColumnConfiguration allowedConfiguration = config.addColumn("allowed", this.getBundle().getString("allowed"));
        allowedConfiguration.setCellType((TableCellType)new BooleanTableCellType(){

            public void updateItem(FxTableCell<?, Boolean> tableCell, Boolean item) {
                tableCell.setText(null);
                if (item.booleanValue()) {
                    tableCell.setGraphic(Fx.createGraphic((String)"ok"));
                    tableCell.getStyleClass().remove((Object)"sec-deny");
                    if (!tableCell.getStyleClass().contains((Object)"sec-allow")) {
                        tableCell.getStyleClass().add((Object)"sec-allow");
                    }
                } else {
                    tableCell.setGraphic(Fx.createGraphic((String)"cancel"));
                    tableCell.getStyleClass().remove((Object)"sec-allow");
                    if (!tableCell.getStyleClass().contains((Object)"sec-deny")) {
                        tableCell.getStyleClass().add((Object)"sec-deny");
                    }
                }
                this.updateAlignment(tableCell, Pos.BASELINE_CENTER);
            }
        });
        config.addColumn("message", this.getBundle().getString("message"));
        return config;
    }
}

