/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.translate;

import javafx.scene.control.TreeItem;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.ValueTranslatorService;
import org.tentackle.fx.component.FxTreeTableView;
import org.tentackle.fx.component.FxTreeView;
import org.tentackle.fx.rdc.GuiProvider;
import org.tentackle.fx.rdc.Rdc;
import org.tentackle.fx.translate.TreeItemTranslator;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PersistentDomainObject;

@ValueTranslatorService(modelClass=PersistentDomainObject.class, viewClass=TreeItem.class)
public class PdoTreeItemTranslator<T extends PersistentDomainObject<T>>
extends TreeItemTranslator<T> {
    public PdoTreeItemTranslator(FxComponent component) {
        super(component);
    }

    protected void configureComponent() {
        FxComponent component = this.getComponent();
        Class elemClass = component.getType();
        if (elemClass != null && PersistentDomainObject.class.isAssignableFrom(elemClass)) {
            GuiProvider<PersistentDomainObject> provider = Rdc.createGuiProvider(Pdo.create((Class)elemClass));
            if (component instanceof FxTreeView) {
                FxTreeView treeView = (FxTreeView)component;
                treeView.setCellFactory(provider.getTreeCellFactory());
            } else if (component instanceof FxTreeTableView) {
                FxTreeTableView treeTableView = (FxTreeTableView)component;
                this.configureTreeTableView(treeTableView, provider.createTableConfiguration());
            }
        } else {
            super.configureComponent();
        }
    }
}

