/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.tentackle.common.Service;
import org.tentackle.fx.rdc.GuiProvider;
import org.tentackle.fx.rdc.GuiProviderFactory;
import org.tentackle.pdo.PdoRuntimeException;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.reflect.ClassMapper;

@Service(value=GuiProviderFactory.class)
public class DefaultGuiProviderFactory
implements GuiProviderFactory {
    private final ConcurrentHashMap<Class, Optional<Constructor>> serviceMap = new ConcurrentHashMap();
    private final ClassMapper guiClassMapper = ClassMapper.create((String)"FX GUI-provider", GuiProvider.class);

    @Override
    public <T extends PersistentDomainObject<T>> GuiProvider<T> createGuiProvider(T pdo) {
        Class pdoClass = pdo.getEffectiveClass();
        Optional constructor = this.serviceMap.computeIfAbsent(pdoClass, this::getConstructor);
        if (constructor.isPresent()) {
            try {
                return (GuiProvider)((Constructor)constructor.get()).newInstance(pdo);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                throw new PdoRuntimeException("cannot instantiate GUI service object for " + pdoClass.getName(), (Throwable)e);
            }
        }
        throw new PdoRuntimeException("no @GuiProviderService for " + pdoClass.getName());
    }

    @Override
    public <T extends PersistentDomainObject<T>> boolean isGuiProviderAvailable(Class<T> pdoClass) {
        return this.serviceMap.computeIfAbsent(pdoClass, this::getConstructor).isPresent();
    }

    protected <T extends PersistentDomainObject<T>> Optional<Constructor> getConstructor(Class<T> pdoClass) {
        try {
            Class serviceClass = this.guiClassMapper.mapLenient(pdoClass);
            for (Constructor<?> con : serviceClass.getConstructors()) {
                Class<?>[] params = con.getParameterTypes();
                if (params.length != 1 || !pdoClass.isAssignableFrom(params[0])) continue;
                return Optional.of(con);
            }
            throw new PdoRuntimeException("no matching constructor found for " + serviceClass.getName() + "(" + pdoClass.getName() + ")");
        }
        catch (ClassNotFoundException ex) {
            return Optional.empty();
        }
    }
}

