/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc;

import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.input.MouseEvent;
import org.tentackle.fx.rdc.PdoContextMenuFactory;
import org.tentackle.fx.table.FxTableCell;
import org.tentackle.fx.table.TableColumnConfiguration;
import org.tentackle.pdo.PersistentDomainObject;

public class PdoTableCell<S, T extends PersistentDomainObject<T>>
extends FxTableCell<S, T> {
    private ContextMenu contextMenu;

    public PdoTableCell(TableColumnConfiguration<S, T> columnConfiguration) {
        super(columnConfiguration);
        this.addEventHandler(MouseEvent.ANY, this::showContextMenu);
    }

    public void updateItem(T pdo, boolean empty) {
        super.updateItem(pdo, empty);
        if (empty || pdo == null) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            this.setText(pdo.toString());
        }
    }

    private void showContextMenu(MouseEvent event) {
        if (event.isPopupTrigger()) {
            if (this.contextMenu != null) {
                this.contextMenu.hide();
            }
            if (this.getTableView().getContextMenu() == null) {
                this.contextMenu = PdoContextMenuFactory.getInstance().create(this);
                if (this.contextMenu != null) {
                    event.consume();
                    this.contextMenu.setOnHidden(e -> {
                        this.contextMenu = null;
                    });
                    this.contextMenu.show((Node)this, event.getScreenX(), event.getScreenY());
                }
            }
        }
    }
}

