/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.login;

import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.stage.WindowEvent;
import org.tentackle.app.AbstractApplication;
import org.tentackle.fx.AbstractFxController;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.component.FxButton;
import org.tentackle.fx.component.FxComboBox;
import org.tentackle.fx.component.FxLabel;
import org.tentackle.fx.component.FxPasswordField;
import org.tentackle.fx.component.FxTextField;
import org.tentackle.fx.rdc.app.DesktopApplication;
import org.tentackle.fx.rdc.login.Backends;
import org.tentackle.log.Logger;
import org.tentackle.session.BackendConfiguration;
import org.tentackle.session.SessionInfo;

@FxControllerService(binding=FxControllerService.BINDING.NO)
public class Login
extends AbstractFxController {
    private static final Logger LOGGER = Logger.get(Login.class);
    private SessionInfo sessionInfo;
    private boolean autoLogin;
    private boolean backendFromSystemPrefs;
    private char[] password;
    private TimeoutThread timeoutThread;
    private boolean backendsEditable;
    private int inactivityTimeout;
    private long lastActivity;
    @FXML
    private ResourceBundle resources;
    @FXML
    private GridPane loginPane;
    @FXML
    private FxLabel backendLabel;
    @FXML
    private FxComboBox<BackendConfiguration> backendField;
    @FXML
    private FxButton backendButton;
    @FXML
    private FxTextField usernameField;
    @FXML
    private FxPasswordField passwordField;
    @FXML
    private Label messageLabel;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private FxButton loginButton;
    @FXML
    private FxButton cancelButton;

    @FXML
    private void initialize() {
        this.progressBar.setVisible(false);
        this.setCapsLockMessage(this.isCapsLock());
        this.cancelButton.setOnAction(e -> this.cancel());
        this.cancelButton.setGraphic((Node)Fx.createImageView((String)"close"));
        this.loginButton.setOnAction(e -> this.login());
        this.loginButton.setGraphic((Node)Fx.createImageView((String)"ok"));
        this.usernameField.setAutoSelect(true);
        this.passwordField.setOnAction(e -> this.login());
        this.passwordField.setAutoSelect(true);
        this.passwordField.addViewToModelListener(() -> {
            this.password = this.passwordField.getPassword();
        });
        this.passwordField.addModelToViewListener(() -> this.passwordField.setPassword(this.password));
        this.backendButton.setGraphic((Node)Fx.createImageView((String)"edit"));
        this.backendButton.setOnAction(e -> Backends.editBackends(this.sessionInfo.getApplicationName(), this.backendFromSystemPrefs, this::loadBackendConfigurations));
        this.backendField.setOnAction(event -> this.presetUserAndPassword((BackendConfiguration)this.backendField.getValue()));
    }

    public void presetUserAndPassword(BackendConfiguration backendConfiguration) {
        if (backendConfiguration != null && backendConfiguration.getUrl() != null && backendConfiguration.getUrl().startsWith("rmi:") && backendConfiguration.getUser() != null) {
            this.setUsername(backendConfiguration.getUser());
            if (backendConfiguration.getPassword() != null) {
                this.setPassword(backendConfiguration.getPassword().toCharArray());
            } else {
                this.setPassword(null);
            }
        }
    }

    public void setUsername(String username) {
        this.usernameField.setText(username);
    }

    public void setPassword(char[] password) {
        this.passwordField.setPassword(password);
    }

    public int getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public void setInactivityTimeout(int inactivityTimeout) {
        this.inactivityTimeout = inactivityTimeout;
    }

    public void configure() {
        this.getView().addEventFilter(KeyEvent.KEY_RELEASED, event -> {
            this.lastActivity = System.currentTimeMillis();
            if (event.getCode() == KeyCode.ESCAPE) {
                this.cancel();
            }
            if (event.getCode() == KeyCode.CAPS) {
                Platform.runLater(() -> this.setCapsLockMessage(this.isCapsLock()));
            }
        });
        this.getView().sceneProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                newValue.windowProperty().addListener((observable1, oldValue1, newValue1) -> {
                    if (newValue1 != null) {
                        newValue1.addEventHandler(WindowEvent.WINDOW_SHOWN, event -> {
                            if (this.timeoutThread == null) {
                                this.timeoutThread = new TimeoutThread();
                                this.timeoutThread.start();
                            }
                        });
                        newValue1.addEventHandler(WindowEvent.WINDOW_HIDDEN, event -> {
                            if (this.timeoutThread != null) {
                                this.timeoutThread.interrupt();
                            }
                        });
                    }
                });
            }
        });
    }

    public void requestInitialFocus() {
        Platform.runLater(() -> ((FxTextField)this.usernameField).requestFocus());
    }

    public void setSessionInfo(SessionInfo sessionInfo) {
        int ndx;
        this.sessionInfo = sessionInfo;
        this.usernameField.setText(sessionInfo.getUserName());
        this.passwordField.setPassword(sessionInfo.getPassword());
        String backendInfo = sessionInfo.getProperties().getProperty("backend");
        this.backendsEditable = false;
        if ("@user".equals(backendInfo)) {
            this.backendsEditable = true;
            this.backendFromSystemPrefs = false;
        } else if ("@system".equals(backendInfo)) {
            this.backendsEditable = true;
            this.backendFromSystemPrefs = true;
        }
        this.backendLabel.setVisible(this.backendsEditable);
        this.backendLabel.setManaged(this.backendsEditable);
        this.backendField.setVisible(this.backendsEditable);
        this.backendField.setManaged(this.backendsEditable);
        this.backendButton.setVisible(this.backendsEditable);
        this.backendButton.setManaged(this.backendsEditable);
        if (this.backendsEditable) {
            this.loadBackendConfigurations();
        } else if (backendInfo != null && (ndx = backendInfo.indexOf(58)) >= 0) {
            String configName = backendInfo.substring(ndx + 1);
            boolean systemPrefs = backendInfo.substring(0, ndx).equals("@system");
            BackendConfiguration backendConfiguration = (BackendConfiguration)BackendConfiguration.getBackendConfigurations((String)sessionInfo.getApplicationName(), (boolean)systemPrefs).get(configName);
            if (backendConfiguration != null) {
                if (backendConfiguration.getUrl().startsWith("rmi:") && backendConfiguration.getUser() != null) {
                    this.usernameField.setText(backendConfiguration.getUser());
                    if (backendConfiguration.getPassword() != null) {
                        this.passwordField.setPassword(backendConfiguration.getPassword().toCharArray());
                    } else {
                        this.passwordField.setPassword(null);
                    }
                }
            } else {
                LOGGER.warning("no such backend configuration: " + configName);
            }
        }
    }

    public SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    public void autoLogin() {
        this.autoLogin = true;
        Platform.runLater(() -> {
            this.usernameField.setEditable(false);
            this.passwordField.setEditable(false);
            this.login();
        });
    }

    public void setProgress(double progress) {
        if (progress <= 0.0 && !this.autoLogin) {
            this.progressBar.setProgress(0.0);
            this.loginButton.setDisable(false);
            this.cancelButton.setDisable(false);
            this.usernameField.setChangeable(true);
            this.passwordField.setChangeable(true);
        } else {
            this.progressBar.setProgress(progress);
            this.loginButton.setDisable(true);
            this.cancelButton.setDisable(true);
            this.usernameField.setChangeable(false);
            this.passwordField.setChangeable(false);
        }
        this.loginPane.setVisible(this.determineLoginPaneVisibility(progress));
        this.progressBar.setVisible(this.determineProgressBarVisibility(progress));
    }

    protected boolean determineLoginPaneVisibility(double progress) {
        return progress < 1.0;
    }

    protected boolean determineProgressBarVisibility(double progress) {
        return progress > 0.0 && progress < 1.0;
    }

    public void setMessage(String message) {
        this.messageLabel.setText(message);
    }

    private boolean isLoginInProgress() {
        return this.progressBar.getProgress() > 0.0;
    }

    private void login() {
        if (this.progressBar.getProgress() <= 0.0) {
            this.sessionInfo.setUserName(this.usernameField.getText());
            this.sessionInfo.setPassword(this.password);
            BackendConfiguration backendConfiguration = (BackendConfiguration)this.backendField.getValue();
            if (backendConfiguration != null) {
                String backendInfo = this.sessionInfo.getProperties().getProperty("backend") + ":" + backendConfiguration;
                this.sessionInfo.getProperties().setProperty("backend", backendInfo);
            }
            this.setProgress(0.01);
            ((DesktopApplication)AbstractApplication.getRunningApplication()).login(this.getView(), this.sessionInfo);
        } else {
            LOGGER.warning("login already in progress...");
        }
    }

    private void cancel() {
        Fx.getStage((Node)this.getView()).hide();
    }

    private void setCapsLockMessage(boolean capsLock) {
        if (capsLock) {
            this.setMessage(this.resources.getString("CAPS LOCK!"));
        } else {
            this.setMessage(null);
        }
    }

    private boolean isCapsLock() {
        return Platform.isFxApplicationThread() && Platform.isKeyLocked((KeyCode)KeyCode.CAPS).orElse(false) != false;
    }

    private void loadBackendConfigurations() {
        this.backendField.getItems().setAll(BackendConfiguration.getBackendConfigurations((String)this.sessionInfo.getApplicationName(), (boolean)this.backendFromSystemPrefs).values());
        BackendConfiguration defaultBackend = BackendConfiguration.getDefault((String)this.sessionInfo.getApplicationName(), (boolean)this.backendFromSystemPrefs);
        if (defaultBackend != null) {
            this.backendField.setValue((Object)defaultBackend);
            Platform.runLater(() -> this.backendField.fireEvent((Event)new ActionEvent()));
        }
    }

    private class TimeoutThread
    extends Thread {
        public TimeoutThread() {
            super("login timeout");
        }

        @Override
        public void run() {
            LOGGER.fine("{0} started", new Object[]{this});
            Login.this.lastActivity = System.currentTimeMillis();
            while (!TimeoutThread.interrupted()) {
                try {
                    TimeoutThread.sleep(1000L);
                    Platform.runLater(() -> {
                        long now = System.currentTimeMillis();
                        long inactiveSeconds = (now - Login.this.lastActivity) / 1000L;
                        if (Login.this.autoLogin || Login.this.backendsEditable || Login.this.isLoginInProgress()) {
                            Login.this.lastActivity = now;
                        } else if (Login.this.inactivityTimeout > 0 && inactiveSeconds > (long)Login.this.inactivityTimeout) {
                            LOGGER.info("login timed out after {0} seconds -> closed", new Object[]{inactiveSeconds});
                            Login.this.cancel();
                        }
                    });
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            LOGGER.fine("{0} terminated", new Object[]{this});
        }
    }
}

