/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.security;

import java.util.function.Consumer;
import javafx.stage.Window;
import org.tentackle.common.Service;
import org.tentackle.fx.rdc.RdcRuntimeException;
import org.tentackle.fx.rdc.security.SecurityDialogFactory;
import org.tentackle.fx.rdc.security.SecurityRulesView;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.session.SessionUtilities;

@Service(value=SecurityDialogFactory.class)
public class DefaultSecurityDialogFactory
implements SecurityDialogFactory {
    @Override
    public void selectGrantee(Window owner, DomainContext context, Consumer<PersistentDomainObject<?>> grantee) {
        throw new RdcRuntimeException("grantee selection not implemented for this application");
    }

    @Override
    public boolean isDomainContextUsed() {
        return false;
    }

    @Override
    public void selectDomainContextObject(Window owner, DomainContext context, Consumer<PersistentDomainObject<?>> contextPdo) {
        throw new RdcRuntimeException("context selection not implemented for this application");
    }

    @Override
    public void showDialog(PersistentDomainObject<?> pdo) {
        SecurityRulesView.show(null, pdo);
    }

    @Override
    public void showDialog(int classId, DomainContext context) {
        try {
            Class<?> cls = Class.forName(SessionUtilities.getInstance().getClassName(classId));
            SecurityRulesView.show(null, Pdo.create(cls, (DomainContext)context));
        }
        catch (ClassNotFoundException ex) {
            throw new RdcRuntimeException("cannot create security dialog for classId=" + classId, ex);
        }
    }

    @Override
    public void showDialog(Class<?> clazz) {
        SecurityRulesView.show(clazz, null);
    }
}

