/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;

public class EventListenerProxy<T extends Event> {
    private final Node node;
    private Map<EventType<T>, List<EventHandler<T>>> filters;
    private Map<EventType<T>, List<EventHandler<T>>> handlers;

    public EventListenerProxy(Node node) {
        this.node = node;
    }

    public void fireEvent(T event) {
        this.node.fireEvent(event);
    }

    public void addEventFilter(EventType<T> eventType, EventHandler<T> filter) {
        this.node.addEventFilter(eventType, filter);
        if (this.filters == null) {
            this.filters = new HashMap<EventType<T>, List<EventHandler<T>>>();
        }
        this.addListener(this.filters, eventType, filter);
    }

    public void removeEventFilter(EventType<T> eventType, EventHandler<T> filter) {
        this.node.removeEventFilter(eventType, filter);
        if (this.filters != null) {
            this.removeListener(this.filters, eventType, filter);
        }
    }

    public void addEventHandler(EventType<T> eventType, EventHandler<T> handler) {
        this.node.addEventHandler(eventType, handler);
        if (this.handlers == null) {
            this.handlers = new HashMap<EventType<T>, List<EventHandler<T>>>();
        }
        this.addListener(this.handlers, eventType, handler);
    }

    public void removeEventHandler(EventType<T> eventType, EventHandler<T> handler) {
        this.node.removeEventHandler(eventType, handler);
        if (this.handlers != null) {
            this.removeListener(this.handlers, eventType, handler);
        }
    }

    public void removeAllEventFilters() {
        if (this.filters != null) {
            for (Map.Entry<EventType<T>, List<EventHandler<T>>> entry : this.filters.entrySet()) {
                EventType<T> evenType = entry.getKey();
                for (EventHandler<T> listener : entry.getValue()) {
                    this.node.removeEventFilter(evenType, listener);
                }
            }
            this.filters.clear();
        }
    }

    public void removeAllEventHandlers() {
        if (this.handlers != null) {
            for (Map.Entry<EventType<T>, List<EventHandler<T>>> entry : this.handlers.entrySet()) {
                EventType<T> evenType = entry.getKey();
                for (EventHandler<T> listener : entry.getValue()) {
                    this.node.removeEventHandler(evenType, listener);
                }
            }
            this.handlers.clear();
        }
    }

    private void addListener(Map<EventType<T>, List<EventHandler<T>>> map, EventType<T> eventType, EventHandler<T> handler) {
        List list = map.computeIfAbsent(eventType, k -> new ArrayList());
        list.add(handler);
    }

    private void removeListener(Map<EventType<T>, List<EventHandler<T>>> map, EventType<T> eventType, EventHandler<T> handler) {
        List<EventHandler<T>> list = map.get(eventType);
        if (list != null) {
            list.remove(handler);
        }
    }
}

