/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.table;

import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import org.tentackle.fx.rdc.PdoTableCell;
import org.tentackle.fx.rdc.PdoTreeTableCell;
import org.tentackle.fx.rdc.table.RdcTableConfiguration;
import org.tentackle.fx.table.DefaultTableColumnConfiguration;
import org.tentackle.pdo.PersistentDomainObject;

public class RdcTableColumnConfiguration<S, T>
extends DefaultTableColumnConfiguration<S, T> {
    private boolean pdoTypeConfigured;

    public RdcTableColumnConfiguration(RdcTableConfiguration<S> tableConfiguration, String name, String displayedName) {
        super(tableConfiguration, name, displayedName);
    }

    public void setType(Class<T> type) {
        super.setType(type);
        this.pdoTypeConfigured = type != null && PersistentDomainObject.class.isAssignableFrom(type);
    }

    public boolean isPdoTypeConfigured() {
        return this.pdoTypeConfigured;
    }

    protected TableCell<S, T> createTableCell(TableColumn<S, T> column) {
        return this.pdoTypeConfigured ? new PdoTableCell(this) : super.createTableCell(column);
    }

    protected TreeTableCell<S, T> createTreeTableCell(TreeTableColumn<S, T> column) {
        return this.pdoTypeConfigured ? new PdoTreeTableCell(this) : super.createTreeTableCell(column);
    }
}

