/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.translate;

import java.lang.reflect.Type;
import java.util.Collection;
import javafx.scene.control.TreeItem;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.ValueTranslatorService;
import org.tentackle.fx.component.FxTreeTableView;
import org.tentackle.fx.component.FxTreeView;
import org.tentackle.fx.rdc.GuiProvider;
import org.tentackle.fx.rdc.Rdc;
import org.tentackle.fx.translate.CollectionTreeItemTranslator;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.reflect.ReflectionHelper;

@ValueTranslatorService(modelClass=Collection.class, viewClass=TreeItem.class)
public class PdoCollectionTreeItemTranslator<T extends PersistentDomainObject<T>, C extends Collection<T>>
extends CollectionTreeItemTranslator<T, C> {
    private boolean guiProviderExists;

    public PdoCollectionTreeItemTranslator(FxComponent component) {
        super(component);
    }

    protected void configureComponent() {
        FxComponent component = this.getComponent();
        Class elemClass = ReflectionHelper.extractGenericInnerTypeClass((Type)component.getGenericType());
        if (elemClass != null && PersistentDomainObject.class.isAssignableFrom(elemClass)) {
            GuiProvider<PersistentDomainObject> provider = Rdc.createGuiProvider(Pdo.create((Class)elemClass));
            this.guiProviderExists = true;
            if (component instanceof FxTreeView) {
                FxTreeView treeView = (FxTreeView)component;
                treeView.setShowRoot(false);
                treeView.setCellFactory(provider.getTreeCellFactory());
            } else if (component instanceof FxTreeTableView) {
                FxTreeTableView treeTableView = (FxTreeTableView)component;
                treeTableView.setShowRoot(false);
                this.configureTreeTableView(treeTableView, provider.createTableConfiguration());
            }
        } else {
            super.configureComponent();
        }
    }

    protected TreeItem<T> createTreeItem(Object object) {
        return this.guiProviderExists ? Rdc.createGuiProvider((PersistentDomainObject)object).createTreeItem() : super.createTreeItem(object);
    }
}

