/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.app;

import java.util.Properties;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import org.tentackle.app.AbstractApplication;
import org.tentackle.app.DesktopApplication;
import org.tentackle.app.FxApplication;
import org.tentackle.fx.Fx;
import org.tentackle.fx.rdc.login.Login;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.ApplicationException;
import org.tentackle.misc.StringHelper;
import org.tentackle.pdo.SessionInfo;
import org.tentackle.reflect.ReflectionHelper;

public class LoginApplication
extends FxApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginApplication.class);
    private Login controller;

    @Override
    public void startApplication(Stage stage) throws Exception {
        this.controller = (Login)Fx.load(Login.class);
        this.controller.setSessionInfo(this.createSessionInfo());
        Scene scene = new Scene(this.controller.getView());
        stage.setScene(scene);
        stage.initStyle(StageStyle.TRANSPARENT);
        stage.show();
    }

    @Override
    public void showApplicationStatus(String msg, double progress) {
        if (this.controller.getView().isVisible()) {
            this.controller.setMessage(msg);
            this.controller.setProgress(progress);
        } else {
            LOGGER.info(msg, new Object[0]);
        }
    }

    public SessionInfo createSessionInfo() throws ApplicationException {
        DesktopApplication application = (DesktopApplication)AbstractApplication.getRunningApplication();
        String username = application.getCommandLine().getOptionValue("user");
        char[] password = StringHelper.toCharArray((String)application.getCommandLine().getOptionValue("password"));
        String sessionPropsName = application.getCommandLine().getOptionValue("backend");
        SessionInfo sessionInfo = application.createSessionInfo(username, password, sessionPropsName);
        Properties props = sessionInfo.getProperties();
        if (username == null) {
            sessionInfo.setUserName(props.getProperty("user", sessionInfo.getUserName()));
        }
        if (password == null) {
            sessionInfo.setPassword(StringHelper.toCharArray((String)props.getProperty("password", sessionInfo.getPasswordAsString())));
        }
        if (sessionInfo.getApplicationName() == null) {
            sessionInfo.setApplicationName(ReflectionHelper.getClassBaseName(((Object)((Object)application)).getClass()));
        }
        return sessionInfo;
    }
}

