/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javafx.scene.Node;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.image.ImageView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxFactory;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.rdc.GuiProvider;
import org.tentackle.fx.rdc.PdoEditor;
import org.tentackle.fx.rdc.PdoFinder;
import org.tentackle.fx.rdc.PdoTreeItem;
import org.tentackle.fx.rdc.Rdc;
import org.tentackle.fx.table.TableConfiguration;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.IdentifiableKey;
import org.tentackle.misc.ShortLongText;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoUtilities;
import org.tentackle.pdo.PersistentDomainObject;

public class DefaultGuiProvider<T extends PersistentDomainObject<T>>
implements GuiProvider<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultGuiProvider.class);
    private T pdo;
    private ResourceBundle bundle;

    public DefaultGuiProvider(T pdo) {
        this.setPdo(pdo);
    }

    @Override
    public ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle(this.getClass().getName());
        }
        return this.bundle;
    }

    public T getPdo() {
        return this.pdo;
    }

    public void setPdo(T pdo) {
        if (pdo == null) {
            throw new NullPointerException("pdo must not be null");
        }
        this.pdo = pdo;
    }

    public DomainContext getDomainContext() {
        return this.pdo.getDomainContext();
    }

    @Override
    public ImageView createIcon() {
        return Fx.createImageView((String)"unknown");
    }

    @Override
    public boolean editorExists() {
        return false;
    }

    @Override
    public <C extends PdoEditor<T>> C createEditor() {
        throw new FxRuntimeException("no controller for " + this.pdo.toGenericString());
    }

    @Override
    public boolean finderExists() {
        return false;
    }

    @Override
    public <C extends PdoFinder<T>> C createFinder() {
        throw new FxRuntimeException("no finder for " + this.pdo.getEffectiveClass().getName());
    }

    @Override
    public Dragboard createDragboard(Node node) {
        if (this.pdo.getClassId() != 0 && !this.pdo.isNew()) {
            Dragboard db = node.startDragAndDrop(new TransferMode[]{TransferMode.COPY});
            ClipboardContent content = new ClipboardContent();
            content.putString(this.pdo.toIdString());
            db.setContent((Map)content);
            return db;
        }
        return null;
    }

    @Override
    public boolean isDragAccepted(DragEvent event) {
        return false;
    }

    public IdentifiableKey<PersistentDomainObject<?>> getPdoKeyFromDragboard(Dragboard dragboard) {
        StringTokenizer stok;
        String str = dragboard.getString();
        if (str != null && (stok = new StringTokenizer(str, ":")).hasMoreTokens()) {
            int classId = Integer.parseInt(stok.nextToken());
            if (stok.hasMoreTokens()) {
                int id = Integer.parseInt(stok.nextToken());
                String className = PdoUtilities.getInstance().getPdoClassName(classId);
                if (className != null && id != 0) {
                    try {
                        return new IdentifiableKey(className, (long)id);
                    }
                    catch (ClassNotFoundException cx) {
                        LOGGER.severe("cannot load PDO class " + className + " for classId " + classId, (Throwable)cx);
                    }
                } else {
                    LOGGER.warning("no PDO key for {0}:{1}", new Object[]{classId, id});
                }
            }
        }
        return null;
    }

    @Override
    public void dropDragboard(Dragboard dragbord) {
        PersistentDomainObject pdoToDrop;
        IdentifiableKey<PersistentDomainObject<?>> key = this.getPdoKeyFromDragboard(dragbord);
        if (key != null && (pdoToDrop = Pdo.create((Class)key.getIdentifiableClass(), (DomainContext)this.pdo.getDomainContext()).select(key.getIdentifiableId())) != null) {
            this.dropPdo(pdoToDrop);
        }
    }

    public void dropPdo(PersistentDomainObject<?> pdoToDrop) {
        throw new FxRuntimeException("dropPdo is not implemented " + this.pdo.getEffectiveClass().getName());
    }

    @Override
    public TableConfiguration<T> createTableConfiguration() {
        TableConfiguration config = FxFactory.getInstance().createTableConfiguration(this.getPdo(), null);
        config.addColumn("id", "ID");
        config.addColumn("serial", "Serial");
        return config;
    }

    @Override
    public TableView<T> createTableView() {
        TableConfiguration<T> config = this.createTableConfiguration();
        if (config.getBindingType() == TableConfiguration.BINDING.YES) {
            config.getBinder().bind();
        } else if (config.getBindingType() == TableConfiguration.BINDING.INHERITED) {
            config.getBinder().bindAllInherited();
        }
        TableView tableView = (TableView)Fx.createNode(TableView.class);
        config.configure(tableView);
        return tableView;
    }

    public String toString() {
        return this.getClass().getName() + " for " + this.getPdo().toGenericString();
    }

    @Override
    public boolean providesTreeChildObjects() {
        return false;
    }

    @Override
    public <S extends PersistentDomainObject<S>> Collection<S> getTreeChildObjects() {
        return new ArrayList();
    }

    @Override
    public <S extends PersistentDomainObject<S>> Collection<S> getTreeChildObjects(Object parentObject) {
        return this.getTreeChildObjects();
    }

    @Override
    public int getTreeExpandMaxDepth() {
        return 0;
    }

    @Override
    public boolean providesTreeParentObjects() {
        return false;
    }

    @Override
    public <S extends PersistentDomainObject<S>> Collection<S> getTreeParentObjects() {
        return new ArrayList();
    }

    @Override
    public <S extends PersistentDomainObject<S>> Collection<S> getTreeParentObjects(Object parentObject) {
        return this.getTreeParentObjects();
    }

    @Override
    public T getTreeRoot() {
        return this.getPdo();
    }

    @Override
    public String getTreeText() {
        if (this.getPdo() instanceof ShortLongText) {
            return ((ShortLongText)this.getPdo()).getShortText() + " : " + ((ShortLongText)this.getPdo()).getLongText();
        }
        return this.getPdo().toString();
    }

    @Override
    public String getTreeText(Object parent) {
        return this.getTreeText();
    }

    @Override
    public String getToolTipText() {
        return this.getTreeText();
    }

    @Override
    public String getToolTipText(Object parent) {
        return this.getToolTipText();
    }

    @Override
    public boolean stopTreeExpansion() {
        return false;
    }

    @Override
    public TreeItem<T> createTreeItem() {
        return new PdoTreeItem<T>(this.pdo);
    }

    @Override
    public TreeCell<T> createTreeCell() {
        return Rdc.createTreeCell();
    }
}

