/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.tentackle.common.Service;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxFxBundle;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.rdc.RdcFactory;
import org.tentackle.fx.rdc.RdcFxRdcBundle;
import org.tentackle.fx.rdc.RdcUtilities$Singleton;
import org.tentackle.fx.rdc.crud.PdoCrud;
import org.tentackle.fx.rdc.search.PdoSearch;
import org.tentackle.pdo.PersistentDomainObject;

@Service(value=RdcUtilities.class)
public class RdcUtilities {
    private final Map<Class<?>, Set<PdoCrud<?>>> crudCache = new HashMap();
    private final Map<Class<?>, Set<PdoSearch<?>>> searchCache = new HashMap();

    public static RdcUtilities getInstance() {
        return RdcUtilities$Singleton.INSTANCE;
    }

    public <T extends PersistentDomainObject<T>> T displayCrudStage(T pdo, boolean editable, Modality modality, Window owner) {
        return this.displayCrudStage(pdo, null, editable, modality, owner, null);
    }

    public <T extends PersistentDomainObject<T>> T displayCrudStage(T pdo, List<T> pdoList, boolean editable, Modality modality, Window owner, Consumer<PdoCrud<T>> configurator) {
        PdoCrud crud = this.getCrud(pdo, pdoList, editable, modality, owner);
        if (crud != null) {
            Stage stage = crud.getStage();
            if (stage == null && Fx.getStage((Node)crud.getView()) == null) {
                stage = Fx.createStage((Modality)modality);
                if (owner != null) {
                    stage.initOwner(owner);
                }
                Scene scene = new Scene(crud.getView());
                stage.setScene(scene);
                crud.updateTitle();
                stage.addEventFilter(WindowEvent.WINDOW_SHOWN, e -> Platform.runLater(() -> crud.getEditor().requestInitialFocus()));
                stage.addEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, e -> {
                    if (!crud.releasePdo()) {
                        e.consume();
                    }
                });
                stage.addEventFilter(WindowEvent.WINDOW_HIDDEN, e -> {
                    crud.setPdoList(null);
                    crud.removeAllPdoEventListeners();
                });
            }
            if (configurator != null) {
                configurator.accept(crud);
            }
            if (stage == null) {
                throw new FxRuntimeException("misconfigured crud stage");
            }
            if (modality != Modality.NONE) {
                stage.showAndWait();
                pdo = crud.getPdo();
            } else {
                stage.show();
            }
        }
        return pdo;
    }

    public synchronized <T extends PersistentDomainObject<T>> PdoCrud<T> getCrud(T pdo, List<T> pdoList, boolean editable, Modality modality, Window owner) {
        Class pdoClass = pdo.getEffectiveClass();
        Set<PdoCrud<?>> cruds = this.crudCache.get(pdoClass);
        if (cruds == null) {
            cruds = new HashSet();
            this.crudCache.put(pdoClass, cruds);
        }
        Iterator<PdoCrud<?>> iter = cruds.iterator();
        while (iter.hasNext()) {
            PdoCrud<?> crud = iter.next();
            Stage stage = Fx.getStage((Node)crud.getView());
            if (stage == null || !stage.isShowing() && stage.getModality() == modality && stage.getOwner() == owner) {
                crud.setEditable(editable);
                crud.setPdo(pdo);
                crud.setPdoList(pdoList);
                return crud;
            }
            if (Objects.equals(pdo, crud.getPdo()) && stage.isShowing() && editable && crud.isEditable()) {
                stage.toFront();
                return null;
            }
            if (stage.isShowing() || stage.getModality() != modality || stage.getOwner() == owner || stage.getOwner() == null || stage.getOwner().isShowing()) continue;
            iter.remove();
        }
        PdoCrud<T> crud = RdcFactory.getInstance().createPdoCrud(pdo, editable);
        crud.setPdoList(pdoList);
        cruds.add(crud);
        return crud;
    }

    public <T extends PersistentDomainObject<T>> ObservableList<T> displaySearchStage(T pdo, Modality modality, Window owner, boolean createPdoAllowed) {
        return this.displaySearchStage(pdo, modality, owner, createPdoAllowed, null);
    }

    public <T extends PersistentDomainObject<T>> ObservableList<T> displaySearchStage(T pdo, Modality modality, Window owner, boolean createPdoAllowed, Consumer<PdoSearch<T>> configurator) {
        PdoSearch search = this.getSearch(pdo, modality, owner);
        search.setCreatePdoAllowed(createPdoAllowed);
        Stage stage = search.getStage();
        if (stage == null && Fx.getStage((Node)search.getView()) == null) {
            stage = Fx.createStage((Modality)modality);
            if (owner != null) {
                stage.initOwner(owner);
            }
            Scene scene = new Scene(search.getView());
            stage.setScene(scene);
            search.updateTitle();
            search.setSingleSelectMode(Fx.isModal((Stage)stage));
            stage.addEventFilter(WindowEvent.WINDOW_SHOWN, e -> Platform.runLater(() -> search.getFinder().requestInitialFocus()));
            stage.addEventFilter(WindowEvent.WINDOW_HIDDEN, e -> Platform.runLater(() -> search.setItems(null)));
        }
        if (configurator != null) {
            configurator.accept(search);
        }
        if (stage == null) {
            throw new FxRuntimeException("misconfigured search stage");
        }
        if (modality != Modality.NONE) {
            stage.showAndWait();
            return search.getSelectedItems();
        }
        stage.show();
        return null;
    }

    public synchronized <T extends PersistentDomainObject<T>> PdoSearch<T> getSearch(T pdo, Modality modality, Window owner) {
        Class pdoClass = pdo.getEffectiveClass();
        Set<PdoSearch<?>> searches = this.searchCache.get(pdoClass);
        if (searches == null) {
            searches = new HashSet();
            this.searchCache.put(pdoClass, searches);
        }
        Iterator<PdoSearch<?>> iter = searches.iterator();
        while (iter.hasNext()) {
            PdoSearch<?> search = iter.next();
            Stage stage = Fx.getStage((Node)search.getView());
            if (stage == null || !stage.isShowing() && stage.getModality() == modality && stage.getOwner() == owner) {
                search.setPdo(pdo);
                search.setItems(null);
                search.showTable();
                return search;
            }
            if (stage.isShowing() || stage.getModality() != modality || stage.getOwner() == owner || stage.getOwner() == null || stage.getOwner().isShowing()) continue;
            iter.remove();
        }
        PdoSearch<T> search = RdcFactory.getInstance().createPdoSearch(pdo);
        searches.add(search);
        return search;
    }

    public Boolean showSaveDiscardCancelDialog() {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle(FxFxBundle.getString((String)"QUESTION"));
        alert.setHeaderText(null);
        alert.setContentText(RdcFxRdcBundle.getString("DATA_HAS_BEEN_MODIFIED!_DISCARD,_SAVE_OR_CANCEL?"));
        ButtonType saveButtonType = new ButtonType(RdcFxRdcBundle.getString("SAVE"));
        ButtonType discardButtonType = new ButtonType(RdcFxRdcBundle.getString("DISCARD"));
        ButtonType cancelButtonType = new ButtonType(RdcFxRdcBundle.getString("CANCEL"), ButtonBar.ButtonData.CANCEL_CLOSE);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{saveButtonType, discardButtonType, cancelButtonType});
        Button cancelButton = (Button)alert.getDialogPane().lookupButton(cancelButtonType);
        cancelButton.setDefaultButton(true);
        Optional result = alert.showAndWait();
        if (result.get() == saveButtonType) {
            return Boolean.TRUE;
        }
        if (result.get() == discardButtonType) {
            return Boolean.FALSE;
        }
        return null;
    }
}

