/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.search;

import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.tentackle.fx.AbstractFxController;
import org.tentackle.fx.CaseConversion;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.component.FxButton;
import org.tentackle.fx.component.FxLabel;
import org.tentackle.fx.component.FxTextField;
import org.tentackle.fx.container.FxBorderPane;
import org.tentackle.fx.container.FxHBox;
import org.tentackle.fx.rdc.GuiProviderFactory;
import org.tentackle.fx.rdc.PdoEvent;
import org.tentackle.fx.rdc.PdoFinder;
import org.tentackle.fx.rdc.Rdc;
import org.tentackle.fx.rdc.RdcRuntimeException;
import org.tentackle.fx.table.TablePopup;
import org.tentackle.misc.StringHelper;
import org.tentackle.pdo.PdoHolder;
import org.tentackle.pdo.PdoTracker;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.prefs.PersistedPreferencesFactory;
import org.tentackle.task.AbstractTask;
import org.tentackle.task.Task;

@FxControllerService(binding=FxControllerService.BINDING.NO)
public class PdoSearch<T extends PersistentDomainObject<T>>
extends AbstractFxController
implements PdoHolder<T> {
    @FXML
    private FxBorderPane borderPane;
    @FXML
    private FxHBox buttonBox;
    @FXML
    private FxButton findButton;
    @FXML
    private FxButton okButton;
    @FXML
    private FxButton newButton;
    @FXML
    private FxButton cancelButton;
    @FXML
    private FxButton filterButton;
    @FXML
    private FxTextField filterField;
    @FXML
    private FxButton treeButton;
    @FXML
    private FxLabel countLabel;
    private ObservableList<T> items = FXCollections.observableArrayList();
    private ResourceBundle resources;
    private PdoFinder<T> finder;
    private TableView<T> tableView;
    private TreeView<T> treeView;
    private boolean treeShown;
    private boolean tableViewInvalid;
    private boolean treeViewInvalid;
    private boolean singleSelectMode;
    private BooleanProperty wrongTypeSelected;
    private T createdPdo;

    public FxHBox getButtonBox() {
        return this.buttonBox;
    }

    public void setFinder(PdoFinder<T> finder) {
        if (this.finder != null) {
            throw new RdcRuntimeException("finder already set");
        }
        this.finder = finder;
        Parent finderView = finder.getView();
        this.borderPane.setTop((Node)finderView);
        BorderPane.setMargin((Node)finderView, (Insets)new Insets(5.0));
    }

    public PdoFinder<T> getFinder() {
        return this.finder;
    }

    public void setPdo(T pdo) {
        ObjectProperty<EventHandler<ActionEvent>> searchActionProperty;
        if (pdo == null) {
            throw new NullPointerException("pdo must not be null");
        }
        this.createdPdo = null;
        this.finder.setPdo((PersistentDomainObject)pdo);
        this.finder.getContainer().updateView();
        this.setFinderVisible(this.finder.isVisible());
        this.tableView = GuiProviderFactory.getInstance().createGuiProvider(pdo).createTableView();
        this.tableView.setOnMousePressed(event -> {
            PersistentDomainObject firstPdo;
            if (event.isPrimaryButtonDown() && event.getClickCount() == 2 && (firstPdo = (PersistentDomainObject)this.tableView.getSelectionModel().getSelectedItem()) != null) {
                if (Fx.isModal((Stage)this.getStage())) {
                    this.close();
                } else if (GuiProviderFactory.getInstance().createGuiProvider(firstPdo).editorExists()) {
                    Rdc.displayCrudStage(firstPdo.reload(), this.tableView.getItems(), true, Modality.NONE, (Window)this.getStage(), crud -> crud.addPdoEventFilter(PdoEvent.ANY, (EventHandler<PdoEvent>)((EventHandler)e -> {
                        if (e.getEventType() == PdoEvent.UPDATE) {
                            int ndx;
                            PersistentDomainObject updatedPdo = firstPdo.reload();
                            if (!this.treeViewInvalid) {
                                ObservableList treeItems = this.treeView.getRoot().getChildren();
                                int i = 0;
                                for (TreeItem item : treeItems) {
                                    if (updatedPdo.equals(item.getValue())) {
                                        TreeItem<PersistentDomainObject> updatedItem = GuiProviderFactory.getInstance().createGuiProvider(updatedPdo).createTreeItem();
                                        treeItems.set(i, updatedItem);
                                        this.getTreeView().refresh();
                                        updatedItem.setExpanded(item.isExpanded());
                                        break;
                                    }
                                    ++i;
                                }
                            }
                            if ((ndx = this.items.indexOf((Object)firstPdo)) >= 0) {
                                this.items.set(ndx, (Object)updatedPdo);
                            }
                        } else if (e.getEventType() == PdoEvent.READ) {
                            int ndx = this.tableView.getSelectionModel().getSelectedIndex();
                            ndx = ndx > 0 && e.getPdo().equals(this.tableView.getItems().get(ndx - 1)) ? --ndx : (ndx < this.tableView.getItems().size() - 1 && e.getPdo().equals(this.tableView.getItems().get(ndx + 1)) ? ++ndx : this.tableView.getItems().indexOf(e.getPdo()));
                            if (ndx >= 0) {
                                this.tableView.getSelectionModel().clearSelection();
                                this.tableView.getSelectionModel().select(ndx);
                                this.tableView.scrollTo(ndx);
                            }
                        }
                        e.consume();
                    })));
                }
            }
        });
        TablePopup tablePopup = new TablePopup(this.tableView, null, false);
        tablePopup.loadPreferences(PersistedPreferencesFactory.getInstance().isSystemOnly());
        this.treeView = (TreeView)Fx.createNode(TreeView.class);
        this.treeView.setCellFactory(p -> Rdc.createTreeCell());
        this.wrongTypeSelected = new SimpleBooleanProperty();
        this.treeView.getSelectionModel().selectedItemProperty().addListener((obs, ov, nv) -> this.wrongTypeSelected.set(nv == null || nv.getValue() == null || !pdo.getClass().isAssignableFrom(((PersistentDomainObject)nv.getValue()).getClass())));
        StackPane stackPane = (StackPane)Fx.createNode(StackPane.class);
        if (this.treeShown) {
            stackPane.getChildren().addAll((Object[])new Node[]{this.tableView, this.treeView});
        } else {
            stackPane.getChildren().addAll((Object[])new Node[]{this.treeView, this.tableView});
        }
        this.treeViewInvalid = true;
        this.tableViewInvalid = true;
        this.borderPane.setCenter((Node)stackPane);
        this.filterField.setVisible(false);
        this.filterField.setCaseConversion(CaseConversion.UPPER_CASE);
        this.filterButton.setVisible(false);
        this.updateTitle();
        this.bindOkButton();
        if (this.finder.isSearchRunningImmediately()) {
            this.find();
        }
        if ((searchActionProperty = this.finder.getSearchActionProperty()) != null) {
            searchActionProperty.set(e -> this.findButton.doClick());
        }
    }

    public T getPdo() {
        return (T)this.getFinder().getPdo();
    }

    public void setFinderVisible(boolean visible) {
        Parent view = this.finder.getView();
        view.setVisible(visible);
        view.setManaged(visible);
    }

    public boolean isFinderVisible() {
        return this.finder.getView().isVisible();
    }

    public void setSingleSelectMode(boolean singleSelectMode) {
        this.singleSelectMode = singleSelectMode;
        SelectionMode selectionMode = singleSelectMode ? SelectionMode.SINGLE : SelectionMode.MULTIPLE;
        this.tableView.getSelectionModel().setSelectionMode(selectionMode);
        this.treeView.getSelectionModel().setSelectionMode(selectionMode);
        this.okButton.setVisible(singleSelectMode);
        this.okButton.setManaged(singleSelectMode);
        this.bindOkButton();
    }

    public boolean isSingleSelectMode() {
        return this.singleSelectMode;
    }

    public void setCreatePdoAllowed(boolean allowed) {
        this.newButton.setVisible(allowed);
        this.newButton.setManaged(allowed);
    }

    public boolean isCreatePdoAllowed() {
        return this.newButton.isVisible();
    }

    public void updateTitle() {
        Stage stage = this.getStage();
        if (stage != null) {
            stage.setTitle(MessageFormat.format(this.resources.getString("Search {0}"), this.getPdo().getPlural()));
        }
    }

    public void find() {
        this.filterField.clear();
        if (this.finder.isSearchRunningInBackground()) {
            this.getView().setCursor(Cursor.WAIT);
            PdoTracker.getInstance().addTask((Task)new AbstractTask(){

                public void run() {
                    ObservableList result = PdoSearch.this.finder.runSearch();
                    Platform.runLater(() -> {
                        PdoSearch.this.setItems(result);
                        PdoSearch.this.getView().setCursor(Cursor.DEFAULT);
                    });
                }
            });
        } else {
            this.setItems(this.finder.runSearch());
        }
        this.cancelButton.setText(this.resources.getString(Fx.isModal((Stage)this.getStage()) ? "cancel" : "close"));
    }

    public void setItems(ObservableList<T> items) {
        SortedList sortedItems;
        if (items == null) {
            items = FXCollections.observableArrayList();
        }
        if (items instanceof SortedList) {
            sortedItems = (SortedList)items;
        } else {
            sortedItems = new SortedList(items);
            sortedItems.comparatorProperty().bind((ObservableValue)this.tableView.comparatorProperty());
        }
        this.items = items;
        this.countLabel.setText(Integer.toString(items.size()));
        if (this.treeShown) {
            TreeItem root = new TreeItem();
            for (PersistentDomainObject item : items) {
                root.getChildren().add(GuiProviderFactory.getInstance().createGuiProvider(item).createTreeItem());
            }
            root.setExpanded(true);
            this.treeView.setRoot(root);
            this.treeView.setShowRoot(false);
            this.treeView.getSelectionModel().clearSelection();
            this.treeViewInvalid = false;
            this.tableViewInvalid = true;
        } else {
            this.tableView.setItems((ObservableList)sortedItems);
            this.tableView.getSelectionModel().clearSelection();
            this.tableView.refresh();
            this.treeViewInvalid = true;
            this.tableViewInvalid = false;
        }
        if (this.getPdo().isNormTextProvided()) {
            this.filterField.setVisible(true);
            this.filterButton.setVisible(true);
        }
    }

    public ObservableList<T> getItems() {
        return this.items;
    }

    public void filterResult() {
        String filterText = StringHelper.normalize((String)this.filterField.getText());
        if (!StringHelper.isAllWhitespace((String)filterText)) {
            List filteredResult = this.getItems().stream().filter(p -> p.getNormText() != null && p.getNormText().contains(filterText)).collect(Collectors.toList());
            this.setItems(FXCollections.observableArrayList(filteredResult));
        }
    }

    public ObservableList<T> getSelectedItems() {
        ObservableList selectedItems;
        if (this.createdPdo != null) {
            selectedItems = FXCollections.observableArrayList();
            selectedItems.add(this.createdPdo);
        } else if (this.treeShown) {
            selectedItems = FXCollections.observableArrayList();
            this.treeView.getSelectionModel().getSelectedItems().stream().forEach(p -> selectedItems.add(p.getValue()));
        } else {
            selectedItems = this.tableView.getSelectionModel().getSelectedItems();
        }
        return selectedItems;
    }

    public void clearSelection() {
        this.tableView.getSelectionModel().clearSelection();
        this.treeView.getSelectionModel().clearSelection();
    }

    public boolean isTreeShown() {
        return this.treeShown;
    }

    public void showTree() {
        if (!this.treeShown) {
            this.treeView.toFront();
            this.treeShown = true;
            this.treeButton.setGraphic((Node)Fx.createImageView((String)"table"));
            if (this.treeViewInvalid) {
                this.setItems(this.getItems());
            }
            this.bindOkButton();
        }
    }

    public TreeView<T> getTreeView() {
        this.showTree();
        return this.treeView;
    }

    public void showTable() {
        if (this.treeShown) {
            this.tableView.toFront();
            this.treeShown = false;
            this.treeButton.setGraphic((Node)Fx.createImageView((String)"tree"));
            if (this.tableViewInvalid) {
                this.setItems(this.getItems());
            }
            this.bindOkButton();
        }
    }

    public TableView<T> getTableView() {
        this.showTable();
        return this.tableView;
    }

    public void cancel() {
        this.clearSelection();
        this.close();
    }

    public void close() {
        Stage stage = Fx.getStage((Node)this.getView());
        if (stage != null) {
            stage.close();
        }
    }

    public void createPdo() {
        PersistentDomainObject nPdo = Rdc.displayCrudStage(this.on(), true, Modality.APPLICATION_MODAL, (Window)this.getStage());
        if (nPdo != null && !nPdo.isNew()) {
            this.createdPdo = nPdo;
            this.close();
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.resources = resources;
        this.treeButton.setGraphic((Node)Fx.createImageView((String)"tree"));
        this.treeButton.setOnAction(e -> {
            if (this.treeShown) {
                this.showTable();
            } else {
                this.showTree();
            }
        });
        this.filterButton.setGraphic((Node)Fx.createImageView((String)"search"));
        this.filterButton.setOnAction(e -> this.filterResult());
        this.filterField.setOnAction(e -> this.filterButton.doClick());
        this.findButton.setGraphic((Node)Fx.createImageView((String)"search"));
        this.findButton.setOnAction(e -> this.find());
        this.newButton.setGraphic((Node)Fx.createImageView((String)"new"));
        this.newButton.setOnAction(e -> this.createPdo());
        this.okButton.setGraphic((Node)Fx.createImageView((String)"ok"));
        this.okButton.setOnAction(e -> this.close());
        this.cancelButton.setGraphic((Node)Fx.createImageView((String)"close"));
        this.cancelButton.setOnAction(e -> this.cancel());
    }

    public void configure() {
        this.getView().addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (!(event.isAltDown() || event.isControlDown() || event.isMetaDown() || event.isShiftDown() || event.isShortcutDown() || event.getCode() != KeyCode.ESCAPE || !Fx.isModal((Stage)this.getStage()))) {
                this.cancel();
            }
        });
    }

    protected void bindOkButton() {
        this.okButton.disableProperty().unbind();
        if (this.okButton.isVisible()) {
            if (this.treeShown) {
                this.okButton.disableProperty().bind((ObservableValue)this.treeView.getSelectionModel().selectedItemProperty().isNull().or((ObservableBooleanValue)this.wrongTypeSelected));
            } else {
                this.okButton.disableProperty().bind((ObservableValue)this.tableView.getSelectionModel().selectedItemProperty().isNull());
            }
        }
    }
}

