/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.translate;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.control.TableView;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.ValueTranslatorService;
import org.tentackle.fx.rdc.GuiProvider;
import org.tentackle.fx.rdc.GuiProviderFactory;
import org.tentackle.fx.table.TableConfiguration;
import org.tentackle.fx.translate.ObservableListTranslator;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PersistentDomainObject;

@ValueTranslatorService(modelClass=List.class, viewClass=ObservableList.class)
public class PdoObservableListTranslator<T extends PersistentDomainObject<T>, C extends List<T>>
extends ObservableListTranslator<T, C> {
    public PdoObservableListTranslator(FxComponent component) {
        super(component);
        Class elemClass;
        Type[] typeArguments;
        Type genType;
        if (component instanceof TableView && (genType = component.getGenericType()) instanceof ParameterizedType && (typeArguments = ((ParameterizedType)genType).getActualTypeArguments()) != null && typeArguments.length == 1 && PersistentDomainObject.class.isAssignableFrom(elemClass = (Class)typeArguments[0])) {
            PersistentDomainObject pdo = Pdo.create((Class)elemClass);
            GuiProvider<PersistentDomainObject> provider = GuiProviderFactory.getInstance().createGuiProvider(pdo);
            TableConfiguration<PersistentDomainObject> config = provider.createTableConfiguration();
            if (config.getBindingType() == TableConfiguration.BINDING.YES) {
                config.getBinder().bind();
            } else if (config.getBindingType() == TableConfiguration.BINDING.INHERITED) {
                config.getBinder().bindAllInherited();
            }
            config.configure((TableView)component);
        }
    }
}

