/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.app;

import java.text.MessageFormat;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.tentackle.app.AbstractApplication;
import org.tentackle.app.AppFxRdcBundle;
import org.tentackle.app.FxApplication;
import org.tentackle.app.LoginApplication;
import org.tentackle.app.LoginFailedHandler;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxController;
import org.tentackle.fx.FxFactory;
import org.tentackle.fx.FxUtilities;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.ApplicationException;
import org.tentackle.misc.CommandLine;
import org.tentackle.misc.StringHelper;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.LoginFailedException;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoTracker;
import org.tentackle.pdo.Session;
import org.tentackle.pdo.SessionInfo;
import org.tentackle.reflect.ReflectionHelper;

public abstract class DesktopApplication<C extends FxController>
extends AbstractApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(DesktopApplication.class);
    private FxApplication fxApplication;
    private C mainController;
    private CommandLine cmdLine;
    private LoginFailedHandler lfh;
    private Stage mainStage;

    public static DesktopApplication<?> getDesktopApplication() {
        return (DesktopApplication)DesktopApplication.getRunningApplication();
    }

    public DesktopApplication(String name) {
        super(name);
    }

    public abstract Class<? extends C> getMainControllerClass();

    public void configureMainStage(Stage mainStage) {
        this.mainStage = mainStage;
    }

    public Stage getMainStage() {
        return this.mainStage;
    }

    public void setMainController(C mainController) {
        this.mainController = mainController;
    }

    public C getMainController() {
        return this.mainController;
    }

    public LoginFailedHandler createLoginFailedHandler(Parent view, SessionInfo sessionInfo) {
        return new LoginFailedHandler(this, view, sessionInfo);
    }

    public void doLogin(final Parent view, final SessionInfo sessionInfo) {
        Service<Void> loginSvc = new Service<Void>(){

            protected Task<Void> createTask() {
                return new Task<Void>(){

                    protected Void call() throws Exception {
                        try {
                            if (StringHelper.isAllWhitespace((String)sessionInfo.getUserName())) {
                                DesktopApplication.this.showApplicationStatus(AppFxRdcBundle.getString("PLEASE ENTER THE USERNAME"), 0.0);
                                return null;
                            }
                            DesktopApplication.this.showApplicationStatus(AppFxRdcBundle.getString("CONNECTING TO SERVER..."), 0.0);
                            Session session = DesktopApplication.this.createSession(sessionInfo);
                            try {
                                session.open();
                                session.makeCurrent();
                                DesktopApplication.this.setSessionInfo(sessionInfo);
                                DomainContext context = DesktopApplication.this.createDomainContext(session);
                                if (context == null) {
                                    session.getSessionInfo().clearPassword();
                                    session.close();
                                    return null;
                                }
                                DesktopApplication.this.setDomainContext(context);
                                DesktopApplication.this.updateSessionInfoAfterLogin();
                            }
                            catch (LoginFailedException lfx) {
                                if (DesktopApplication.this.lfh == null) {
                                    DesktopApplication.this.lfh = DesktopApplication.this.createLoginFailedHandler(view, sessionInfo);
                                }
                                DesktopApplication.this.lfh.handle(lfx);
                                return null;
                            }
                            catch (RuntimeException rex) {
                                LOGGER.severe("login failed", (Throwable)rex);
                                Platform.runLater(() -> {
                                    Fx.error((String)AppFxRdcBundle.getString("LOGIN FAILED!"), (Throwable)rex);
                                    view.getScene().getWindow().hide();
                                });
                                return null;
                            }
                            DesktopApplication.this.showApplicationStatus(AppFxRdcBundle.getString("CONFIGURE APPLICATION..."), 0.1);
                            try {
                                DesktopApplication.this.doConfigureApplication();
                            }
                            catch (RuntimeException | ApplicationException ex) {
                                LOGGER.severe("configure application failed", ex);
                                return null;
                            }
                            DesktopApplication.this.showApplicationStatus(AppFxRdcBundle.getString("LOADING GUI..."), 0.5);
                            FxController mainController = Fx.load(DesktopApplication.this.getMainControllerClass());
                            DesktopApplication.this.showApplicationStatus(AppFxRdcBundle.getString("LAUNCH MAIN WINDOW..."), 1.0);
                            Platform.runLater(() -> {
                                try {
                                    session.makeCurrent();
                                    DesktopApplication.this.setMainController(mainController);
                                    Stage stage = Fx.createStage((Modality)Modality.NONE);
                                    DesktopApplication.this.configureMainStage(stage);
                                    Scene scene = new Scene(mainController.getView());
                                    stage.setScene(scene);
                                    stage.addEventHandler(WindowEvent.WINDOW_SHOWN, e -> {
                                        try {
                                            DesktopApplication.this.doFinishStartup();
                                            view.getScene().getWindow().hide();
                                        }
                                        catch (RuntimeException | ApplicationException ex) {
                                            LOGGER.severe("finish startup failed", ex);
                                        }
                                    });
                                    stage.show();
                                    Platform.runLater(() -> FxFactory.getInstance().preloadControllers());
                                }
                                catch (RuntimeException rex) {
                                    String msg = MessageFormat.format(AppFxRdcBundle.getString("LAUNCHING {0} FAILED"), ReflectionHelper.getClassBaseName(DesktopApplication.this.getMainControllerClass()));
                                    LOGGER.severe(msg, (Throwable)rex);
                                    Fx.error((String)msg, (Throwable)rex);
                                    view.getScene().getWindow().hide();
                                }
                            });
                        }
                        catch (RuntimeException rex) {
                            LOGGER.severe("login task failed", (Throwable)rex);
                        }
                        return null;
                    }
                };
            }
        };
        loginSvc.start();
    }

    public FxApplication getFxApplication() {
        return this.fxApplication;
    }

    public void setFxApplication(FxApplication fxApplication) {
        this.fxApplication = fxApplication;
    }

    public Class<? extends FxApplication> getApplicationClass() {
        return LoginApplication.class;
    }

    public void showApplicationStatus(String msg, double progress) {
        if (this.fxApplication != null) {
            Platform.runLater(() -> this.fxApplication.showApplicationStatus(msg, progress));
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            LOGGER.info(msg, new Object[0]);
        }
    }

    public void registerUncaughtExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(this.getUncaughtExceptionHandler());
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return (t, e) -> {
            LOGGER.severe("unhandled exception detected", e);
            Platform.runLater(() -> Fx.error((String)AppFxRdcBundle.getString("UNEXPECTED EXCEPTION"), (Throwable)e));
        };
    }

    public boolean isServer() {
        return false;
    }

    public DomainContext createDomainContext(Session session) {
        return super.createDomainContext(null);
    }

    public void start(String[] args) {
        this.cmdLine = new CommandLine(args);
        this.setProperties(this.cmdLine.getOptionsAsProperties());
        try {
            LOGGER.fine("register application", new Object[0]);
            this.register();
            LOGGER.fine("initialize application", new Object[0]);
            this.doInitialize();
            LOGGER.fine("initializing FX application", new Object[0]);
            Application.launch(this.getApplicationClass(), (String[])args);
        }
        catch (RuntimeException | ApplicationException ex) {
            try {
                Fx.error((String)MessageFormat.format(AppFxRdcBundle.getString("LAUNCHING {0} FAILED"), this.getName()), (Throwable)ex);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.doStop(3, (Exception)ex);
        }
    }

    public void stop() {
        try {
            this.unregister();
            this.doStop(0);
        }
        catch (RuntimeException | ApplicationException e) {
            LOGGER.logStacktrace(e);
            this.doStop(4, (Exception)e);
        }
    }

    public synchronized CommandLine getCommandLine() {
        return this.cmdLine;
    }

    protected void configurePreferences() {
        this.showApplicationStatus(AppFxRdcBundle.getString("INSTALLING PREFERENCES..."), 0.3);
        super.configurePreferences();
    }

    protected void configureSecurityManager() {
        this.showApplicationStatus(AppFxRdcBundle.getString("CONFIGURE SECURITY..."), 0.4);
        super.configureSecurityManager();
    }

    protected void configurePdoTracker() {
        this.showApplicationStatus(AppFxRdcBundle.getString("CONFIGURE MONITORING..."), 0.2);
        super.configurePdoTracker();
        Session trackerSession = this.getSession().clone();
        trackerSession.groupWith(this.getSession().getSessionId());
        PdoTracker.getInstance().setSession(trackerSession);
    }

    protected void doFinishStartup() throws ApplicationException {
        super.doFinishStartup();
        FxUtilities.getInstance().addTentackleStyleSheet();
        PdoTracker.getInstance().addShutdownRunnable(() -> {
            if (!PdoTracker.getInstance().isTerminationRequested()) {
                LOGGER.severe("*** emergency shutdown ***", new Object[0]);
                this.stop();
            }
        });
    }

    protected void doStop(int exitValue, Exception ex) {
        if (exitValue != 0 || ex != null) {
            LOGGER.log(Logger.Level.SEVERE, "application " + this.getName() + " abnormally terminated with exit code " + exitValue, (Throwable)ex);
        } else {
            LOGGER.info("application {0} terminated", new Object[]{this.getName()});
        }
        try {
            Session session;
            Pdo.terminateHelperThreads();
            DomainContext context = this.getDomainContext();
            if (context != null && (session = context.getSession()) != null) {
                session.close();
            }
        }
        catch (RuntimeException rex) {
            LOGGER.severe("FX application stopped ungracefully", (Throwable)rex);
        }
        System.exit(exitValue);
    }

    protected void doStop(int exitValue) {
        this.doStop(exitValue, null);
    }
}

