/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.app;

import java.text.MessageFormat;
import javafx.application.Platform;
import javafx.scene.Parent;
import org.tentackle.app.AppFxRdcBundle;
import org.tentackle.app.DesktopApplication;
import org.tentackle.fx.Fx;
import org.tentackle.pdo.AlreadyLoggedInException;
import org.tentackle.pdo.LoginFailedException;
import org.tentackle.pdo.SessionInfo;
import org.tentackle.pdo.VersionInfoIncompatibleException;

public class LoginFailedHandler {
    private final DesktopApplication<?> application;
    private final Parent view;
    private final SessionInfo sessionInfo;
    private int loginCount;

    public LoginFailedHandler(DesktopApplication<?> application, Parent view, SessionInfo sessionInfo) {
        this.application = application;
        this.view = view;
        this.sessionInfo = sessionInfo;
    }

    public DesktopApplication<?> getApplication() {
        return this.application;
    }

    public Parent getView() {
        return this.view;
    }

    public SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    public void handle(LoginFailedException ex) {
        if (ex instanceof AlreadyLoggedInException) {
            this.application.showApplicationStatus(ex.getLocalizedMessage(), 0.0);
        } else if (ex instanceof VersionInfoIncompatibleException) {
            VersionInfoIncompatibleException vx = (VersionInfoIncompatibleException)ex;
            Platform.runLater(() -> {
                Fx.info((String)MessageFormat.format(AppFxRdcBundle.getString("client version {0} does not match server version {1}"), vx.getClientVersion(), vx.getServerVersion()));
                this.view.getScene().getWindow().hide();
            });
        } else {
            ++this.loginCount;
            switch (this.loginCount) {
                case 1: {
                    this.application.showApplicationStatus(AppFxRdcBundle.getString("LOGIN FAILED! (2 MORE RETRIES)"), 0.0);
                    break;
                }
                case 2: {
                    this.application.showApplicationStatus(AppFxRdcBundle.getString("LOGIN FAILED! (LAST RETRY)"), 0.0);
                    break;
                }
                default: {
                    this.application.showApplicationStatus(AppFxRdcBundle.getString("LOGIN FAILED!"), 0.0);
                    Platform.runLater(() -> {
                        Fx.info((String)AppFxRdcBundle.getString("LOGIN REFUSED! PLEASE CHECK YOUR USERNAME AND PASSWORD"));
                        this.view.getScene().getWindow().hide();
                    });
                }
            }
        }
    }
}

