/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc;

import java.lang.reflect.Constructor;
import java.util.concurrent.ConcurrentHashMap;
import org.tentackle.common.Service;
import org.tentackle.common.ServiceFactory;
import org.tentackle.fx.rdc.GuiProvider;
import org.tentackle.fx.rdc.GuiProviderFactory;
import org.tentackle.pdo.PdoRuntimeException;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.reflect.ClassMapper;
import org.tentackle.reflect.DefaultClassMapper;

@Service(value=GuiProviderFactory.class)
public class DefaultGuiProviderFactory
implements GuiProviderFactory {
    private final ConcurrentHashMap<Class, Constructor> serviceMap = new ConcurrentHashMap();
    private final ClassMapper guiClassMapper = new DefaultClassMapper("FX GUI-provider", ServiceFactory.getServiceFinder().createNameMap(GuiProvider.class.getName()), null);

    @Override
    public <T extends PersistentDomainObject<T>> GuiProvider<T> createGuiProvider(T pdo) {
        Class pdoClass = pdo.getEffectiveClass();
        Constructor<?> con = this.serviceMap.get(pdoClass);
        if (con == null) {
            try {
                Class serviceClass = this.guiClassMapper.mapLenient(pdoClass);
                Constructor<?>[] cons = serviceClass.getConstructors();
                for (int i = 0; i < cons.length; ++i) {
                    con = cons[i];
                    Class<?>[] params = con.getParameterTypes();
                    if (params.length != 1 || !pdoClass.isAssignableFrom(params[0])) continue;
                    this.serviceMap.put(pdoClass, con);
                    break;
                }
                if (con == null) {
                    throw new PdoRuntimeException("no matching constructor found for " + serviceClass.getName() + "(" + pdoClass.getName() + ")");
                }
            }
            catch (ClassNotFoundException ex) {
                throw new PdoRuntimeException("cannot load GUI service class for " + pdoClass.getName());
            }
        }
        try {
            return (GuiProvider)con.newInstance(pdo);
        }
        catch (Exception e) {
            throw new PdoRuntimeException("cannot instantiate GUI service object for " + pdoClass.getName(), (Throwable)e);
        }
    }
}

