/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.search;

import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import javafx.beans.property.ObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import org.tentackle.fx.CaseConversion;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.component.FxTextField;
import org.tentackle.fx.rdc.PdoFinder;
import org.tentackle.misc.StringHelper;
import org.tentackle.pdo.PersistentDomainObject;

@FxControllerService(binding=FxControllerService.BINDING.NO)
public class DefaultPdoFinder<T extends PersistentDomainObject<T>>
extends PdoFinder<T> {
    private T pdo;
    @FXML
    private FxTextField patternField;

    @Override
    public ObservableList<T> runSearch() {
        if (this.pdo != null && this.pdo.isNormTextProvided()) {
            String pattern = StringHelper.toLikeString((String)StringHelper.normalize((String)this.patternField.getText()));
            return FXCollections.observableArrayList((Collection)this.getPdo().selectByNormText(pattern));
        }
        return FXCollections.observableArrayList((Collection)this.getPdo().selectAllCached());
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.patternField.setCaseConversion(CaseConversion.UPPER_CASE);
    }

    public T getPdo() {
        return this.pdo;
    }

    public void setPdo(T pdo) {
        this.pdo = pdo;
        this.patternField.clear();
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.pdo != null && this.pdo.isNormTextProvided() && !this.isSearchRunningImmediately();
    }

    @Override
    public void requestInitialFocus() {
        if (this.pdo != null && this.pdo.isNormTextProvided()) {
            this.patternField.requestFocus();
        }
    }

    @Override
    public ObjectProperty<EventHandler<ActionEvent>> getSearchActionProperty() {
        return this.patternField.onActionProperty();
    }
}

