/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.admin;

import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import org.tentackle.bind.Bindable;
import org.tentackle.fx.AbstractFxController;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.FxFactory;
import org.tentackle.fx.component.FxButton;
import org.tentackle.fx.component.FxTableView;
import org.tentackle.fx.container.FxHBox;
import org.tentackle.fx.rdc.security.SecurityDialogFactory;
import org.tentackle.fx.rdc.table.TablePopup;
import org.tentackle.fx.table.TableConfiguration;
import org.tentackle.pdo.AdminExtension;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoRemoteSession;
import org.tentackle.prefs.PersistedPreferencesFactory;

@FxControllerService
public class SessionsView
extends AbstractFxController {
    @Bindable
    private List<AdminExtension.SessionData> sessions;
    @FXML
    private FxTableView<AdminExtension.SessionData> sessionsNode;
    @FXML
    private FxHBox buttonBox;
    @FXML
    private FxButton securityButton;
    @FXML
    private FxButton refreshButton;
    @FXML
    private FxButton killButton;
    private ResourceBundle resources;
    private AdminExtension adminExt;
    private TablePopup<AdminExtension.SessionData> popup;

    public void initialize(URL location, ResourceBundle resources) {
        this.resources = resources;
        this.securityButton.setGraphic((Node)Fx.createImageView((String)"security"));
        this.securityButton.setOnAction(e -> this.security());
        this.refreshButton.setGraphic((Node)Fx.createImageView((String)"reload"));
        this.refreshButton.setOnAction(e -> this.refresh());
        this.killButton.setGraphic((Node)Fx.createImageView((String)"cancel"));
        this.killButton.setOnAction(e -> this.kill());
        this.killButton.disableProperty().bind((ObservableValue)this.sessionsNode.getSelectionModel().selectedItemProperty().isNull());
        this.popup = new TablePopup<AdminExtension.SessionData>(this.sessionsNode, "Sessions", false);
        TableConfiguration<AdminExtension.SessionData> config = this.createTableConfiguration();
        config.getBinder().bind();
        config.configure(this.sessionsNode);
    }

    public void configure() {
        DomainContext context = Pdo.createDomainContext();
        if (context.getSession().isRemote()) {
            PdoRemoteSession remoteSession = (PdoRemoteSession)context.getSession().getRemoteSession();
            this.adminExt = (AdminExtension)remoteSession.getExtension(context, AdminExtension.class);
            this.popup.loadPreferences(PersistedPreferencesFactory.getInstance().isSystemOnly());
            this.securityButton.setDisable(!SecurityDialogFactory.getInstance().isDialogAllowed(context));
            this.refresh();
        }
    }

    public FxHBox getButtonBox() {
        return this.buttonBox;
    }

    private void refresh() {
        this.sessions = this.adminExt.getSessions();
        this.sessionsNode.updateView();
    }

    private void kill() {
        AdminExtension.SessionData session = (AdminExtension.SessionData)this.sessionsNode.getSelectionModel().getSelectedItem();
        if (session != null && Fx.question((String)this.resources.getString("really kill the session?"), (boolean)false) && this.adminExt.kill(session.getUserId(), session.getSessionGroup(), session.getApplicationName(), session.getApplicationId()) > 0) {
            this.refresh();
        }
    }

    private void security() {
        SecurityDialogFactory.getInstance().showDialog(AdminExtension.class);
    }

    private TableConfiguration<AdminExtension.SessionData> createTableConfiguration() {
        TableConfiguration config = FxFactory.getInstance().createTableConfiguration(AdminExtension.SessionData.class, null);
        config.addColumn("userId", this.resources.getString("user-ID"));
        config.addColumn("userName", this.resources.getString("user"));
        config.addColumn("applicationName", this.resources.getString("application"));
        config.addColumn("applicationId", this.resources.getString("appl.-ID"));
        config.addColumn("clientVersionInfo", this.resources.getString("version"));
        config.addColumn("locale", this.resources.getString("locale"));
        config.addColumn("timeZone", this.resources.getString("timezone"));
        config.addColumn("vmInfo", this.resources.getString("VM"));
        config.addColumn("osInfo", this.resources.getString("OS"));
        config.addColumn("hostInfo", this.resources.getString("hostname"));
        config.addColumn("clientHost", this.resources.getString("client"));
        config.addColumn("since", this.resources.getString("since"));
        config.addColumn("sessionNumber", this.resources.getString("session-no."));
        config.addColumn("sessionGroup", this.resources.getString("group-no."));
        config.addColumn("options", this.resources.getString("options"));
        return config;
    }
}

