/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.crud;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.fxml.FXML;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Modality;
import javafx.stage.Popup;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.tentackle.app.AbstractApplication;
import org.tentackle.bind.Binder;
import org.tentackle.fx.AbstractFxController;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.FxControl;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.component.FxButton;
import org.tentackle.fx.component.FxLabel;
import org.tentackle.fx.container.FxBorderPane;
import org.tentackle.fx.container.FxHBox;
import org.tentackle.fx.rdc.EventListenerProxy;
import org.tentackle.fx.rdc.GuiProvider;
import org.tentackle.fx.rdc.GuiProviderFactory;
import org.tentackle.fx.rdc.InteractiveError;
import org.tentackle.fx.rdc.InteractiveErrorFactory;
import org.tentackle.fx.rdc.PdoEditor;
import org.tentackle.fx.rdc.PdoEvent;
import org.tentackle.fx.rdc.Rdc;
import org.tentackle.fx.rdc.RdcFxRdcBundle;
import org.tentackle.fx.rdc.security.SecurityDialogFactory;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.LockException;
import org.tentackle.pdo.PdoHolder;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.session.NotFoundException;
import org.tentackle.validate.ValidationFailedException;
import org.tentackle.validate.ValidationResult;

@FxControllerService(binding=FxControllerService.BINDING.NO)
public class PdoCrud<T extends PersistentDomainObject<T>>
extends AbstractFxController
implements PdoHolder<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdoCrud.class);
    @FXML
    private FxLabel noViewLabel;
    @FXML
    private FxBorderPane borderPane;
    @FXML
    private FxHBox buttonBox;
    @FXML
    private FxButton securityButton;
    @FXML
    private FxButton previousButton;
    @FXML
    private FxButton nextButton;
    @FXML
    private FxButton treeButton;
    @FXML
    private FxButton findButton;
    @FXML
    private FxButton newButton;
    @FXML
    private FxButton saveButton;
    @FXML
    private FxButton deleteButton;
    @FXML
    private FxButton printButton;
    @FXML
    private FxButton cancelButton;
    private ResourceBundle resources;
    private PdoEditor<T> editor;
    private SimpleBooleanProperty editAllowed;
    private SimpleBooleanProperty pdoIsNew;
    private List<T> pdoList;
    private int pdoListIndex;
    private boolean editable;
    private EventListenerProxy<PdoEvent> eventProxy;

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setPdoList(List<T> pdoList) {
        this.pdoList = pdoList;
        this.pdoListIndex = 0;
        boolean prevNextVisible = pdoList != null && pdoList.size() > 1;
        this.previousButton.setManaged(prevNextVisible);
        this.previousButton.setVisible(prevNextVisible);
        this.nextButton.setManaged(prevNextVisible);
        this.nextButton.setVisible(prevNextVisible);
        if (pdoList != null) {
            T pdo = this.getPdo();
            if (pdo != null) {
                this.pdoListIndex = pdoList.indexOf(this.getPdo());
            }
            this.updatePrevNextButtons();
            this.findButton.setVisible(false);
            this.findButton.setManaged(false);
            this.newButton.setVisible(false);
            this.newButton.setManaged(false);
            this.deleteButton.setVisible(false);
            this.deleteButton.setManaged(false);
        } else {
            this.findButton.setVisible(true);
            this.findButton.setManaged(true);
            this.newButton.setVisible(true);
            this.newButton.setManaged(true);
            this.deleteButton.setVisible(true);
            this.deleteButton.setManaged(true);
        }
    }

    public List<T> getPdoList() {
        return this.pdoList;
    }

    public void setEditor(PdoEditor<T> editor) {
        this.editor = editor;
        this.borderPane.setCenter((Node)editor.getView());
        BorderPane.setMargin((Node)editor.getView(), (Insets)new Insets(5.0));
    }

    public PdoEditor<T> getEditor() {
        return this.editor;
    }

    public void setPdo(T pdo) {
        if (pdo == null) {
            throw new NullPointerException("pdo must not be null");
        }
        this.editor.setPdo((PersistentDomainObject)pdo);
        this.editor.getContainer().clearErrors();
        this.editor.getContainer().invalidateSavedView();
        this.editor.getContainer().updateView();
        this.editAllowed = new SimpleBooleanProperty();
        if (this.editor.isViewAllowed()) {
            this.noViewLabel.setVisible(false);
            this.editor.getView().setVisible(true);
            this.editAllowed.set(this.isEditable() && this.editor.isEditAllowed());
            this.editor.setChangeable(this.editAllowed.get());
        } else {
            this.noViewLabel.setVisible(true);
            this.editor.getView().setVisible(false);
            this.editAllowed.set(false);
        }
        this.pdoIsNew = new SimpleBooleanProperty(pdo.isNew());
        this.getContainer().saveView();
        this.updateTitle();
        GuiProvider<T> guiProvider = GuiProviderFactory.getInstance().createGuiProvider(pdo);
        this.treeButton.setDisable(pdo.isNew() || !guiProvider.providesTreeChildObjects());
        this.deleteButton.setDisable(!this.editAllowed.get() || !this.editor.isRemoveAllowed());
        this.newButton.setDisable(!this.editAllowed.get() || !this.editor.isNewAllowed());
        this.saveButton.disableProperty().bind((ObservableValue)this.getContainer().viewModifiedProperty().or((ObservableBooleanValue)this.pdoIsNew).and((ObservableBooleanValue)this.editAllowed).not());
        this.securityButton.setDisable(!pdo.isRootEntity() || !SecurityDialogFactory.getInstance().isDialogAllowed(pdo.getDomainContext()));
        this.getBinder().putBindingProperty(DomainContext.class, (Object)pdo.getDomainContext());
        if (this.editAllowed.get() && !pdo.isNew() && pdo.isTokenLockProvided()) {
            try {
                pdo.requestTokenLock();
            }
            catch (LockException lx) {
                this.editAllowed.set(false);
                this.editor.setChangeable(false);
                this.deleteButton.setDisable(true);
                if (lx.getTokenLock() != null) {
                    Fx.info((String)MessageFormat.format(RdcFxRdcBundle.getString("{0} {1} is being locked by {2} since {3}"), pdo.getSingular(), pdo.toString(), AbstractApplication.getRunningApplication().getUser(pdo.getDomainContext(), pdo.getEditedBy()), pdo.getEditedSince()));
                }
                LOGGER.severe("locking the PDO failed", (Throwable)lx);
                Fx.error((String)MessageFormat.format(RdcFxRdcBundle.getString("{0} {1} could not be locked"), pdo.getSingular(), pdo.toString()));
            }
        }
    }

    public T getPdo() {
        return (T)(this.editor == null ? null : this.editor.getPdo());
    }

    public void updateTitle() {
        Stage stage = this.getStage();
        if (stage != null) {
            stage.setTitle(MessageFormat.format(this.resources.getString("Edit {0} {1}"), this.getPdo().getSingular(), this.getPdo().toString()));
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.resources = resources;
        this.securityButton.setGraphic((Node)Fx.createImageView((String)"security"));
        this.securityButton.setOnAction(e -> this.security());
        this.previousButton.setGraphic((Node)Fx.createImageView((String)"up"));
        this.previousButton.setOnAction(e -> this.previous());
        this.nextButton.setGraphic((Node)Fx.createImageView((String)"down"));
        this.nextButton.setOnAction(e -> this.next());
        this.setPdoList(null);
        this.treeButton.setGraphic((Node)Fx.createImageView((String)"browser"));
        this.treeButton.setOnAction(e -> this.tree());
        this.findButton.setGraphic((Node)Fx.createImageView((String)"search"));
        this.findButton.setOnAction(e -> this.find());
        this.newButton.setGraphic((Node)Fx.createImageView((String)"new"));
        this.newButton.setOnAction(e -> this.newPdo());
        this.saveButton.setGraphic((Node)Fx.createImageView((String)"save"));
        this.saveButton.setOnAction(e -> this.save());
        this.deleteButton.setGraphic((Node)Fx.createImageView((String)"delete"));
        this.deleteButton.setOnAction(e -> this.delete());
        this.printButton.setGraphic((Node)Fx.createImageView((String)"print"));
        this.printButton.setOnAction(e -> this.print());
        this.cancelButton.setGraphic((Node)Fx.createImageView((String)"close"));
        this.cancelButton.setOnAction(e -> this.cancel());
        this.cancelButton.setCancelButton(true);
    }

    public void configure() {
        this.eventProxy = new EventListenerProxy((Node)this.getView());
        this.treeButton.addEventHandler(MouseEvent.ANY, event -> {
            if (event.isPopupTrigger()) {
                T pdo = this.getPdo();
                if (pdo != null && !pdo.isNew()) {
                    Popup popup = new Popup();
                    TextField field = new TextField(Long.toString(pdo.getId()));
                    field.setPrefColumnCount(field.getText().length());
                    field.setEditable(false);
                    popup.getContent().add((Object)field);
                    popup.setAutoHide(true);
                    Bounds bounds = this.treeButton.localToScreen(this.treeButton.getBoundsInLocal());
                    popup.show((Node)this.treeButton, bounds.getMinX() + bounds.getWidth() / 2.0, bounds.getMinY() + bounds.getHeight() / 2.0);
                }
                event.consume();
            }
        });
        this.getView().addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (!(event.isAltDown() || event.isControlDown() || event.isMetaDown() || event.isShiftDown() || event.isShortcutDown() || event.getCode() != KeyCode.ESCAPE || !Fx.isModal((Stage)this.getStage()))) {
                this.cancel();
            }
        });
    }

    public void tree() {
        Stage stage = Fx.createStage((Modality)Modality.APPLICATION_MODAL);
        stage.initOwner((Window)this.getStage());
        TreeView tree = (TreeView)Fx.createNode(TreeView.class);
        tree.setCellFactory(p -> Rdc.createTreeCell());
        TreeItem<T> item = GuiProviderFactory.getInstance().createGuiProvider(this.getPdo()).createTreeItem();
        item.setExpanded(true);
        tree.setRoot(item);
        Scene scene = new Scene((Parent)tree);
        stage.setScene(scene);
        stage.showAndWait();
    }

    public void previous() {
        if (this.pdoListIndex > 0 && this.releasePdo()) {
            this.setPdo((PersistentDomainObject)this.pdoList.get(--this.pdoListIndex));
            this.updatePrevNextButtons();
            this.eventProxy.fireEvent(new PdoEvent((PersistentDomainObject<?>)this.getPdo(), (EventTarget)this.getView(), (EventType<? extends PdoEvent>)PdoEvent.READ));
        }
    }

    public void next() {
        if (this.pdoListIndex < this.pdoList.size() - 1 && this.releasePdo()) {
            this.setPdo((PersistentDomainObject)this.pdoList.get(++this.pdoListIndex));
            this.updatePrevNextButtons();
            this.eventProxy.fireEvent(new PdoEvent((PersistentDomainObject<?>)this.getPdo(), (EventTarget)this.getView(), (EventType<? extends PdoEvent>)PdoEvent.READ));
        }
    }

    public void security() {
        SecurityDialogFactory.getInstance().showDialog((PersistentDomainObject<?>)this.getPdo());
    }

    public void newPdo() {
        if (this.releasePdo()) {
            this.setPdo(this.on());
            this.getEditor().requestInitialFocus();
        }
    }

    public void save() {
        block3: {
            try {
                this.getPdo().getSession().transaction(() -> {
                    if (this.getEditor().validateForm()) {
                        PersistentDomainObject dup;
                        PersistentDomainObject persistentDomainObject = dup = this.getPdo().isUniqueDomainKeyProvided() ? this.getPdo().findDuplicate() : null;
                        if (dup != null) {
                            Fx.error((String)MessageFormat.format(RdcFxRdcBundle.getString("{0} ALREADY EXISTS"), dup));
                        } else {
                            PersistentDomainObject pdo = this.getPdo().persist();
                            if (!this.closeIfModal()) {
                                this.setPdo(pdo);
                                this.getEditor().requestInitialFocus();
                            }
                            this.eventProxy.fireEvent(new PdoEvent(pdo, (EventTarget)this.getView(), pdo.getSerial() == 1L ? PdoEvent.CREATE : PdoEvent.UPDATE));
                        }
                    }
                    return null;
                });
            }
            catch (ValidationFailedException ex) {
                this.showValidationResults(ex);
            }
            catch (NotFoundException nfe) {
                LOGGER.info("saving " + this.getPdo().toGenericString() + " failed: " + nfe.getLocalizedMessage(), new Object[0]);
                Fx.error((String)MessageFormat.format(RdcFxRdcBundle.getString("{0} MODIFIED BY_ANOTHER USER MEANWHILE"), this.getPdo()));
                PersistentDomainObject pdo = this.getPdo().reload();
                if (pdo == null) break block3;
                this.setPdo(pdo);
            }
        }
    }

    public void delete() {
        T pdo = this.getPdo();
        pdo.delete();
        if (!this.closeIfModal()) {
            this.setPdo(this.on());
            this.getEditor().requestInitialFocus();
        }
        this.eventProxy.fireEvent(new PdoEvent((PersistentDomainObject<?>)pdo, (EventTarget)this.getView(), (EventType<? extends PdoEvent>)PdoEvent.DELETE));
    }

    public void cancel() {
        Stage stage;
        if (this.releasePdo() && (stage = Fx.getStage((Node)this.getView())) != null) {
            stage.close();
        }
    }

    public void find() {
        ObservableList<T> items;
        if (this.releasePdo() && !(items = Rdc.displaySearchStage(this.getPdo(), Modality.APPLICATION_MODAL, (Window)Fx.getStage((Node)this.getView()), false)).isEmpty()) {
            this.setPdo(((PersistentDomainObject)items.get(0)).reload());
            this.getEditor().requestInitialFocus();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean releasePdo() {
        T oldPdo = this.getPdo();
        if (oldPdo == null || !this.editAllowed.get()) return true;
        if (this.getContainer().isViewModified()) {
            Boolean answer = Rdc.showSaveDiscardCancelDialog();
            if (Boolean.TRUE.equals(answer)) {
                this.save();
                return true;
            } else {
                if (!Boolean.FALSE.equals(answer)) return false;
                if (!oldPdo.isNew() && oldPdo.isTokenLockProvided() && oldPdo.isTokenLockedByMe()) {
                    oldPdo.releaseTokenLock();
                }
                this.setPdo(this.on());
            }
            return true;
        }
        if (oldPdo.isNew() || !oldPdo.isTokenLockProvided() || !oldPdo.isTokenLockedByMe()) return true;
        try {
            oldPdo.releaseTokenLock();
            return true;
        }
        catch (LockException lex) {
            LOGGER.info("token unlock failed (ignored): " + lex.getLocalizedMessage(), new Object[0]);
        }
        return true;
    }

    public void print() {
        this.getEditor().print();
    }

    public FxHBox getButtonBox() {
        return this.buttonBox;
    }

    public void removeAllPdoEventListeners() {
        this.eventProxy.removeAllEventFilters();
        this.eventProxy.removeAllEventHandlers();
    }

    public void addPdoEventFilter(EventType<PdoEvent> eventType, EventHandler<PdoEvent> eventFilter) {
        this.eventProxy.addEventFilter(eventType, eventFilter);
    }

    public void removePdoEventFilter(EventType<PdoEvent> eventType, EventHandler<PdoEvent> eventFilter) {
        this.eventProxy.removeEventFilter(eventType, eventFilter);
    }

    public void addPdoEventHandler(EventType<PdoEvent> eventType, EventHandler<PdoEvent> eventHandler) {
        this.eventProxy.addEventHandler(eventType, eventHandler);
    }

    public void removePdoEventHandler(EventType<PdoEvent> eventType, EventHandler<PdoEvent> eventHandler) {
        this.eventProxy.removeEventHandler(eventType, eventHandler);
    }

    protected boolean closeIfModal() {
        Stage stage = Fx.getStage((Node)this.getView());
        if (stage != null && Fx.isModal((Stage)stage)) {
            stage.close();
            return true;
        }
        return false;
    }

    protected void updatePrevNextButtons() {
        this.previousButton.setDisable(this.pdoListIndex <= 0);
        this.nextButton.setDisable(this.pdoListIndex >= this.pdoList.size() - 1);
    }

    protected InteractiveError createInteractiveError(ValidationResult validationResult) {
        return InteractiveErrorFactory.getInstance().createInteractiveError(this.editor.getValidationMappers(), (Binder)this.editor.getBinder(), validationResult);
    }

    protected List<InteractiveError> createInteractiveErrors(List<ValidationResult> validationResults) {
        ArrayList<InteractiveError> errors = new ArrayList<InteractiveError>();
        for (ValidationResult validationResult : validationResults) {
            errors.add(this.createInteractiveError(validationResult));
        }
        return errors;
    }

    protected void showValidationResults(ValidationFailedException ex) {
        StringBuilder warnings = new StringBuilder();
        StringBuilder errors = new StringBuilder();
        List<InteractiveError> errorList = this.createInteractiveErrors(ex.getResults());
        for (InteractiveError error : errorList) {
            if (error.isWarning()) {
                if (warnings.length() > 0) {
                    warnings.append('\n');
                }
                warnings.append(error.getText());
                continue;
            }
            if (errors.length() > 0) {
                errors.append('\n');
            }
            errors.append(error.getText());
        }
        if (errors.length() > 0) {
            LOGGER.info("validation errors:\n{0}", new Object[]{errors.toString()});
            Fx.error((String)errors.toString());
        }
        if (warnings.length() > 0) {
            LOGGER.info("validation warnings:\n{0}", new Object[]{warnings.toString()});
            Fx.info((String)warnings.toString());
        }
        Platform.runLater(() -> {
            for (InteractiveError error : errorList) {
                FxControl control;
                if (error.isWarning() || !((control = error.getControl()) instanceof FxComponent)) continue;
                ((FxComponent)control).setError(error.getText());
            }
        });
    }
}

