/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.table;

import com.sun.javafx.scene.control.skin.TableViewSkin;
import com.sun.javafx.scene.control.skin.VirtualFlow;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.print.PageLayout;
import javafx.print.PrinterJob;
import javafx.scene.Node;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.transform.Scale;
import org.tentackle.fx.AbstractFxController;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.component.FxLabel;
import org.tentackle.fx.component.FxTableView;

@FxControllerService(binding=FxControllerService.BINDING.NO)
public class SimpleTablePrinter
extends AbstractFxController {
    private ResourceBundle resources;
    private int pageCount;
    @FXML
    private FxLabel titleLabel;
    @FXML
    private FxTableView<?> tableView;
    @FXML
    private FxLabel pageLabel;

    public void initialize(URL location, ResourceBundle resources) {
        this.resources = resources;
    }

    public void print(FxTableView<?> table, String title, PrinterJob job, PageLayout pageLayout) {
        double tableWidth = 0.0;
        this.tableView.getColumns().clear();
        this.tableView.setConfiguration(table.getConfiguration());
        for (TableColumn column : table.getColumns()) {
            if (!column.isVisible()) continue;
            TableColumn printColumn = new TableColumn(column.getText());
            printColumn.setCellValueFactory(column.getCellValueFactory());
            printColumn.setCellFactory(column.getCellFactory());
            printColumn.setMinWidth(column.getWidth());
            printColumn.setMaxWidth(column.getWidth());
            this.tableView.getColumns().add((Object)printColumn);
            tableWidth += column.getWidth();
        }
        double printableWidth = pageLayout.getPrintableWidth();
        double printableHeight = pageLayout.getPrintableHeight();
        double scaleXY = 1.0;
        if (printableWidth < tableWidth) {
            scaleXY = printableWidth / tableWidth;
            tableWidth = printableWidth / scaleXY;
        }
        this.tableView.setMinWidth(tableWidth - 2.0);
        this.tableView.setMaxWidth(tableWidth - 2.0);
        this.titleLabel.setText(title);
        this.updatePageLabel(1);
        double tableHeight = (printableHeight - this.titleLabel.getHeight() - this.pageLabel.getHeight()) / scaleXY;
        this.tableView.setMinHeight(tableHeight);
        this.tableView.setMaxHeight(tableHeight);
        this.getView().getTransforms().add((Object)new Scale(scaleXY, scaleXY));
        System.out.println("displayed rows = " + this.getVisibleRowCount((TableView<?>)table));
        this.tableView.setItems(table.getItems());
        Platform.runLater(() -> {
            int visibleCount = this.getVisibleRowCount((TableView<?>)this.tableView) - 1;
            System.out.println("visible rows = " + visibleCount);
            ArrayList<PageInfo> pages = new ArrayList<PageInfo>();
            int start = 0;
            int count = 0;
            ObservableList items = FXCollections.observableArrayList();
            this.tableView.setItems(items);
            for (Object item : table.getItems()) {
                items.add(item);
                if (visibleCount < count) {
                    pages.add(new PageInfo(start, count));
                    start += count;
                    items.clear();
                    items.add(item);
                    count = 1;
                    continue;
                }
                ++count;
            }
            if (count > 0) {
                pages.add(new PageInfo(start, count));
            }
            this.pageCount = pages.size();
            int pageNo = 1;
            for (PageInfo page : pages) {
                this.tableView.setItems(FXCollections.observableList((List)table.getItems().subList(page.rowStart, page.rowStart + page.rowCount)));
                this.tableView.getSelectionModel().clearSelection();
                this.updatePageLabel(pageNo++);
                job.printPage(pageLayout, (Node)this.getView());
            }
            job.endJob();
        });
    }

    private void updatePageLabel(int pageNo) {
        this.pageLabel.setText(MessageFormat.format(this.resources.getString("page {0} of {1}"), pageNo, this.pageCount));
    }

    private VirtualFlow<?> loadVirtualFlow(TableView<?> table) {
        return (VirtualFlow)((TableViewSkin)table.getSkin()).getChildren().get(1);
    }

    private int getVisibleRowCount(TableView<?> table) {
        VirtualFlow<?> flow = this.loadVirtualFlow(table);
        int start = 0;
        int end = 0;
        IndexedCell cell = flow.getFirstVisibleCell();
        if (cell != null) {
            start = cell.getIndex();
        }
        if ((cell = flow.getLastVisibleCell()) != null) {
            end = cell.getIndex();
        }
        return end - start;
    }

    private static class PageInfo {
        private final int rowStart;
        private final int rowCount;

        public PageInfo(int rowStart, int rowCount) {
            this.rowStart = rowStart;
            this.rowCount = rowCount;
        }
    }
}

