/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.translate;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Modality;
import javafx.stage.Window;
import org.tentackle.bind.Bindable;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.FxFactory;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.FxTextComponent;
import org.tentackle.fx.FxUtilities;
import org.tentackle.fx.ValueTranslatorService;
import org.tentackle.fx.rdc.RdcUtilities;
import org.tentackle.fx.translate.ValueStringTranslator;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.DomainKey;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PersistentDomainObject;

@ValueTranslatorService(modelClass=PersistentDomainObject.class, viewClass=String.class)
public class PdoStringTranslator<T extends PersistentDomainObject<T>>
extends ValueStringTranslator<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdoStringTranslator.class);
    private ValueStringTranslator<?> udkTranslator;
    private String viewValue;
    private T pdo;
    private boolean inPdoSearch;

    public PdoStringTranslator(FxTextComponent component) {
        super(component);
        Class pdoClass = this.getComponent().getType();
        try {
            String bindingOptions;
            PersistentDomainObject proxy = Pdo.create((Class)pdoClass);
            Class udkClass = proxy.getUniqueDomainKeyType();
            this.udkTranslator = (ValueStringTranslator)FxFactory.getInstance().createValueTranslator(udkClass, String.class, (FxComponent)component);
            this.udkTranslator.setLenient(true);
            Bindable bindable = this.getBindableAnnotation(proxy);
            if (bindable != null && (bindingOptions = bindable.options()) != null) {
                FxUtilities.getInstance().applyBindingOptions(component, component.getBinding().getMember(), bindingOptions);
            }
        }
        catch (RuntimeException proxy) {
            // empty catch block
        }
        Node node = (Node)this.getComponent();
        node.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (!(event.isAltDown() || event.isControlDown() || event.isMetaDown() || event.isShiftDown() || event.isShortcutDown())) {
                if (event.getCode() == KeyCode.F2) {
                    event.consume();
                    if (this.pdo != null) {
                        ArrayList<T> pdoList = new ArrayList<T>();
                        pdoList.add(this.pdo);
                        this.pdo = RdcUtilities.getInstance().displayCrudStage(this.pdo, pdoList, !this.pdo.isImmutable(), Modality.APPLICATION_MODAL, (Window)Fx.getStage((Node)node), null);
                    }
                } else if (event.getCode() == KeyCode.F3) {
                    event.consume();
                    this.inPdoSearch = true;
                    T found = this.searchPdo(this.createPdo());
                    this.inPdoSearch = false;
                    if (found != null) {
                        this.pdo = found;
                        component.setViewValue(this.pdo);
                        component.updateModel();
                    }
                }
            }
        });
    }

    public Function<T, String> toViewFunction() {
        return m -> {
            this.viewValue = m != null ? (this.udkTranslator != null ? (String)this.udkTranslator.toViewFunction().apply(m.getUniqueDomainKey()) : m.toString()) : null;
            this.pdo = m;
            return this.viewValue;
        };
    }

    public Function<String, T> toModelFunction() {
        return v -> {
            if (!this.inPdoSearch && !Objects.equals(v, this.viewValue)) {
                if (v == null) {
                    this.pdo = null;
                } else {
                    T proxy = this.createPdo();
                    Class udkClass = proxy.getUniqueDomainKeyType();
                    if (this.udkTranslator != null) {
                        Object udk = this.udkTranslator.toModelFunction().apply(v);
                        this.pdo = proxy.findByUniqueDomainKey(udk);
                        if (this.pdo == null) {
                            proxy.setUniqueDomainKey(udk);
                            this.pdo = this.searchPdo(proxy);
                            Platform.runLater(() -> ((Node)this.getComponent()).requestFocus());
                        }
                    } else {
                        String udk = v;
                        try {
                            if (!udkClass.isAssignableFrom(v.getClass())) {
                                try {
                                    Constructor cons = udkClass.getConstructor(v.getClass());
                                    udk = cons.newInstance(v);
                                }
                                catch (InvocationTargetException ix) {
                                    this.presetSearchCriteria(proxy, udkClass, (String)v);
                                    this.pdo = this.searchPdo(proxy);
                                    Platform.runLater(() -> ((Node)this.getComponent()).requestFocus());
                                    return this.pdo;
                                }
                                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException e) {
                                    throw new FxRuntimeException("could not create domain key: " + udkClass.getName() + "(" + v.getClass().getName() + ")", (Throwable)e);
                                }
                            }
                            this.pdo = proxy.findByUniqueDomainKey((Object)udk);
                            if (this.pdo == null) {
                                this.presetSearchCriteria(proxy, udkClass, (String)v);
                                this.pdo = this.searchPdo(proxy);
                                Platform.runLater(() -> ((Node)this.getComponent()).requestFocus());
                            }
                        }
                        catch (RuntimeException rex) {
                            LOGGER.warning("loading PDO " + proxy.getClassBaseName() + " for " + udkClass + "='" + udk + "' failed", (Throwable)rex);
                            throw rex;
                        }
                    }
                }
            }
            return this.pdo;
        };
    }

    protected T createPdo() {
        Class pdoClass = this.getComponent().getType();
        DomainContext context = (DomainContext)this.getComponent().getBinding().getBinder().getBindingProperty(DomainContext.class);
        if (context == null) {
            throw new FxRuntimeException("missing binding property for DomainContext");
        }
        return (T)Pdo.create((Class)pdoClass, (DomainContext)context);
    }

    protected T searchPdo(T proxy) {
        ObservableList<T> list = RdcUtilities.getInstance().displaySearchStage(proxy, Modality.APPLICATION_MODAL, (Window)Fx.getStage((Node)((Node)this.getComponent())), true);
        if (!list.isEmpty()) {
            return (T)((PersistentDomainObject)list.get(0));
        }
        return null;
    }

    protected void presetSearchCriteria(T proxy, Class<?> udkClass, String v) {
        try {
            Object udk;
            Method m = udkClass.getDeclaredMethod("lenientValueOf", String.class);
            if (Modifier.isStatic(m.getModifiers()) && udkClass.isAssignableFrom(m.getReturnType()) && (udk = m.invoke(null, v)) != null) {
                proxy.setUniqueDomainKey(udk);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e1) {
            throw new FxRuntimeException("cannot create lenient domain key", (Throwable)e1);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    protected Bindable getBindableAnnotation(T proxy) {
        for (Method method : proxy.getEffectiveClass().getMethods()) {
            Bindable bindable;
            if (!method.isAnnotationPresent(DomainKey.class) || (bindable = method.getAnnotation(Bindable.class)) == null) continue;
            return bindable;
        }
        return null;
    }
}

