/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc;

import java.util.Objects;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.input.DragEvent;
import javafx.scene.input.MouseEvent;
import org.tentackle.fx.rdc.GuiProvider;
import org.tentackle.fx.rdc.GuiProviderFactory;
import org.tentackle.fx.rdc.PdoContextMenuFactory;
import org.tentackle.fx.rdc.PdoTreeItem;
import org.tentackle.pdo.PersistentDomainObject;

public class PdoTreeCell<T extends PersistentDomainObject<T>>
extends TreeCell<T> {
    private GuiProvider<T> provider;
    private ContextMenu contextMenu;

    public PdoTreeCell() {
        this.addEventHandler(MouseEvent.ANY, event -> {
            if (event.isPopupTrigger()) {
                this.showContextMenu((MouseEvent)event);
            }
        });
        this.setOnDragDetected(e -> {
            if (this.provider != null && this.provider.createDragboard((Node)this) != null) {
                e.consume();
            }
        });
        this.setOnDragOver(e -> {
            if (e.getGestureSource() != this && this.provider != null && this.provider.isDragAccepted((DragEvent)e)) {
                e.consume();
            }
        });
        this.setOnDragDropped(e -> {
            if (this.provider != null) {
                this.provider.dropDragboard(e.getDragboard());
                PersistentDomainObject reloadedPdo = this.provider.getPdo().reload();
                TreeItem root = this.getTreeItem().getParent();
                if (root != null) {
                    ObservableList items = root.getChildren();
                    int i = 0;
                    for (TreeItem item : items) {
                        if (reloadedPdo.equals(item.getValue())) {
                            TreeItem<PersistentDomainObject> reloadedItem = GuiProviderFactory.getInstance().createGuiProvider(reloadedPdo).createTreeItem();
                            items.set(i, reloadedItem);
                            this.getTreeView().refresh();
                            reloadedItem.setExpanded(true);
                            break;
                        }
                        ++i;
                    }
                }
                e.consume();
            }
        });
    }

    public void updateItem(T pdo, boolean empty) {
        super.updateItem(pdo, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
            this.provider = null;
        } else {
            GuiProvider<T> guiProvider = this.provider = pdo == null ? null : GuiProviderFactory.getInstance().createGuiProvider(pdo);
            if (this.provider == null) {
                this.setText(null);
                this.setTooltip(null);
                this.setGraphic(this.getTreeItem().getGraphic());
            } else {
                PdoTreeItem parentItem = this.getPdoTreeItem().getParentPdoItem();
                String treeText = this.provider.getTreeText(parentItem == null ? null : (PersistentDomainObject)parentItem.getPdo());
                this.setText(treeText);
                String tooltipText = this.provider.getToolTipText(parentItem == null ? null : (PersistentDomainObject)parentItem.getPdo());
                if (Objects.equals(treeText, tooltipText)) {
                    tooltipText = null;
                }
                this.setTooltip(tooltipText == null ? null : new Tooltip(tooltipText));
                this.setGraphic((Node)this.provider.createIcon());
            }
        }
    }

    public void showContextMenu(MouseEvent event) {
        if (this.contextMenu != null) {
            this.contextMenu.hide();
        }
        this.contextMenu = PdoContextMenuFactory.getInstance().create(this);
        if (this.contextMenu != null) {
            event.consume();
            this.contextMenu.setOnHidden(e -> {
                this.contextMenu = null;
            });
            this.contextMenu.show((Node)this, event.getScreenX(), event.getScreenY());
        }
    }

    public PdoTreeItem<T> getPdoTreeItem() {
        return (PdoTreeItem)this.getTreeItem();
    }
}

