/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javafx.scene.Node;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.image.ImageView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import org.tentackle.common.BundleFactory;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.component.FxTableView;
import org.tentackle.fx.rdc.DefaultPdoEditor;
import org.tentackle.fx.rdc.GuiProvider;
import org.tentackle.fx.rdc.GuiProviderService;
import org.tentackle.fx.rdc.PdoEditor;
import org.tentackle.fx.rdc.PdoFinder;
import org.tentackle.fx.rdc.PdoTreeItem;
import org.tentackle.fx.rdc.Rdc;
import org.tentackle.fx.rdc.search.DefaultPdoFinder;
import org.tentackle.fx.rdc.table.TableUtilities;
import org.tentackle.fx.table.TableConfiguration;
import org.tentackle.misc.IdentifiableKey;
import org.tentackle.misc.ShortLongText;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoUtilities;
import org.tentackle.pdo.PersistentDomainObject;

public class DefaultGuiProvider<T extends PersistentDomainObject<T>>
implements GuiProvider<T> {
    private T pdo;
    private Boolean bundleProvided;
    private ResourceBundle bundle;

    public DefaultGuiProvider(T pdo) {
        this.setPdo(pdo);
        GuiProviderService annotation = this.getClass().getAnnotation(GuiProviderService.class);
        if (annotation != null) {
            this.bundleProvided = !annotation.noBundle();
        }
    }

    @Override
    public boolean isBundleProvided() {
        if (this.bundleProvided == null) {
            try {
                this.getBundle();
                this.bundleProvided = true;
            }
            catch (MissingResourceException mx) {
                this.bundleProvided = false;
            }
        }
        return this.bundleProvided;
    }

    @Override
    public ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = BundleFactory.getBundle((String)this.getClass().getName());
        }
        return this.bundle;
    }

    public T getPdo() {
        return this.pdo;
    }

    public void setPdo(T pdo) {
        if (pdo == null) {
            throw new NullPointerException("pdo must not be null");
        }
        this.pdo = pdo;
    }

    public DomainContext getDomainContext() {
        return this.pdo.getDomainContext();
    }

    @Override
    public ImageView createIcon() {
        return Fx.createImageView((String)"unknown");
    }

    @Override
    public boolean editorExists() {
        return false;
    }

    @Override
    public PdoEditor<T> createEditor() {
        if (this.editorExists()) {
            return new DefaultPdoEditor(this.getPdo().getEffectiveClass(), this.isBundleProvided() ? this.getBundle() : null);
        }
        throw new FxRuntimeException("no controller for " + this.pdo.getEffectiveClass().getName());
    }

    @Override
    public boolean finderExists() {
        return false;
    }

    @Override
    public PdoFinder<T> createFinder() {
        if (this.finderExists()) {
            return (PdoFinder)Fx.load(DefaultPdoFinder.class);
        }
        throw new FxRuntimeException("no finder for " + this.pdo.getEffectiveClass().getName());
    }

    @Override
    public Dragboard createDragboard(Node node) {
        if (this.pdo.getClassId() != 0 && !this.pdo.isNew()) {
            Dragboard db = node.startDragAndDrop(new TransferMode[]{TransferMode.COPY});
            ClipboardContent content = new ClipboardContent();
            content.putString(this.pdo.toIdString());
            db.setContent((Map)content);
            return db;
        }
        return null;
    }

    @Override
    public boolean isDragAccepted(DragEvent event) {
        return false;
    }

    public IdentifiableKey<PersistentDomainObject<?>> getPdoKeyFromDragboard(Dragboard dragboard) {
        String idString = dragboard.getString();
        if (idString != null && !idString.isEmpty()) {
            return PdoUtilities.getInstance().idStringToIdentifiableKey(idString);
        }
        return null;
    }

    @Override
    public void dropDragboard(Dragboard dragbord) {
        PersistentDomainObject pdoToDrop;
        IdentifiableKey<PersistentDomainObject<?>> key = this.getPdoKeyFromDragboard(dragbord);
        if (key != null && (pdoToDrop = Pdo.create((Class)key.getIdentifiableClass(), (DomainContext)this.pdo.getDomainContext()).select(key.getIdentifiableId())) != null) {
            this.dropPdo(pdoToDrop);
        }
    }

    public void dropPdo(PersistentDomainObject<?> pdoToDrop) {
        throw new FxRuntimeException("dropPdo is not implemented for " + this.pdo.getEffectiveClass().getName());
    }

    @Override
    public TableConfiguration<T> createTableConfiguration() {
        return TableUtilities.getInstance().createTableConfiguration(this.getPdo().getEffectiveClass(), this.isBundleProvided() ? this.getBundle() : null);
    }

    @Override
    public FxTableView<T> createTableView() {
        TableConfiguration<T> config = this.createTableConfiguration();
        if (config.getBindingType() == TableConfiguration.BINDING.YES) {
            config.getBinder().bind();
        } else if (config.getBindingType() == TableConfiguration.BINDING.INHERITED) {
            config.getBinder().bindAllInherited();
        }
        if (config.getBindingType() != TableConfiguration.BINDING.NO) {
            config.getBinder().assertAllBound();
        }
        FxTableView tableView = (FxTableView)Fx.createNode(TableView.class);
        config.configure(tableView);
        return tableView;
    }

    public String toString() {
        return this.getClass().getName() + " for " + this.getPdo().toGenericString();
    }

    @Override
    public boolean providesTreeChildObjects() {
        return false;
    }

    @Override
    public <P extends PersistentDomainObject<P>> Collection<? extends PersistentDomainObject<?>> getTreeChildObjects(P parent) {
        return new ArrayList();
    }

    @Override
    public int getTreeExpandMaxDepth() {
        return 0;
    }

    @Override
    public boolean providesTreeParentObjects() {
        return false;
    }

    @Override
    public <P extends PersistentDomainObject<P>> Collection<? extends PersistentDomainObject<?>> getTreeParentObjects(P parent) {
        return new ArrayList();
    }

    @Override
    public T getTreeRoot() {
        return this.getPdo();
    }

    @Override
    public <P extends PersistentDomainObject<P>> String getTreeText(P parent) {
        if (this.getPdo() instanceof ShortLongText) {
            return ((ShortLongText)this.getPdo()).getShortText() + " : " + ((ShortLongText)this.getPdo()).getLongText();
        }
        return this.getPdo().toString();
    }

    @Override
    public <P extends PersistentDomainObject<P>> String getToolTipText(P parent) {
        return this.getTreeText(parent);
    }

    @Override
    public boolean stopTreeExpansion() {
        return false;
    }

    @Override
    public TreeItem<T> createTreeItem() {
        return new PdoTreeItem<T>(this.pdo);
    }

    @Override
    public TreeCell<T> createTreeCell() {
        return Rdc.createTreeCell();
    }
}

