/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.tentackle.common.Service;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.FxUtilities;
import org.tentackle.fx.rdc.RdcFactory;
import org.tentackle.fx.rdc.RdcFxRdcBundle;
import org.tentackle.fx.rdc.RdcUtilitiesHolder;
import org.tentackle.fx.rdc.crud.PdoCrud;
import org.tentackle.fx.rdc.search.PdoSearch;
import org.tentackle.pdo.PersistentDomainObject;

@Service(value=RdcUtilities.class)
public class RdcUtilities {
    private final Map<Class<?>, Set<PdoCrud<?>>> crudCache = new HashMap();
    private final Map<Class<?>, Set<PdoSearch<?>>> searchCache = new HashMap();

    public static RdcUtilities getInstance() {
        return RdcUtilitiesHolder.INSTANCE;
    }

    public <T extends PersistentDomainObject<T>> T displayCrudStage(T pdo, boolean editable, Modality modality, Window owner) {
        return this.displayCrudStage(pdo, null, editable, modality, owner, null);
    }

    public <T extends PersistentDomainObject<T>> T displayCrudStage(T pdo, ObservableList<T> pdoList, boolean editable, Modality modality, Window owner, Consumer<PdoCrud<T>> configurator) {
        PdoCrud crud = this.getCrud(pdo, pdoList, editable, modality, owner);
        if (crud != null) {
            Stage stage = crud.getStage();
            if (stage == null && Fx.getStage((Node)crud.getView()) == null) {
                stage = Fx.createStage((Modality)modality);
                if (owner != null) {
                    stage.initOwner(owner);
                }
                Scene scene = new Scene(crud.getView());
                stage.setScene(scene);
                crud.updateTitle();
                Stage s = stage;
                stage.addEventFilter(WindowEvent.WINDOW_SHOWN, e -> Platform.runLater(() -> {
                    Point2D location = FxUtilities.getInstance().determinePreferredStageLocation(s);
                    s.setX(location.getX());
                    s.setY(location.getY());
                    crud.getEditor().requestInitialFocus();
                }));
                stage.addEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, e -> {
                    if (!crud.releasePdo()) {
                        e.consume();
                    }
                });
                stage.addEventFilter(WindowEvent.WINDOW_HIDDEN, e -> {
                    crud.setPdoList(null);
                    crud.removeAllPdoEventListeners();
                });
            }
            if (configurator != null) {
                configurator.accept(crud);
            }
            if (stage == null) {
                throw new FxRuntimeException("misconfigured crud stage");
            }
            if (modality != Modality.NONE) {
                stage.showAndWait();
                pdo = crud.getPdo();
            } else {
                stage.show();
            }
        }
        return pdo;
    }

    public synchronized <T extends PersistentDomainObject<T>> PdoCrud<T> getCrud(T pdo, ObservableList<T> pdoList, boolean editable, Modality modality, Window owner) {
        Class pdoClass = pdo.getEffectiveClass();
        Set cruds = this.crudCache.computeIfAbsent(pdoClass, k -> new HashSet());
        Iterator iter = cruds.iterator();
        while (iter.hasNext()) {
            PdoCrud crud = (PdoCrud)((Object)iter.next());
            Stage stage = Fx.getStage((Node)crud.getView());
            if (stage == null || !stage.isShowing() && stage.getModality() == modality && stage.getOwner() == owner) {
                crud.setEditable(editable);
                crud.setModal(modality != Modality.NONE);
                crud.setPdo(pdo);
                crud.setPdoList(pdoList);
                return crud;
            }
            if (Objects.equals(pdo, crud.getPdo()) && stage.isShowing() && (crud.isEditing() || !editable)) {
                stage.toFront();
                return null;
            }
            if (stage.isShowing() || stage.getModality() != modality || stage.getOwner() == owner || stage.getOwner() == null || stage.getOwner().isShowing()) continue;
            iter.remove();
        }
        PdoCrud<T> crud = RdcFactory.getInstance().createPdoCrud(pdo, editable, modality != Modality.NONE);
        crud.setPdoList(pdoList);
        cruds.add(crud);
        return crud;
    }

    public <T extends PersistentDomainObject<T>> ObservableList<T> displaySearchStage(T pdo, Modality modality, Window owner, boolean createPdoAllowed) {
        return this.displaySearchStage(pdo, modality, owner, createPdoAllowed, null);
    }

    public <T extends PersistentDomainObject<T>> ObservableList<T> displaySearchStage(T pdo, Modality modality, Window owner, boolean createPdoAllowed, Consumer<PdoSearch<T>> configurator) {
        PdoSearch search = this.getSearch(pdo, modality, owner);
        search.setCreatePdoAllowed(createPdoAllowed);
        Stage stage = search.getStage();
        if (stage == null && Fx.getStage((Node)search.getView()) == null) {
            stage = Fx.createStage((Modality)modality);
            if (owner != null) {
                stage.initOwner(owner);
            }
            Scene scene = new Scene(search.getView());
            stage.setScene(scene);
            search.updateTitle();
            search.setSingleSelectMode(Fx.isModal((Stage)stage));
            Stage s = stage;
            stage.addEventFilter(WindowEvent.WINDOW_SHOWN, e -> Platform.runLater(() -> {
                Point2D location = FxUtilities.getInstance().determinePreferredStageLocation(s);
                s.setX(location.getX());
                s.setY(location.getY());
                search.getFinder().requestInitialFocus();
            }));
            stage.addEventFilter(WindowEvent.WINDOW_HIDDEN, e -> Platform.runLater(() -> search.setItems(null)));
        }
        if (configurator != null) {
            configurator.accept(search);
        }
        if (stage == null) {
            throw new FxRuntimeException("misconfigured search stage");
        }
        if (modality != Modality.NONE) {
            stage.showAndWait();
            return search.getSelectedItems();
        }
        stage.show();
        return null;
    }

    public synchronized <T extends PersistentDomainObject<T>> PdoSearch<T> getSearch(T pdo, Modality modality, Window owner) {
        Class pdoClass = pdo.getEffectiveClass();
        Set searches = this.searchCache.computeIfAbsent(pdoClass, k -> new HashSet());
        Iterator iter = searches.iterator();
        while (iter.hasNext()) {
            PdoSearch search = (PdoSearch)((Object)iter.next());
            Stage stage = Fx.getStage((Node)search.getView());
            if (stage == null || !stage.isShowing() && stage.getModality() == modality && stage.getOwner() == owner) {
                search.setItems(null);
                search.setPdo(pdo);
                search.showTable();
                return search;
            }
            if (stage.isShowing() || stage.getModality() != modality || stage.getOwner() == owner || stage.getOwner() == null || stage.getOwner().isShowing()) continue;
            iter.remove();
        }
        PdoSearch<T> search = RdcFactory.getInstance().createPdoSearch(pdo);
        searches.add(search);
        return search;
    }

    public Boolean showSaveDiscardCancelDialog() {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle(RdcFxRdcBundle.getString("QUESTION"));
        alert.setHeaderText(null);
        alert.setContentText(RdcFxRdcBundle.getString("DATA_HAS_BEEN_MODIFIED!_DISCARD,_SAVE_OR_CANCEL?"));
        ButtonType saveButtonType = new ButtonType(RdcFxRdcBundle.getString("SAVE"));
        ButtonType discardButtonType = new ButtonType(RdcFxRdcBundle.getString("DISCARD"));
        ButtonType cancelButtonType = new ButtonType(RdcFxRdcBundle.getString("CANCEL"), ButtonBar.ButtonData.CANCEL_CLOSE);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{saveButtonType, discardButtonType, cancelButtonType});
        Button cancelButton = (Button)alert.getDialogPane().lookupButton(cancelButtonType);
        cancelButton.setDefaultButton(true);
        Optional result = alert.showAndWait();
        if (result.isPresent()) {
            if (result.get() == saveButtonType) {
                return Boolean.TRUE;
            }
            if (result.get() == discardButtonType) {
                return Boolean.FALSE;
            }
        }
        return null;
    }
}

