/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.login;

import java.io.File;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.SelectionMode;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.tentackle.bind.Bindable;
import org.tentackle.bind.BindingVetoException;
import org.tentackle.fx.AbstractFxController;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.component.FxButton;
import org.tentackle.fx.component.FxChoiceBox;
import org.tentackle.fx.component.FxListView;
import org.tentackle.fx.component.FxPasswordField;
import org.tentackle.fx.component.FxTextArea;
import org.tentackle.fx.component.FxTextField;
import org.tentackle.fx.container.FxGridPane;
import org.tentackle.fx.container.FxTab;
import org.tentackle.fx.rdc.RdcFxRdcBundle;
import org.tentackle.session.BackendConfiguration;
import org.tentackle.session.DriverConfiguration;
import org.tentackle.validate.ValidationScope;
import org.tentackle.validate.ValidationScopeFactory;
import org.tentackle.validate.ValidationUtilities;

@FxControllerService(binding=FxControllerService.BINDING.BINDABLE_INHERITED)
public class Backends
extends AbstractFxController {
    private String application;
    private boolean system;
    @FXML
    private FxTab backendTab;
    @FXML
    private FxListView<BackendConfiguration> backends;
    @FXML
    private FxButton addBackendButton;
    @FXML
    private FxButton removeBackendButton;
    @Bindable
    private BackendConfiguration backend;
    @FXML
    private FxGridPane backendPane;
    @FXML
    private FxTextField backendName;
    @FXML
    private FxTextField backendUrl;
    @FXML
    private FxTextArea backendOptions;
    @FXML
    private FxChoiceBox<DriverConfiguration> backendDriver;
    @FXML
    private FxTextField backendUser;
    @FXML
    private FxPasswordField backendPassword;
    @FXML
    private FxTab driverTab;
    @FXML
    private FxListView<DriverConfiguration> drivers;
    @FXML
    private FxButton addDriverButton;
    @FXML
    private FxButton removeDriverButton;
    @Bindable
    private DriverConfiguration driver;
    @FXML
    private FxGridPane driverPane;
    @FXML
    private FxTextField driverName;
    @FXML
    private FxTextField driverDriver;
    @FXML
    private FxTextField driverUrl;
    @FXML
    private FxButton driverButton;

    public static void editBackends(String application, boolean system) {
        Backends controller = (Backends)Fx.load(Backends.class);
        Scene scene = new Scene(controller.getView());
        Stage stage = Fx.createStage((Modality)Modality.APPLICATION_MODAL);
        stage.setScene(scene);
        stage.setTitle(RdcFxRdcBundle.getString("Backends"));
        controller.setApplication(application, system);
        controller.getView().addEventFilter(KeyEvent.KEY_RELEASED, event -> {
            if (event.getCode() == KeyCode.ESCAPE) {
                controller.persist();
                stage.close();
            }
        });
        stage.addEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, e -> controller.persist());
        stage.showAndWait();
    }

    @FXML
    private void initialize() {
        this.backends.setBindable(false);
        this.backends.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.backends.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                this.backendPane.updateModel();
                this.persist((BackendConfiguration)oldValue);
            }
            this.backend = newValue;
            this.removeBackendButton.setDisable(this.backend == null);
            this.backendPane.setChangeable(this.backend != null);
            this.backendPane.updateView();
        });
        this.addBackendButton.setGraphic((Node)Fx.createImageView((String)"add"));
        this.addBackendButton.setOnAction(event -> {
            this.backends.getItems().add((Object)new BackendConfiguration(this.application, null, null, null, null, null, null));
            this.backends.getSelectionModel().selectLast();
            this.backendName.requestFocus();
        });
        this.removeBackendButton.setGraphic((Node)Fx.createImageView((String)"delete"));
        this.removeBackendButton.setOnAction(event -> {
            BackendConfiguration current = (BackendConfiguration)this.backends.getSelectionModel().getSelectedItem();
            if (current != null) {
                this.backends.getItems().remove((Object)current);
                this.backends.getSelectionModel().selectFirst();
                this.backends.scrollTo(0);
                if (current.getName() != null) {
                    current.remove(this.system);
                }
            }
        });
        this.backendTab.setOnSelectionChanged(event -> {
            if (this.backendTab.isSelected()) {
                this.loadDriverConfigurations();
            }
        });
        this.drivers.setBindable(false);
        this.drivers.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.drivers.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                this.driverPane.updateModel();
                this.persist(this.driver);
            }
            this.driver = newValue;
            this.removeDriverButton.setDisable(this.driver == null);
            this.driverPane.setChangeable(this.driver != null);
            this.driverButton.setDisable(this.driver == null);
            this.driverPane.updateView();
        });
        this.driverPane.setChangeable(false);
        this.driverButton.setDisable(true);
        this.addDriverButton.setGraphic((Node)Fx.createImageView((String)"add"));
        this.addDriverButton.setOnAction(event -> {
            this.drivers.getItems().add((Object)new DriverConfiguration(null, null, null));
            this.drivers.getSelectionModel().selectLast();
            this.driverName.requestFocus();
        });
        this.removeDriverButton.setGraphic((Node)Fx.createImageView((String)"delete"));
        this.removeDriverButton.setOnAction(event -> {
            DriverConfiguration current = (DriverConfiguration)this.drivers.getSelectionModel().getSelectedItem();
            if (current != null) {
                this.drivers.getItems().remove((Object)current);
                this.drivers.getSelectionModel().selectFirst();
                this.drivers.scrollTo(0);
                if (current.getName() != null) {
                    current.remove(this.system);
                }
            }
        });
        this.driverButton.setGraphic((Node)Fx.createImageView((String)"file"));
        this.driverButton.setOnAction(event -> {
            FileChooser fileChooser = new FileChooser();
            fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Java JAR File", new String[]{"*.jar"}));
            File file = fileChooser.showOpenDialog((Window)Fx.getStage((Node)this.getView()));
            if (file != null) {
                this.driver.setUrl(file.getAbsolutePath());
                this.driverUrl.updateView();
            }
        });
    }

    public void configure() {
        this.backendName.getBinding().addToModelListener(e -> {
            if (e.getValue() != null && !e.getValue().equals(this.backend.getName())) {
                String newName = (String)e.getValue();
                for (BackendConfiguration b : this.backends.getItems()) {
                    if (b == this.backend || !newName.equals(b.getName())) continue;
                    throw new BindingVetoException(true, MessageFormat.format(RdcFxRdcBundle.getString("{0} ALREADY EXISTS"), b));
                }
                if (this.backend.isPersisted()) {
                    this.backend.remove(this.system);
                }
                Platform.runLater(() -> this.backends.refresh());
            }
        });
        this.driverName.getBinding().addToModelListener(e -> {
            if (e.getValue() != null && !e.getValue().equals(this.driver.getName())) {
                String newName = (String)e.getValue();
                for (DriverConfiguration b : this.drivers.getItems()) {
                    if (b == this.driver || !newName.equals(b.getName())) continue;
                    throw new BindingVetoException(true, MessageFormat.format(RdcFxRdcBundle.getString("{0} ALREADY EXISTS"), b));
                }
                if (this.driver.isPersisted()) {
                    this.driver.remove(this.system);
                }
                Platform.runLater(() -> this.drivers.refresh());
            }
        });
    }

    public void setApplication(String application, boolean system) {
        this.application = application;
        this.backends.getSelectionModel().clearSelection();
        this.backends.getItems().addAll(BackendConfiguration.getBackendConfigurations((String)application, (boolean)system).values());
        this.drivers.getSelectionModel().clearSelection();
        this.drivers.getItems().addAll(DriverConfiguration.getDriverConfigurations((boolean)system).values());
        this.loadDriverConfigurations();
    }

    public BackendConfiguration getBackend() {
        return this.backend;
    }

    public void persist() {
        if (this.backend != null) {
            this.backendPane.updateModel();
            this.persist(this.backend);
        }
        if (this.driver != null) {
            this.driverPane.updateModel();
            this.persist(this.driver);
        }
    }

    private void persist(DriverConfiguration driver) {
        List results = driver.validate("driver", (ValidationScope)ValidationScopeFactory.getInstance().getMandatoryScope());
        if (results.isEmpty()) {
            driver.persist(this.system);
        } else {
            Fx.info((String)ValidationUtilities.getInstance().resultsToMessage(results));
        }
    }

    private void persist(BackendConfiguration backend) {
        List results = backend.validate("backend", (ValidationScope)ValidationScopeFactory.getInstance().getMandatoryScope());
        if (results.isEmpty()) {
            backend.persist(this.system);
        } else {
            Fx.info((String)ValidationUtilities.getInstance().resultsToMessage(results));
        }
    }

    private void loadDriverConfigurations() {
        this.backendDriver.getItems().clear();
        this.backendDriver.getItems().addAll((Collection)this.drivers.getItems());
    }
}

