/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.login;

import java.awt.Toolkit;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.tentackle.app.AbstractApplication;
import org.tentackle.fx.AbstractFxController;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.component.FxButton;
import org.tentackle.fx.component.FxComboBox;
import org.tentackle.fx.component.FxLabel;
import org.tentackle.fx.component.FxPasswordField;
import org.tentackle.fx.component.FxTextField;
import org.tentackle.fx.rdc.app.DesktopApplication;
import org.tentackle.fx.rdc.login.Backends;
import org.tentackle.log.Logger;
import org.tentackle.session.BackendConfiguration;
import org.tentackle.session.SessionInfo;

@FxControllerService(binding=FxControllerService.BINDING.NO)
public class Login
extends AbstractFxController {
    private static final Logger LOGGER = Logger.get(Login.class);
    private SessionInfo sessionInfo;
    private boolean autoLogin;
    private boolean backendFromSystemPrefs;
    @FXML
    private ResourceBundle resources;
    @FXML
    private FxLabel backendLabel;
    @FXML
    private FxComboBox<BackendConfiguration> backendField;
    @FXML
    private FxButton backendButton;
    @FXML
    private FxTextField usernameField;
    @FXML
    private FxPasswordField passwordField;
    @FXML
    private Label messageLabel;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private FxButton loginButton;
    @FXML
    private FxButton cancelButton;

    @FXML
    private void initialize() {
        this.progressBar.setVisible(false);
        this.setCapsLockMessage(this.isCapsLock());
        this.cancelButton.setOnAction(e -> this.cancel());
        this.cancelButton.setGraphic((Node)Fx.createImageView((String)"close"));
        this.loginButton.setOnAction(e -> this.login());
        this.loginButton.setGraphic((Node)Fx.createImageView((String)"ok"));
        this.usernameField.setAutoSelect(true);
        this.passwordField.setOnAction(e -> this.login());
        this.passwordField.setAutoSelect(true);
        this.backendButton.setGraphic((Node)Fx.createImageView((String)"edit"));
        this.backendButton.setOnAction(e -> {
            Backends.editBackends(this.sessionInfo.getApplicationName(), this.backendFromSystemPrefs);
            this.loadBackendConfigurations();
        });
        this.backendField.setOnAction(event -> {
            BackendConfiguration backendConfiguration = (BackendConfiguration)this.backendField.getValue();
            if (backendConfiguration != null && backendConfiguration.getUrl() != null && backendConfiguration.getUrl().startsWith("rmi:") && backendConfiguration.getUser() != null) {
                this.usernameField.setText(backendConfiguration.getUser());
                this.passwordField.setText(backendConfiguration.getPassword());
            }
        });
    }

    public void configure() {
        this.getView().addEventFilter(KeyEvent.KEY_RELEASED, event -> {
            if (event.getCode() == KeyCode.ESCAPE) {
                this.cancel();
            }
            if (event.getCode() == KeyCode.CAPS) {
                Platform.runLater(() -> this.setCapsLockMessage(this.isCapsLock()));
            }
        });
    }

    public void requestInitialFocus() {
        Platform.runLater(() -> ((FxTextField)this.usernameField).requestFocus());
    }

    public void setSessionInfo(SessionInfo sessionInfo) {
        int ndx;
        this.sessionInfo = sessionInfo;
        this.usernameField.setText(sessionInfo.getUserName());
        this.passwordField.setText(sessionInfo.getPasswordAsString());
        String backendInfo = sessionInfo.getProperties().getProperty("backend");
        boolean backendVisible = false;
        if ("@user".equals(backendInfo)) {
            backendVisible = true;
            this.backendFromSystemPrefs = false;
        } else if ("@system".equals(backendInfo)) {
            backendVisible = true;
            this.backendFromSystemPrefs = true;
        }
        this.backendLabel.setVisible(backendVisible);
        this.backendLabel.setManaged(backendVisible);
        this.backendField.setVisible(backendVisible);
        this.backendField.setManaged(backendVisible);
        this.backendButton.setVisible(backendVisible);
        this.backendButton.setManaged(backendVisible);
        if (backendVisible) {
            this.loadBackendConfigurations();
        } else if (backendInfo != null && (ndx = backendInfo.indexOf(58)) >= 0) {
            String configName = backendInfo.substring(ndx + 1);
            boolean systemPrefs = backendInfo.substring(0, ndx).equals("@system");
            BackendConfiguration backendConfiguration = (BackendConfiguration)BackendConfiguration.getBackendConfigurations((String)sessionInfo.getApplicationName(), (boolean)systemPrefs).get(configName);
            if (backendConfiguration != null) {
                if (backendConfiguration.getUrl().startsWith("rmi:") && backendConfiguration.getUser() != null) {
                    this.usernameField.setText(backendConfiguration.getUser());
                    this.passwordField.setText(backendConfiguration.getPassword());
                }
            } else {
                LOGGER.warning("no such backend configuration: " + configName);
            }
        }
    }

    public void autoLogin() {
        this.autoLogin = true;
        Platform.runLater(() -> {
            this.usernameField.setEditable(false);
            this.passwordField.setEditable(false);
            this.login();
        });
    }

    private void login() {
        if (this.progressBar.getProgress() <= 0.0) {
            this.sessionInfo.setUserName(this.usernameField.getText());
            String pwd = this.passwordField.getText();
            this.sessionInfo.setPassword(pwd == null ? null : pwd.toCharArray());
            BackendConfiguration backendConfiguration = (BackendConfiguration)this.backendField.getValue();
            if (backendConfiguration != null) {
                String backendInfo = this.sessionInfo.getProperties().getProperty("backend") + ":" + backendConfiguration;
                this.sessionInfo.getProperties().setProperty("backend", backendInfo);
            }
            this.setProgress(0.01);
            ((DesktopApplication)AbstractApplication.getRunningApplication()).login(this.getView(), this.sessionInfo);
        } else {
            LOGGER.warning("login already in progress...");
        }
    }

    private void cancel() {
        Fx.getStage((Node)this.getView()).hide();
    }

    public void setProgress(double value) {
        if (value <= 0.0 && !this.autoLogin) {
            this.progressBar.setVisible(false);
            this.progressBar.setProgress(0.0);
            this.loginButton.setDisable(false);
            this.cancelButton.setDisable(false);
            this.usernameField.setChangeable(true);
            this.passwordField.setChangeable(true);
        } else {
            this.progressBar.setVisible(true);
            this.progressBar.setProgress(value);
            this.loginButton.setDisable(true);
            this.cancelButton.setDisable(true);
            this.usernameField.setChangeable(false);
            this.passwordField.setChangeable(false);
        }
    }

    public void setMessage(String message) {
        this.messageLabel.setText(message);
    }

    private void setCapsLockMessage(boolean capsLock) {
        if (capsLock) {
            this.setMessage(this.resources.getString("CAPS LOCK!"));
        } else {
            this.setMessage(null);
        }
    }

    private boolean isCapsLock() {
        return Toolkit.getDefaultToolkit().getLockingKeyState(20);
    }

    private void loadBackendConfigurations() {
        this.backendField.getItems().clear();
        this.backendField.getItems().addAll(BackendConfiguration.getBackendConfigurations((String)this.sessionInfo.getApplicationName(), (boolean)this.backendFromSystemPrefs).values());
    }
}

