/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.translate;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.stage.Modality;
import javafx.stage.Window;
import org.tentackle.bind.Bindable;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.FxFactory;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.FxTextComponent;
import org.tentackle.fx.FxUtilities;
import org.tentackle.fx.ValueTranslatorService;
import org.tentackle.fx.rdc.RdcFxRdcBundle;
import org.tentackle.fx.rdc.RdcUtilities;
import org.tentackle.fx.translate.ValueStringTranslator;
import org.tentackle.log.Logger;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.DomainKey;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PersistentDomainObject;

@ValueTranslatorService(modelClass=PersistentDomainObject.class, viewClass=String.class)
public class PdoStringTranslator<T extends PersistentDomainObject<T>>
extends ValueStringTranslator<T> {
    private static final Logger LOGGER = Logger.get(PdoStringTranslator.class);
    private static final String PDO_STYLE = "tt-pdo-style";
    private ValueStringTranslator<?> udkTranslator;
    private String viewValue;
    private T pdo;
    private boolean inSearchOrEdit;

    public PdoStringTranslator(FxTextComponent component) {
        super(component);
        Class pdoClass = this.getComponent().getType();
        try {
            PersistentDomainObject proxy = Pdo.create((Class)pdoClass);
            Class udkClass = proxy.getUniqueDomainKeyType();
            this.udkTranslator = (ValueStringTranslator)FxFactory.getInstance().createValueTranslator(udkClass, String.class, (FxComponent)component);
            this.udkTranslator.setLenient(true);
            Bindable bindable = this.getBindableAnnotation(proxy);
            if (bindable != null) {
                FxUtilities.getInstance().applyBindingOptions(component, component.getBinding().getMember(), bindable.options());
            }
        }
        catch (RuntimeException proxy) {
            // empty catch block
        }
        Control control = (Control)this.getComponent();
        control.addEventFilter(KeyEvent.ANY, event -> {
            if (!(event.isAltDown() || event.isControlDown() || event.isMetaDown() || event.isShiftDown() || event.isShortcutDown())) {
                if (event.getCode() == KeyCode.F2) {
                    event.consume();
                    if (event.getEventType() == KeyEvent.KEY_PRESSED) {
                        Platform.runLater(this::edit);
                    }
                } else if (event.getCode() == KeyCode.F3) {
                    event.consume();
                    if (event.getEventType() == KeyEvent.KEY_PRESSED) {
                        Platform.runLater(this::search);
                    }
                }
            }
        });
        if (!control.getStyleClass().contains((Object)PDO_STYLE)) {
            control.getStyleClass().add((Object)PDO_STYLE);
            ContextMenu menu = control.getContextMenu();
            if (menu == null) {
                menu = new ContextMenu();
                control.setContextMenu(menu);
            } else {
                menu.getItems().add((Object)new SeparatorMenuItem());
            }
            MenuItem editItem = new MenuItem(RdcFxRdcBundle.getString("EDIT"));
            editItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.F2, new KeyCombination.Modifier[0]));
            editItem.setOnAction(event -> this.edit());
            menu.setOnShowing(event -> editItem.setDisable(this.getPdo() == null));
            MenuItem searchItem = new MenuItem(RdcFxRdcBundle.getString("SEARCH"));
            searchItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.F3, new KeyCombination.Modifier[0]));
            searchItem.setOnAction(event -> this.search());
            menu.getItems().addAll((Object[])new MenuItem[]{editItem, searchItem});
        }
    }

    protected T getPdo() {
        return (T)((PersistentDomainObject)this.getComponent().getBinding().getModelValue());
    }

    protected void edit() {
        if (!this.inSearchOrEdit) {
            this.pdo = this.getPdo();
            if (this.pdo != null) {
                this.inSearchOrEdit = true;
                ObservableList pdoList = FXCollections.observableArrayList();
                pdoList.add(this.pdo);
                this.pdo = RdcUtilities.getInstance().displayCrudStage(this.pdo, pdoList, !this.pdo.isImmutable(), Modality.APPLICATION_MODAL, (Window)Fx.getStage((Node)((Node)this.getComponent())), null);
                this.inSearchOrEdit = false;
            }
        }
    }

    protected void search() {
        if (!this.inSearchOrEdit) {
            this.inSearchOrEdit = true;
            T found = this.searchPdo(this.createPdo());
            if (found != null && this.getComponent().isChangeable()) {
                this.pdo = found;
                this.getComponent().setViewValue(this.pdo);
                this.getComponent().updateModel();
            }
            this.inSearchOrEdit = false;
        }
    }

    public Function<T, String> toViewFunction() {
        return m -> {
            if (m != null) {
                Object udk = m.getUniqueDomainKey();
                this.viewValue = this.udkTranslator != null ? (String)this.udkTranslator.toViewFunction().apply(udk) : udk.toString();
            } else {
                this.viewValue = null;
            }
            this.pdo = m;
            return this.viewValue;
        };
    }

    public Function<String, T> toModelFunction() {
        return v -> {
            if (!this.inSearchOrEdit && !Objects.equals(v, this.viewValue)) {
                if (v == null) {
                    this.pdo = null;
                } else {
                    T proxy = this.createPdo();
                    Class udkClass = proxy.getUniqueDomainKeyType();
                    if (this.udkTranslator != null) {
                        Object udk = this.udkTranslator.toModelFunction().apply(v);
                        this.pdo = proxy.findByUniqueDomainKey(udk);
                        if (this.pdo == null) {
                            proxy.setUniqueDomainKey(udk);
                            this.pdo = this.searchPdo(proxy);
                            Platform.runLater(() -> ((Node)this.getComponent()).requestFocus());
                        }
                    } else {
                        String udk = v;
                        try {
                            if (!udkClass.isAssignableFrom(v.getClass())) {
                                try {
                                    Constructor cons = udkClass.getConstructor(v.getClass());
                                    udk = cons.newInstance(v);
                                }
                                catch (InvocationTargetException ix) {
                                    this.presetSearchCriteria(proxy, udkClass, (String)v);
                                    this.pdo = this.searchPdo(proxy);
                                    Platform.runLater(() -> ((Node)this.getComponent()).requestFocus());
                                    return this.pdo;
                                }
                                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException e) {
                                    throw new FxRuntimeException("could not create domain key: " + udkClass.getName() + "(" + v.getClass().getName() + ")", (Throwable)e);
                                }
                            }
                            this.pdo = proxy.findByUniqueDomainKey((Object)udk);
                            if (this.pdo == null) {
                                this.presetSearchCriteria(proxy, udkClass, (String)v);
                                this.pdo = this.searchPdo(proxy);
                                Platform.runLater(() -> ((Node)this.getComponent()).requestFocus());
                            }
                        }
                        catch (RuntimeException rex) {
                            LOGGER.warning("loading PDO " + proxy.getClassBaseName() + " for " + udkClass + "='" + udk + "' failed", (Throwable)rex);
                            throw rex;
                        }
                    }
                }
            }
            return this.pdo;
        };
    }

    protected T createPdo() {
        FxTextComponent comp = this.getComponent();
        Class pdoClass = comp.getType();
        DomainContext context = comp.getParentContainer() != null ? (DomainContext)comp.getBinding().getBinder().getBindingProperty(DomainContext.class) : (comp.getTableCell() != null ? (DomainContext)comp.getTableCell().getColumnConfiguration().getTableConfiguration().getBinder().getBindingProperty(DomainContext.class) : (DomainContext)((Node)comp).getProperties().get(DomainContext.class));
        if (context == null) {
            throw new FxRuntimeException("missing binding property for DomainContext");
        }
        return (T)Pdo.create((Class)pdoClass, (DomainContext)context);
    }

    protected T searchPdo(T proxy) {
        ObservableList<T> list = RdcUtilities.getInstance().displaySearchStage(proxy, Modality.APPLICATION_MODAL, (Window)Fx.getStage((Node)((Node)this.getComponent())), true);
        if (!list.isEmpty()) {
            return (T)((PersistentDomainObject)list.get(0));
        }
        return null;
    }

    protected void presetSearchCriteria(T proxy, Class<?> udkClass, String v) {
        try {
            Object udk;
            Method m = udkClass.getDeclaredMethod("lenientValueOf", String.class);
            if (Modifier.isStatic(m.getModifiers()) && udkClass.isAssignableFrom(m.getReturnType()) && (udk = m.invoke(null, v)) != null) {
                proxy.setUniqueDomainKey(udk);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e1) {
            throw new FxRuntimeException("cannot create lenient domain key", (Throwable)e1);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    protected Bindable getBindableAnnotation(T proxy) {
        for (Method method : proxy.getEffectiveClass().getMethods()) {
            Bindable bindable;
            if (!method.isAnnotationPresent(DomainKey.class) || (bindable = method.getAnnotation(Bindable.class)) == null) continue;
            return bindable;
        }
        return null;
    }
}

