/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.translate;

import java.util.List;
import javafx.collections.ObservableList;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.ValueTranslatorService;
import org.tentackle.fx.component.FxTableView;
import org.tentackle.fx.component.FxTreeTableView;
import org.tentackle.fx.rdc.GuiProvider;
import org.tentackle.fx.rdc.Rdc;
import org.tentackle.fx.table.TableConfiguration;
import org.tentackle.fx.translate.ObservableListTranslator;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoRuntimeException;
import org.tentackle.pdo.PersistentDomainObject;

@ValueTranslatorService(modelClass=List.class, viewClass=ObservableList.class)
public class PdoObservableListTranslator<T extends PersistentDomainObject<T>, C extends List<T>>
extends ObservableListTranslator<T, C> {
    public PdoObservableListTranslator(FxComponent component) {
        super(component);
    }

    protected void configureTableView(FxTableView<T> tableView, Class<T> elemClass) {
        PdoRuntimeException pdoRuntimeException = null;
        if (PersistentDomainObject.class.isAssignableFrom(elemClass)) {
            PersistentDomainObject pdo;
            try {
                pdo = Pdo.create(elemClass);
            }
            catch (PdoRuntimeException px) {
                pdoRuntimeException = px;
                pdo = null;
            }
            if (pdo != null) {
                GuiProvider<PersistentDomainObject> provider = Rdc.createGuiProvider(pdo);
                TableConfiguration configuration = this.createTableConfiguration(provider);
                configuration.configure(tableView);
                return;
            }
        }
        try {
            super.configureTableView(tableView, elemClass);
        }
        catch (TentackleRuntimeException tx) {
            if (pdoRuntimeException != null) {
                throw pdoRuntimeException;
            }
            throw tx;
        }
    }

    protected void configureTreeTableView(FxTreeTableView<T> treeTableView, Class<T> elemClass) {
        if (PersistentDomainObject.class.isAssignableFrom(elemClass)) {
            PersistentDomainObject pdo = Pdo.create(elemClass);
            GuiProvider<PersistentDomainObject> provider = Rdc.createGuiProvider(pdo);
            TableConfiguration configuration = this.createTableConfiguration(provider);
            configuration.configure(treeTableView);
        } else {
            super.configureTreeTableView(treeTableView, elemClass);
        }
    }
}

