/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.translate;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.scene.Node;
import org.tentackle.bind.Bindable;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.FxFactory;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.FxTextComponent;
import org.tentackle.fx.FxUtilities;
import org.tentackle.fx.ValueTranslatorService;
import org.tentackle.fx.rdc.translate.PdoComponentAddon;
import org.tentackle.fx.rdc.translate.PdoTranslator;
import org.tentackle.fx.translate.ValueStringTranslator;
import org.tentackle.log.Logger;
import org.tentackle.pdo.DomainKey;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PersistentDomainObject;

@ValueTranslatorService(modelClass=PersistentDomainObject.class, viewClass=String.class)
public class PdoStringTranslator<T extends PersistentDomainObject<T>>
extends ValueStringTranslator<T>
implements PdoTranslator<T, String> {
    private static final Logger LOGGER = Logger.get(PdoStringTranslator.class);
    private PdoComponentAddon<T> pdoAddon;
    private ValueStringTranslator<?> udkTranslator;
    private String viewValue;

    public PdoStringTranslator(FxTextComponent component) {
        super(component);
        Class pdoClass = this.getComponent().getType();
        try {
            PersistentDomainObject proxy = Pdo.create((Class)pdoClass);
            Class udkClass = proxy.getUniqueDomainKeyType();
            this.udkTranslator = (ValueStringTranslator)FxFactory.getInstance().createValueTranslator(udkClass, String.class, (FxComponent)component);
            this.udkTranslator.setLenient(true);
            Bindable bindable = this.getBindableAnnotation(proxy);
            if (bindable != null) {
                FxUtilities.getInstance().applyBindingOptions(component, component.getBinding().getMember(), bindable.options());
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.setPdoAddon(this.createPdoAddon());
    }

    @Override
    public PdoComponentAddon<T> getPdoAddon() {
        return this.pdoAddon;
    }

    public void setPdoAddon(PdoComponentAddon<T> pdoAddon) {
        this.pdoAddon = pdoAddon;
    }

    public Function<T, String> toViewFunction() {
        return m -> {
            if (m != null) {
                Object udk = m.getUniqueDomainKey();
                this.viewValue = this.udkTranslator != null ? (String)this.udkTranslator.toViewFunction().apply(udk) : udk.toString();
            } else {
                this.viewValue = null;
            }
            this.pdoAddon.setPdo((PersistentDomainObject)m);
            return this.viewValue;
        };
    }

    public Function<String, T> toModelFunction() {
        return v -> {
            if (!this.pdoAddon.isInSearchOrEdit() && !Objects.equals(v, this.viewValue)) {
                if (v == null) {
                    this.pdoAddon.setPdo(null);
                } else {
                    T proxy = this.pdoAddon.createPdo();
                    Class udkClass = proxy.getUniqueDomainKeyType();
                    if (this.udkTranslator != null) {
                        Object udk = this.udkTranslator.toModelFunction().apply(v);
                        this.pdoAddon.setPdo(proxy.findByUniqueDomainKey(udk));
                        if (this.pdoAddon.getPdo() == null) {
                            proxy.setUniqueDomainKey(udk);
                            this.runSearch(proxy);
                        }
                    } else {
                        String udk = v;
                        try {
                            if (!udkClass.isAssignableFrom(v.getClass())) {
                                try {
                                    Constructor cons = udkClass.getConstructor(v.getClass());
                                    udk = cons.newInstance(v);
                                }
                                catch (InvocationTargetException ix) {
                                    this.presetSearchCriteria(proxy, udkClass, (String)v);
                                    this.runSearch(proxy);
                                    return this.pdoAddon.getPdo();
                                }
                                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException e) {
                                    throw new FxRuntimeException("could not create domain key: " + udkClass.getName() + "(" + v.getClass().getName() + ")", (Throwable)e);
                                }
                            }
                            this.pdoAddon.setPdo(proxy.findByUniqueDomainKey((Object)udk));
                            if (this.pdoAddon.getPdo() == null) {
                                this.presetSearchCriteria(proxy, udkClass, (String)v);
                                this.runSearch(proxy);
                            }
                        }
                        catch (RuntimeException rex) {
                            LOGGER.warning("loading PDO " + proxy.getClassBaseName() + " for " + String.valueOf(udkClass) + "='" + String.valueOf(udk) + "' failed", (Throwable)rex);
                            throw rex;
                        }
                    }
                }
            }
            return this.pdoAddon.getPdo();
        };
    }

    protected void runSearch(T proxy) {
        this.pdoAddon.searchPdo((PersistentDomainObject)proxy, found -> {
            this.pdoAddon.setPdo((PersistentDomainObject)found);
            this.getComponent().setViewValue(found);
            this.getComponent().updateModel();
            Platform.runLater(() -> ((Node)this.getComponent()).requestFocus());
        });
    }

    protected PdoComponentAddon<T> createPdoAddon() {
        return new PdoComponentAddon<PersistentDomainObject>((FxComponent)this.getComponent(), this::getPdo, this::setPdo);
    }

    protected T getPdo() {
        return (T)((PersistentDomainObject)this.getComponent().getBinding().getModelValue());
    }

    protected void setPdo(T pdo) {
        this.getComponent().getBinding().setModelValue(pdo);
        this.pdoAddon.setPdo(pdo);
        this.getComponent().updateView();
    }

    protected void presetSearchCriteria(T proxy, Class<?> udkClass, String v) {
        try {
            Object udk;
            Method m = udkClass.getDeclaredMethod("lenientValueOf", String.class);
            if (Modifier.isStatic(m.getModifiers()) && udkClass.isAssignableFrom(m.getReturnType()) && (udk = m.invoke(null, v)) != null) {
                proxy.setUniqueDomainKey(udk);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e1) {
            throw new FxRuntimeException("cannot create lenient domain key", (Throwable)e1);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    protected Bindable getBindableAnnotation(T proxy) {
        for (Method method : proxy.getEffectiveClass().getMethods()) {
            Bindable bindable;
            if (!method.isAnnotationPresent(DomainKey.class) || (bindable = method.getAnnotation(Bindable.class)) == null) continue;
            return bindable;
        }
        return null;
    }
}

