/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc;

import java.util.ArrayList;
import java.util.Collection;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import org.tentackle.fx.FxUtilities;
import org.tentackle.fx.rdc.GuiProvider;
import org.tentackle.fx.rdc.Rdc;
import org.tentackle.pdo.PersistentDomainObject;

public class PdoTreeItem<T extends PersistentDomainObject<T>>
extends TreeItem<T> {
    private T pdo;
    private GuiProvider<T> provider;
    private boolean childrenLoaded;

    public PdoTreeItem(T pdo) {
        super(pdo);
        this.pdo = pdo;
    }

    public T getPdo() {
        return this.pdo;
    }

    public void setPdo(T pdo) {
        this.setValue(pdo);
        this.pdo = pdo;
        this.provider = null;
        this.childrenLoaded = false;
        super.getChildren().clear();
    }

    public boolean isLeaf() {
        return !this.getGuiProvider().providesTreeChildObjects() || this.childrenLoaded && super.getChildren().isEmpty();
    }

    public ObservableList<TreeItem<T>> getChildren() {
        if (!this.childrenLoaded) {
            this.childrenLoaded = true;
            if (this.getGuiProvider().providesTreeChildObjects()) {
                ArrayList childItems = new ArrayList();
                Object parentPdo = this.getParentPdo();
                Collection<PersistentDomainObject<?>> children = this.getGuiProvider().getTreeChildObjects(parentPdo);
                for (PersistentDomainObject<?> child : children) {
                    childItems.add(Rdc.createGuiProvider(child).createTreeItem());
                }
                super.getChildren().setAll(childItems);
            }
        }
        return super.getChildren();
    }

    public <P extends PersistentDomainObject<P>> PdoTreeItem<P> getParentPdoItem() {
        TreeItem parent = this.getParent();
        return parent instanceof PdoTreeItem ? (PdoTreeItem)parent : null;
    }

    public <P extends PersistentDomainObject<P>> P getParentPdo() {
        PdoTreeItem<P> parentItem = this.getParentPdoItem();
        return parentItem == null ? null : (P)parentItem.getPdo();
    }

    public <P extends PersistentDomainObject<P>> P getParentPdo(Class<P> parentPdoClass) {
        P parentPdo = this.getParentPdo();
        return parentPdo != null && parentPdoClass.isAssignableFrom(parentPdo.getClass()) ? (P)parentPdo : null;
    }

    public GuiProvider<T> getGuiProvider() {
        if (this.provider == null) {
            this.provider = Rdc.createGuiProvider(this.pdo);
        }
        return this.provider;
    }

    public void expand() {
        if (this.isExpanded()) {
            this.collapse();
        }
        FxUtilities.getInstance().expandAll((TreeItem)this);
    }

    public void collapse() {
        FxUtilities.getInstance().collapseAll((TreeItem)this);
    }
}

